webpackJsonp([2,4],{"1Bte":function(t,e){t.exports="data:image/png;base64,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"},"3EQr":function(t,e){},"6r+I":function(t,e){},"8cIS":function(t,e){},"9KJV":function(t,e){},DJ7G:function(t,e){},DWNj:function(t,e){},DdEB:function(t,e){},EsPn:function(t,e){},Kmmg:function(t,e){},OLnf:function(t,e){},T4rw:function(t,e){},Y0Vi:function(t,e,a){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var i=a("CCn6"),s=(a("+TkF"),a("kmJW")),n=a("hFUZ"),o={name:"dialogObj",props:["dialogObj"],data:function(){return{show:!1,id:"",statusOption:[{label:"带班",value:0},{label:"不带班",value:1}],typeOption:[{label:"老师",value:0},{label:"新星妈妈",value:1},{label:"推广人",value:2},{label:"市场",value:3}],loading:!0,type:0,title:"",form:{name:"",type:0,squad:"",qr:"",alias:"",status:0,media_id:""},rules:{name:[{required:!0,message:"请输入名称",trigger:"change"}],qr:[{required:!0,message:"请输入二维码",trigger:"change"}]},teacherDetail:{},imageList:[],uploadShow:!0}},methods:{sub:function(){var t=this;this.imageList.length>0&&(this.form.qr=this.imageList[0].url);var e={name:this.form.name,type:this.form.type,qr:this.form.qr,squad:this.form.squad,alias:this.form.alias,status:this.form.status,media_id:this.form.media_id};switch(this.dialogObj.type){case 2:this.$refs.form.validate(function(a){a&&Object(i._23)(t.id,e).then(function(e){t.$message({type:"success",message:"修改成功!"}),t.$emit("reflash"),t.show=!1})});break;case 0:this.$refs.form.validate(function(a){a&&Object(i.s)(e).then(function(e){t.$message({type:"success",message:"新增成功!"}),t.$emit("reflash"),t.show=!1})})}},beforeAvatarUpload:function(){this.uploadShow=!1},handleRemove:function(){this.uploadShow=!0},handleAvatarSuccess:function(t){this.imageList=[{name:t.data.url,url:"https://cdn.singsingenglish.com/"+t.data.url}]},uploadFile:function(t){var e=this;this.loading=!0,this.$store.dispatch("setProgress",{type:"new",id:t.file.uid}),this.fileUid=t.file.uid,Object(i._210)({file:t.file,type:"all"}).then(function(t){e.form.media_id=t.wechat_info?t.wechat_info.media_id:"",e.imageList=[{name:t.url,url:"https://cdn.singsingenglish.com/"+t.url}],e.uploadShow=!1,e.loading=!1,e.$message({type:"success",message:"上传成功!"})}).catch(function(){e.loading=!1})},initDialog:function(){var t=this;switch(console.log(this.dialogObj),this.dialogObj.type){case 0:this.title="新增教师",this.show=this.dialogObj.show,this.type=0,this.form.name="",this.form.alias="",this.form.qr="",this.form.squad="",this.form.type=0,this.form.status=0,this.imageList=[],this.loading=!1,this.uploadShow=!0,this.form.media_id="";break;case 1:this.title="教师详情",this.show=this.dialogObj.show,this.id=this.dialogObj.id,this.type=1,Object(i._119)(this.id).then(function(e){t.teacherDetail=e,t.loading=!1});break;case 2:this.title="编辑",this.show=this.dialogObj.show,this.id=this.dialogObj.id,this.type=2,Object(i._119)(this.id).then(function(e){t.form.name=e.name,t.form.squad=e.squad,t.form.alias=e.alias,t.form.qr=e.qr,t.form.type=e.type,t.form.status=e.status,t.form.media_id=e.media_id?e.media_id:"",t.imageList=[{name:e.qr,url:e.qr}],t.uploadShow=!e.qr,t.loading=!1})}}},watch:{dialogObj:{handler:function(){this.loading=!0,this.initDialog()},deep:!0},show:function(t){this.$emit("changeShow",t)}}},l={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("el-dialog",{attrs:{title:t.title,center:"","append-to-body":"",visible:t.show,width:"800px"},on:{"update:visible":function(e){t.show=e}}},[a("div",{directives:[{name:"loading",rawName:"v-loading",value:t.loading,expression:"loading"}]},[a("el-form",{ref:"form",attrs:{model:t.form,rules:t.rules}},[1===t.type?a("el-row",[a("el-col",{attrs:{span:4}},[a("label",[t._v("ID")])]),t._v(" "),a("el-col",{attrs:{span:8}},[t._v("\n          "+t._s(t.teacherDetail.id)+"\n        ")]),t._v(" "),a("el-col",{attrs:{span:4}},[a("label",[t._v("创建时间")])]),t._v(" "),a("el-col",{attrs:{span:8}},[t._v(t._s(t.teacherDetail.created_at))])],1):t._e(),t._v(" "),a("el-row",[a("el-col",{attrs:{span:4}},[a("label",[t._v("昵称")])]),t._v(" "),a("el-col",{attrs:{span:8}},[1===t.type?a("span",[t._v(t._s(t.teacherDetail.name))]):t._e(),t._v(" "),1!==t.type?a("el-form-item",{attrs:{prop:"name"}},[a("el-input",{model:{value:t.form.name,callback:function(e){t.$set(t.form,"name",e)},expression:"form.name"}})],1):t._e()],1),t._v(" "),a("el-col",{attrs:{span:4}},[a("label",[t._v("微信号")])]),t._v(" "),a("el-col",{attrs:{span:8}},[1===t.type?a("span",[t._v(t._s(t.teacherDetail.alias))]):t._e(),t._v(" "),1!==t.type?a("el-form-item",[a("el-input",{model:{value:t.form.alias,callback:function(e){t.$set(t.form,"alias",e)},expression:"form.alias"}})],1):t._e()],1)],1),t._v(" "),a("el-row",[a("el-col",{attrs:{span:4}},[a("label",[t._v("状态")])]),t._v(" "),a("el-col",{attrs:{span:8}},[1===t.type?a("span",[t._v(t._s(t.teacherDetail.status))]):t._e(),t._v(" "),1!==t.type?a("el-form-item",[a("el-select",{attrs:{placeholder:"请选择"},model:{value:t.form.status,callback:function(e){t.$set(t.form,"status",e)},expression:"form.status"}},t._l(t.statusOption,function(t){return a("el-option",{key:t.value,attrs:{label:t.label,value:t.value}})}))],1):t._e()],1),t._v(" "),a("el-col",{attrs:{span:4}},[a("label",[t._v("类型")])]),t._v(" "),a("el-col",{attrs:{span:8}},[1===t.type?a("span",[t._v(t._s(t.teacherDetail.type))]):t._e(),t._v(" "),1!==t.type?a("el-form-item",[a("el-select",{attrs:{placeholder:"请选择"},model:{value:t.form.type,callback:function(e){t.$set(t.form,"type",e)},expression:"form.type"}},t._l(t.dialogObj.teacherTypeList,function(t){return a("el-option",{key:t.type,attrs:{label:t.name,value:t.type}})}))],1):t._e()],1)],1),t._v(" "),a("el-row",[a("el-col",{attrs:{span:4}},[a("label",[t._v("二维码")])]),t._v(" "),a("el-col",{attrs:{span:8}},[1===t.type?a("img",{staticClass:"qr-img",attrs:{src:t.teacherDetail.qr}}):t._e(),t._v(" "),1!==t.type?a("el-form-item",[a("el-upload",{class:{disabled:!t.uploadShow},attrs:{action:"/api/public/upload/zone","http-request":t.uploadFile,"before-upload":t.beforeAvatarUpload,"list-type":"picture-card","file-list":t.imageList,"on-success":t.handleAvatarSuccess,"on-remove":t.handleRemove}},[a("i",{staticClass:"el-icon-plus"})])],1):t._e()],1),t._v(" "),1===t.type?[a("el-col",{attrs:{span:4}},[a("label",[t._v("邀请码")])]),t._v(" "),a("el-col",{attrs:{span:8}},[1===t.type?a("span",[t._v(t._s(t.teacherDetail.invite_code))]):t._e()])]:t._e(),t._v(" "),a("el-col",{attrs:{span:4}},[a("label",[t._v("分组")])]),t._v(" "),a("el-col",{attrs:{span:8}},[a("el-select",{attrs:{placeholder:"请选择"},model:{value:t.form.squad,callback:function(e){t.$set(t.form,"squad",e)},expression:"form.squad"}},t._l(10,function(t){return a("el-option",{key:t,attrs:{label:"T"+t,value:t}})}))],1)],2)],1),t._v(" "),1!==t.type?a("span",{staticClass:"dialog-footer",attrs:{slot:"footer"},slot:"footer"},[a("el-button",{on:{click:function(e){t.show=!1}}},[t._v("取 消")]),t._v(" "),a("el-button",{attrs:{type:"primary"},on:{click:t.sub}},[t._v("确 定")])],1):t._e()],1)])},staticRenderFns:[]};var r=a("VU/8")(o,l,!1,function(t){a("9KJV"),a("iAw4")},"data-v-23506381",null).exports,c={},d={name:"index",data:function(){return{transfer:{show:!1,form:{reason:"",reason_name:"",teacher_name:"",teacher_id:"",staff_current_name:"",staff_name:"",staff_id:"",transfer_at:"",rules:{staff_id:[{required:!0,message:"请选择",trigger:"change"}],transfer_at:[{required:!0,message:"请选择",trigger:"change"}],reason:[{required:!0,message:"请选择",trigger:"change"}]}},staff:[0],reasonList:[{id:0,name:"人员入职"},{id:1,name:"人员离职"},{id:2,name:"请假"},{id:3,name:"其它"}]},searchFrom:{name:"",alias:"",status:"0",task_date:this.formatTime(new Date),squad:"1",type:""},dialogDetail:{show:!1,id:""},userList:[],total:0,nowPage:1,limit:20,dialogObj:{type:0,show:!1,id:""},res:null,dialogDetailObj:{show:!1,title:"班级列表",id:""},teacherTypeOption:[{id:0,label:"老师"},{id:1,label:"新星妈妈"}],phoneNumObj:{}}},watch:{"dialogDetail.show":function(t){t||this.getUser()}},components:{Dialog:a("g5CC").a,page:s.a,dialogCom:r,teacherDetail:n.default},filters:{teacherType:function(t){return c[t]}},mounted:function(){var t=this,e=localStorage.getItem("phoneNum");console.log(e),e&&(e=JSON.parse(e),this.phoneNumObj=e),e&&"teacher_leader"!=e.teacher_type?this.$router.push("/teacher/"+e.id):this.getUser(),Object(i._123)().then(function(e){t.dialogObj.teacherTypeList=e;var a={};e.forEach(function(t,e){a[t.type]=t.name}),c=a,console.log(a)})},methods:{onPageChange:function(t){this.nowPage=t,this.getUser()},formatTime:function(t){var e=t.getFullYear(),a=t.getMonth()+1;a<10&&(a="0"+a);var i=t.getDate();return i<10&&(i="0"+i),e+"-"+a+"-"+i},onSizeChange:function(t){this.limit=t,this.nowPage=1,this.getUser()},getUser:function(){var t=this,e={limit:this.limit,page:this.nowPage};(this.searchFrom.type||0===this.searchFrom.type)&&(e.type=this.searchFrom.type),this.searchFrom.status&&(e.status=this.searchFrom.status),this.searchFrom.name&&(e.name=this.searchFrom.name),this.searchFrom.alias&&(e.alias=this.searchFrom.alias),this.searchFrom.task_date&&(e.task_date=this.searchFrom.task_date);var a=localStorage.getItem("phoneNum");a&&(a=JSON.parse(a)),a&&"teacher_leader"==a.teacher_type?e.squad=a.squad:e.squad=this.searchFrom.squad,Object(i._120)(e).then(function(e){t.userList=e.list,t.total=e.total,t.res=e})},transferStaffName:function(t){this.transfer.form.staff_name=this.transfer.staff.find(function(e){return e.id==t}).name},transferReasonName:function(t){this.transfer.form.reason_name=this.transfer.reasonList.find(function(e){return e.id==t}).name},transferToggle:function(t){var e=this;if(this.transfer.show=!this.transfer.show,this.transfer.show){if(0===this.transfer.staff[0]){Object(i._106)({limit:1e3,page:1,status:0}).then(function(t){e.transfer.staff=t.list})}this.$nextTick(function(){e.$refs.transferForm.resetFields(),e.transfer.form.teacher_name=t.name,e.transfer.form.teacher_id=t.id,e.transfer.form.staff_current_name=t.adviser})}else this.$nextTick(function(){e.$refs.transferForm.resetFields()})},transferSave:function(){var t=this;this.$refs.transferForm.validate(function(e){if(!e)return console.log("error submit!!"),!1;t.$confirm('确定将\n            <span style="color: red;">'+t.transfer.form.teacher_name+'</span> 移交给\n            <span style="color: red;">'+t.transfer.form.staff_name+"</span> ?<br>\n            移交开始时间 "+t.transfer.form.transfer_at+" <br>\n            移交原因 "+t.transfer.form.reason_name,"提示",{dangerouslyUseHTMLString:!0,confirmButtonText:"确定",cancelButtonText:"取消",type:"warning"}).then(function(){var e={teacher_id:t.transfer.form.teacher_id,staff_id:t.transfer.form.staff_id,transfer_at:t.transfer.form.transfer_at,reason:t.transfer.form.reason};Object(i._166)(e).then(function(e){t.$message({type:"success",message:"移交成功!"}),t.transferToggle(),t.getUser()})}).catch(function(){t.$message({type:"info",message:"已取消移交"})})})},edit:function(t){this.dialogObj.id=t.id,this.dialogObj.type=2,this.dialogObj.show=!0},add:function(){this.dialogObj.type=0,this.dialogObj.show=!0},detail:function(t){this.dialogObj.id=t.id,this.dialogObj.type=1,this.dialogObj.show=!0},delTeacher:function(t){var e=this;this.$confirm("此操作将删除该账号?","提示",{confirmButtonText:"确定",cancelButtonText:"取消",type:"warning"}).then(function(){Object(i.X)(t.id).then(function(t){e.$message({type:"success",message:"删除成功!"}),e.getUser()})})},changeShow:function(t){this.dialogObj.show=t},classDetail:function(t){this.dialogDetailObj={show:!0,title:t.name+"班级详情",id:t.id}},goToTeacherDetail:function(t){this.dialogDetail.id=t.id,this.dialogDetail.alias=t.alias,this.dialogDetail.name=t.name,this.dialogDetail.adviser=t.adviser,this.dialogDetail.show=!0}}},u={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("div",{staticClass:"user"},[a("el-form",{ref:"searchFrom",attrs:{model:t.searchFrom,size:"mini","label-width":"68px",inline:""}},[a("el-form-item",{attrs:{label:"昵称"}},[a("el-input",{staticStyle:{width:"90px"},model:{value:t.searchFrom.name,callback:function(e){t.$set(t.searchFrom,"name",e)},expression:"searchFrom.name"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"手机号"}},[a("el-input",{staticStyle:{width:"110px"},model:{value:t.searchFrom.alias,callback:function(e){t.$set(t.searchFrom,"alias",e)},expression:"searchFrom.alias"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"老师状态",clearable:""}},[a("el-select",{staticStyle:{width:"88px"},attrs:{clearable:""},on:{change:t.getUser},model:{value:t.searchFrom.status,callback:function(e){t.$set(t.searchFrom,"status",e)},expression:"searchFrom.status"}},[a("el-option",{attrs:{label:"带班",value:"0"}}),t._v(" "),a("el-option",{attrs:{label:"不带班",value:"1"}})],1)],1),t._v(" "),a("el-form-item",{attrs:{label:"教师类型"}},[a("el-select",{staticStyle:{width:"95px"},attrs:{placeholder:"请选择",clearable:""},on:{change:t.getUser},model:{value:t.searchFrom.type,callback:function(e){t.$set(t.searchFrom,"type",e)},expression:"searchFrom.type"}},t._l(t.dialogObj.teacherTypeList,function(t){return a("el-option",{key:t.type,attrs:{label:t.name,value:t.type}})}))],1),t._v(" "),a("el-form-item",{attrs:{label:"任务日期"}},[a("el-date-picker",{staticStyle:{width:"140px"},attrs:{type:"date","value-format":"yyyy-MM-dd",placeholder:"选择日期"},model:{value:t.searchFrom.task_date,callback:function(e){t.$set(t.searchFrom,"task_date",e)},expression:"searchFrom.task_date"}})],1),t._v(" "),a("el-form-item",[a("el-button",{attrs:{type:"primary",plain:""},on:{click:t.getUser}},[t._v("搜索")])],1),t._v(" "),t.$store.state.orderRefund?a("el-form-item",[a("el-button",{attrs:{type:"success",plain:""},on:{click:t.add}},[t._v("新增教师")])],1):t._e()],1),t._v(" "),a("el-tabs",{staticStyle:{background:"white","padding-top":"10px"},attrs:{type:"card"},on:{"tab-click":t.getUser},model:{value:t.searchFrom.squad,callback:function(e){t.$set(t.searchFrom,"squad",e)},expression:"searchFrom.squad"}},t._l(10,function(e){return"teacher_leader"!=t.phoneNumObj.teacher_type?a("el-tab-pane",{key:e,attrs:{label:"T"+e,name:e.toString()}}):t._e()})),t._v(" "),a("el-table",{staticStyle:{width:"100%"},attrs:{size:"mini",data:t.userList,height:"calc(100vh - 335px)"}},[a("el-table-column",{attrs:{prop:"name",width:"250",label:"老师"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("div",{staticStyle:{display:"flex"}},[a("a",{staticClass:"clearfix",attrs:{href:e.row.qr,target:"_blank"}},[a("img",{staticClass:"avatar",attrs:{src:e.row.qr,alt:"二维码"}})]),t._v(" "),a("div",[t._v("\n            老师名："+t._s(e.row.name)+"\n            "),a("br"),t._v("\n            微信号："+t._s(e.row.alias)+"\n            "),a("br"),t._v("\n            类别："+t._s(t._f("teacherType")(e.row.type))+"\n            "),a("br"),t._v("\n            顾问："+t._s(e.row.adviser)+"\n            "),a("br"),t._v("\n            开始时间："),a("span",{staticStyle:{display:"inline-block",width:"72px","vertical-align":"text-top","line-height":"16px"}},[t._v(t._s(e.row.teacher_start))])])])]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"name",label:"添加好友"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n        进班人数："+t._s(e.row.into_class_num)),a("br"),t._v("\n        加老师处理数："+t._s(e.row.add_teacher_exec_num)),a("br"),t._v("\n        加老师成功数："+t._s(e.row.add_teacher_success_num)),a("br"),t._v("\n        成功率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":18,color:Number(e.row.add_teacher_success_rate)>70?"#67C23A":"#f00",percentage:Number(e.row.add_teacher_success_rate)?Number(e.row.add_teacher_success_rate):0}}),t._v(" "),a("br"),t._v("\n        处理率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":18,color:100===Number(e.row.add_teacher_exec_rate)?"#67C23A":"#f00",percentage:Number(e.row.add_teacher_exec_rate)?Number(e.row.add_teacher_exec_rate):0}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"name",label:"召回率"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n        需召回人数："+t._s(e.row.need_recall_num)),a("br"),t._v("\n        已沟通人数："+t._s(e.row.recall_desc_exec_num)),a("br"),t._v("\n        用户回复数："+t._s(e.row.recall_desc_reply_num)),a("br"),t._v("\n        达标率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":18,color:100===Number(e.row.recall_watch_rate)?"#67C23A":"#dd001b",percentage:Number(e.row.recall_watch_rate)?Number(e.row.recall_watch_rate):0}}),t._v(" "),a("br"),t._v("\n        处理率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":18,color:100===Number(e.row.recall_exec_rate)?"#67C23A":"#f00",percentage:Number(e.row.recall_exec_rate)?Number(e.row.recall_exec_rate):0}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"name",label:"意向标记"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n        意向用户数："+t._s(e.row.intention_num)),a("br"),t._v("\n        完课沟通用户数"+t._s(e.row.over_desc_exec_num)),a("br"),t._v("\n        往期活跃用户沟通数："+t._s(e.row.past_desc_exec_num)),a("br"),t._v("\n        标记率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":18,color:"#67C23A",percentage:Number(e.row.over_intention_rate)?Number(e.row.over_intention_rate):0}}),t._v(" "),a("br"),t._v("\n        处理率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":18,color:100===Number(e.row.over_exec_rate)?"#67C23A":"#f00",percentage:Number(e.row.over_exec_rate)?Number(e.row.over_exec_rate):0}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"intention_num",width:"100",label:"意向用户数"}}),t._v(" "),a("el-table-column",{attrs:{prop:"performance",width:"100",label:"当月业绩"}}),t._v(" "),a("el-table-column",{attrs:{width:"320",label:"操作"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{size:"mini",plain:"",type:"primary"},on:{click:function(a){t.goToTeacherDetail(e.row)}}},[t._v("查看详情")]),t._v(" "),t.$store.state.readonly?t._e():a("el-button",{attrs:{size:"mini",plain:"",type:"warning"},on:{click:function(a){t.edit(e.row)}}},[t._v("编辑")]),t._v(" "),t.$store.state.readonly?t._e():a("el-button",{attrs:{size:"mini",plain:"",type:"success"},on:{click:function(a){t.transferToggle(e.row)}}},[t._v("移交")]),t._v(" "),t.$store.state.deletePermission&&!t.$store.state.readonly?a("el-button",{attrs:{size:"mini",plain:"",type:"danger"},on:{click:function(a){t.delTeacher(e.row)}}},[t._v("删除")]):t._e()]}}])})],1),t._v(" "),t.res?a("div",{staticClass:"total-tab"},[a("div",[t._v("总计")]),t._v(" "),a("div",[a("div",[t._v("\n        成功率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":16,color:Number(t.res.add_teacher_success_rate)>70?"#67C23A":"#f00",percentage:Number(t.res.add_teacher_success_rate)?Number(t.res.add_teacher_success_rate):0}}),t._v(" "),a("br"),t._v("\n        处理率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":16,color:100===Number(t.res.add_teacher_exec_rate)?"#67C23A":"#f00",percentage:Number(t.res.add_teacher_exec_rate)?Number(t.res.add_teacher_exec_rate):0}})],1)]),t._v(" "),a("div",[a("div",[t._v("\n      达标率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":16,color:100===Number(t.res.recall_watch_rate)?"#67C23A":"#ff0000",percentage:Number(t.res.recall_watch_rate)?Number(t.res.recall_watch_rate):0}}),t._v(" "),a("br"),t._v("\n      处理率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":16,color:100===Number(t.res.recall_exec_rate)?"#67C23A":"#f00",percentage:Number(t.res.recall_exec_rate)?Number(t.res.recall_exec_rate):0}})],1)]),t._v(" "),a("div",[a("div",[t._v("\n      标记率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":16,color:"#67C23A",percentage:Number(t.res.over_intention_rate)?Number(t.res.over_intention_rate):0}}),t._v(" "),a("br"),t._v("\n      处理率："),a("el-progress",{staticStyle:{display:"inline-block",width:"calc(90% - 50px)"},attrs:{"text-inside":!0,"stroke-width":16,color:100===Number(t.res.over_exec_rate)?"#67C23A":"#f00",percentage:Number(t.res.over_exec_rate)?Number(t.res.over_exec_rate):0}})],1)]),t._v(" "),a("div",[t._v("\n      "+t._s(t.res.intention_num)+"\n    ")]),t._v(" "),a("div",[t._v("\n      "+t._s(t.res.total_money)+"\n    ")]),t._v(" "),a("div")]):t._e(),t._v(" "),a("page",{attrs:{total:t.total,limit:t.limit},on:{pageChange:t.onPageChange,sizeChange:t.onSizeChange}}),t._v(" "),a("dialog-com",{attrs:{dialogObj:t.dialogObj},on:{changeShow:t.changeShow,reflash:t.getUser}}),t._v(" "),a("el-dialog",{attrs:{width:"90%",top:"5vh",visible:t.dialogDetail.show},on:{"update:visible":function(e){t.$set(t.dialogDetail,"show",e)}}},[t.dialogDetail.show?a("div",[a("teacher-detail",{attrs:{parentDetail:t.dialogDetail}})],1):t._e()]),t._v(" "),a("el-dialog",{attrs:{width:"500px",visible:t.transfer.show,title:"移交"},on:{"update:visible":function(e){t.$set(t.transfer,"show",e)}}},[a("el-form",{ref:"transferForm",attrs:{rules:t.transfer.form.rules,model:t.transfer.form,"label-width":"100px"}},[a("el-form-item",{attrs:{label:"当前设备：",prop:"teacher_name"}},[t._v("\n        "+t._s(t.transfer.form.teacher_name)+"\n      ")]),t._v(" "),a("el-form-item",{attrs:{label:"当前顾问：",prop:"staff_current_name"}},[t._v("\n        "+t._s(t.transfer.form.staff_current_name)+"\n      ")]),t._v(" "),a("el-form-item",{attrs:{label:"移交顾问：",prop:"staff_id"}},[a("el-select",{attrs:{filterable:"",placeholder:"请选择",clearable:!1},on:{change:t.transferStaffName},model:{value:t.transfer.form.staff_id,callback:function(e){t.$set(t.transfer.form,"staff_id",e)},expression:"transfer.form.staff_id"}},t._l(t.transfer.staff,function(t,e){return a("el-option",{key:e,attrs:{label:t.name,value:t.id}})}))],1),t._v(" "),a("el-form-item",{attrs:{label:"移交时间：",prop:"transfer_at"}},[a("div",{staticStyle:{display:"flex"}},[a("el-date-picker",{attrs:{clearable:!1,"value-format":"yyyy-MM-dd HH:mm:ss",type:"datetime",placeholder:"选择时间"},model:{value:t.transfer.form.transfer_at,callback:function(e){t.$set(t.transfer.form,"transfer_at",e)},expression:"transfer.form.transfer_at"}})],1)]),t._v(" "),a("el-form-item",{attrs:{label:"移交原因：",prop:"reason"}},[a("el-select",{attrs:{filterable:"",placeholder:"请选择",clearable:!1},on:{change:t.transferReasonName},model:{value:t.transfer.form.reason,callback:function(e){t.$set(t.transfer.form,"reason",e)},expression:"transfer.form.reason"}},t._l(t.transfer.reasonList,function(t,e){return a("el-option",{key:e,attrs:{label:t.name,value:t.id}})}))],1)],1),t._v(" "),a("div",{attrs:{slot:"footer"},slot:"footer"},[a("el-button",{on:{click:t.transferToggle}},[t._v("取消")]),t._v(" "),a("el-button",{attrs:{type:"primary"},on:{click:t.transferSave}},[t._v("确定")])],1)],1)],1)},staticRenderFns:[]};var _=a("VU/8")(d,u,!1,function(t){a("Kmmg")},"data-v-b4673e90",null);e.default=_.exports},YHy9:function(t,e){},g5CC:function(t,e,a){"use strict";var i=a("CCn6"),s=a("+TkF"),n={props:["dialogObj"],data:function(){return{imageList:[],form:{teacher_id:"",max_join_num:"",class_name:"",source:"",qr:""},type:0,classSource:[],teacherList:[],exitTeacherList:[],goodsList:[],periods:{},uploadShow:!0}},methods:{beforeAvatarUpload:function(){this.uploadShow=!1},handleRemove:function(){this.uploadShow=!0},handleAvatarSuccess:function(t){this.imageList=[{name:t.data.url,url:"https://cdn.singsingenglish.com/"+t.data.url}]},uploadFile:function(t){var e=this;this.loading=!0,this.$store.dispatch("setProgress",{type:"new",id:t.file.uid}),this.fileUid=t.file.uid,Object(i._210)({file:t.file,type:"all"}).then(function(t){e.form.media_id=t.wechat_info?t.wechat_info.media_id:"",e.imageList=[{name:t.url,url:"https://cdn.singsingenglish.com/"+t.url}],e.uploadShow=!1,e.loading=!1,e.$message({type:"success",message:"上传成功!"})}).catch(function(){e.loading=!1})},findDifferentArray:function(t,e){var a=[];return t.forEach(function(t){-1===e.findIndex(function(e){return e.teacher_id===t.id})&&a.push(t)}),a},getTeacher:function(){var t=this;Object(i._120)({limit:100,status:0}).then(function(e){t.teacherList=e.list})},getTeacherByPeriods:function(){var t=this;Object(i._120)({limit:100,status:0}).then(function(e){t.teacherList=e.list})},initPage:function(){var t=this;switch(Object(i._104)().then(function(e){t.classSource=e}),this.periods=this.dialogObj.periods,this.dialogObj.type){case 0:this.dialogObj.periodsId||this.getPeriodList(),this.form={teacher_id:"",max_join_num:"",source:"",qr:""},this.type=0,this.uploadShow=!0,this.getTeacher();break;case 1:this.type=1,Object(i._50)(this.dialogObj.id).then(function(e){t.form={teacher_id:parseInt(e.teacher_id),max_join_num:e.max_join_num,class_name:e.class_name,source:e.source},e.qr&&(t.form.qr=e.qr,t.imageList=[{name:e.qr,url:e.qr}]),t.form.media_id=e.media_id?e.media_id:"",t.uploadShow=!e.qr,console.log(t.uploadShow),t.getTeacher()})}},getPeriodList:function(){var t=this;Object(i._66)().then(function(e){e.list.forEach(function(t){t.name="["+s.j[t.goods_type]+"]["+t.current_price/100+"元]"+t.name,t.children=[]}),t.goodsList=e.list,t.periods||Object(i._82)({goods_id:t.goodsList[0].id}).then(function(e){e.list.forEach(function(t){t.name=t.title}),t.goodsList[0].children=e.list,t.periods=e.list[0]})})},onSave:function(){var t=this;this.imageList.length>0&&(this.form.qr=this.imageList[0].url);var e={max_join_num:String(this.form.max_join_num),teacher_id:String(this.form.teacher_id),source:this.form.source,class_name:this.form.class_name,media_id:this.form.media_id};switch(this.form.qr&&(e.qr=this.form.qr),console.log(e),this.dialogObj.type){case 0:var a=this.dialogObj.periodsId?this.dialogObj.periodsId:this.periods.id;Object(i.g)(a,e).then(function(e){t.$message({type:"success",message:"添加成功!"}),t.$emit("reflash",t.periods),t.dialogObj.show=!1});break;case 1:Object(i._11)(this.dialogObj.id,e).then(function(e){t.$message({type:"success",message:"修改成功!"}),t.$emit("reflash",t.periods),t.dialogObj.show=!1})}},handleItemChange:function(t){var e=this;Object(i._82)({goods_id:t[0]}).then(function(a){a.list.forEach(function(t){t.name=t.title}),e.goodsList.find(function(e){return e.id===t[0]}).children=a.list})},changePeriods:function(t){if(t.length>1){var e=this.goodsList.find(function(e){return e.id===t[0]});this.periods=e.children.find(function(e){return e.id===t[1]}),this.getTeacherByPeriods()}},selectName:function(t,e){var a=t.filter(function(t,a){return t.id==e});this.form.class_name=a[0].name+"一班"}},watch:{"dialogObj.show":function(t){t&&this.initPage()}}},o={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("el-dialog",{attrs:{title:t.dialogObj.title,visible:t.dialogObj.show},on:{"update:visible":function(e){t.$set(t.dialogObj,"show",e)}}},[a("el-form",{ref:"form",attrs:{model:t.form,"label-width":"120px"}},[this.dialogObj.periodsId?t._e():a("el-form-item",{attrs:{label:"期数"}},[a("el-cascader",{staticClass:"refresh-cascader-multi width-480",staticStyle:{width:"480px"},attrs:{options:t.goodsList,props:{value:"id",label:"name"}},on:{"active-item-change":t.handleItemChange,change:t.changePeriods}})],1),t._v(" "),a("el-form-item",{attrs:{label:"老师"}},[a("el-select",{attrs:{placeholder:"请选择",filterable:""},on:{change:function(e){t.selectName(t.teacherList,t.form.teacher_id)}},model:{value:t.form.teacher_id,callback:function(e){t.$set(t.form,"teacher_id",e)},expression:"form.teacher_id"}},t._l(t.teacherList,function(t,e){return a("el-option",{key:e,attrs:{label:t.name,value:t.id}})}))],1),t._v(" "),a("el-form-item",{attrs:{label:"班级名称"}},[a("el-input",{staticStyle:{width:"220px"},model:{value:t.form.class_name,callback:function(e){t.$set(t.form,"class_name",e)},expression:"form.class_name"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"最大学员"}},[a("el-input-number",{model:{value:t.form.max_join_num,callback:function(e){t.$set(t.form,"max_join_num",e)},expression:"form.max_join_num"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"活动方案"}},[a("el-select",{staticStyle:{width:"480px"},attrs:{placeholder:"请选择",filterable:"","popper-class":"refresh-select-multi width-480"},model:{value:t.form.source,callback:function(e){t.$set(t.form,"source",e)},expression:"form.source"}},t._l(t.classSource,function(t,e){return a("el-option",{key:e,attrs:{label:t.name,value:t.type}})}))],1)],1),t._v(" "),a("span",{staticClass:"dialog-footer",attrs:{slot:"footer"},slot:"footer"},[a("el-button",{on:{click:function(e){t.dialogObj.show=!1}}},[t._v("取 消")]),t._v(" "),a("el-button",{attrs:{type:"primary"},on:{click:t.onSave}},[t._v("确 定")])],1)],1)},staticRenderFns:[]};var l=a("VU/8")(n,o,!1,function(t){a("OLnf")},"data-v-6973fccd",null);e.a=l.exports},hFUZ:function(t,e,a){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var i=a("CCn6"),s=a("+TkF"),n=(a("xGts"),a("RyfI")),o=a("av4u"),l=a("kmJW"),r={name:"task1",components:{teacherDesc:n.a,page:l.a},props:["teacherId","teacherShow"],data:function(){return{false:!1,task1List:[],task1Detail:{show:!1,list:[],title:"",cur_date:""},task6Show:!1,task6Show2:!1,task7Show:!1,task7Show2:!1,limit:10,total:0,total7:0,into_periods_num:0,into_periods_num7:0,nowPage:1,task6Obj:null,selectedTask6:[],task7Obj:null,selectedTask7:[]}},filters:{USERSTATUSType:function(t){return s.A[t]}},mounted:function(){this.initPage()},methods:{updateContact:function(t){var e=this;Object(i._198)({ids:t.id,user_status:t.user_status}).then(function(){e.$message({type:"success",message:"数据更改成功"}),e.refDesc1()})},updateContact2:function(t){var e=this;console.log(t),console.log(t.id),Object(i._196)({ids:t.id,status:t.status}).then(function(t){e.$message({message:"更新成功",type:"success"})})},handleSelectionChange123:function(t){this.selectedTask6=t,this.selectedTask7=t},editNote:function(t,e){var a=this;this.$prompt("","编辑备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea",inputValue:e||""}).then(function(e){var s=e.value;a.$confirm("确定保存?","提示",{confirmButtonText:"确定",cancelButtonText:"取消",type:"warning"}).then(function(){console.log(s),Object(i._152)({desc:s},t).then(function(t){a.$message({type:"success",message:"编辑备注成功"}),a.selectedTask6=[],a.getTask6(),a.selectedTask7=[],a.getTask7()})})})},editNote2:function(t,e){var a=this;this.$prompt("","编辑备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea",inputValue:e||""}).then(function(e){var s=e.value;a.$confirm("确定保存?","提示",{confirmButtonText:"确定",cancelButtonText:"取消",type:"warning"}).then(function(){console.log(s),Object(i._195)({ids:t,desc:s}).then(function(t){a.$message({type:"success",message:"编辑备注成功"}),a.selectedTask6=[],a.getTask6(),a.selectedTask7=[],a.getTask7()})})})},allDesc6:function(){var t=this;this.selectedTask6.length<1?this.$message({type:"error",message:"请先选择用户"}):this.$prompt("请输入沟通内容","备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea"}).then(function(e){var a=e.value,s=[];t.selectedTask6.forEach(function(t){s.push(t.id)});var n={ids:s.join(),desc:a};Object(i._149)(n).then(function(e){t.$message({type:"success",message:"批量添加备注成功"}),t.selectedTask6=[],t.getTask6()})})},allDesc7:function(){var t=this;this.selectedTask7.length<1?this.$message({type:"error",message:"请先选择用户"}):this.$prompt("请输入沟通内容","备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea"}).then(function(e){var a=e.value,s=[];t.selectedTask7.forEach(function(t){s.push(t.id)}),console.log(s);var n={ids:s.join(","),desc:a};Object(i._195)(n).then(function(e){t.$message({type:"success",message:"批量添加备注成功"}),t.selectedTask7=[],t.getTask7()})})},onPageChange6:function(t){this.nowPage=t,this.getTask6()},onPageChange7:function(t){this.nowPage=t,this.getTask7()},onSizeChange6:function(t){this.limit=t,this.nowPage=1,this.getTask6()},onSizeChange7:function(t){this.limit=t,this.nowPage=1,this.getTask7()},getTask6:function(){var t=this,e={limit:this.limit,page:this.nowPage};Object(i._191)(this.teacherId,e).then(function(e){console.log(e),e.title="外部订单用户",t.task6Obj=e,t.total=e.total,t.into_periods_num=e.into_periods_num})},getTask7:function(){var t=this,e={limit:this.limit,page:this.nowPage};Object(i._192)(this.teacherId,e).then(function(e){console.log(e,618),e.title="外部渠道用户",t.task7Obj=e,t.total7=e.total,t.into_periods_num7=e.into_periods_num})},initPage:function(){var t=this;this.nowPage=1,Object(i._186)(this.teacherId).then(function(e){t.task1List=e}),this.getTask6(),this.getTask7()},objectSpanMethod:function(t){return 5===t.columnIndex?{rowspan:this.task1List.length,colspan:1}:{rowspan:1,colspan:1}},showTask6Detail:function(){this.nowPage=1,this.task6Show=!0},showTask6Detail2:function(){this.nowPage=1,this.task6Show2=!0},showTask7Detail:function(){this.nowPage=1,this.task7Show=!0},showTask7Detail2:function(){this.nowPage=1,this.task7Show2=!0},refDesc1:function(){var t=this;Object(i._186)(this.teacherId).then(function(e){t.task1List=e,e.forEach(function(e){e.cur_date===t.task1Detail.cur_date&&(t.task1Detail.list=t.task1Detail.indexOf("未通过用户列表")<-1?e.done_detail:e.need_add_detail)})})},changeAddTeacher:function(t){var e=this;Object(i.z)(t.id,t.is_add_teacher).then(function(){e.$message({type:"success",message:"数据更改成功"}),e.refDesc1()})},showTask1Detail:function(t,e){console.log(t),this.task1Detail={show:!0,list:e?t.done_detail:t.need_add_detail,title:e?t.cur_date+" 未通过用户列表":t.cur_date+" 待加好友用户列表",cur_date:t.cur_date},this.dialogType=1}}},c={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("div",[a("el-row",{directives:[{name:"show",rawName:"v-show",value:5!=t.teacherShow,expression:"teacherShow != 5"}],attrs:{gutter:20}},[a("el-col",{attrs:{span:16}},[a("el-card",{staticClass:"box-card"},[a("div",{staticClass:"clearfix",attrs:{slot:"header"},slot:"header"},[a("span",{staticStyle:{"font-size":"18px","font-weight":"bold"}},[t._v("任务1：好友添加")])]),t._v(" "),a("el-table",{attrs:{border:"",data:t.task1List,align:"center","header-cell-style":{background:"#e4eff7"}}},[a("el-table-column",{attrs:{prop:"cur_date",label:"时间",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{prop:"total_add_teacher_num",label:"当天进班人数",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{prop:"done_num",label:"未通过人数",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{type:"text",size:"mini"},on:{click:function(a){t.showTask1Detail(e.row,1)}}},[t._v(t._s(e.row.done_num))])]}}])}),t._v(" "),a("el-table-column",{attrs:{"class-name":"hightLight",prop:"need_add_teacher_num",label:"需加好友人数",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{staticStyle:{"font-size":"20px"},attrs:{type:"text",size:"mini"},on:{click:function(a){t.showTask1Detail(e.row)}}},[t._v(t._s(e.row.need_add_teacher_num))])]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"add_rate",label:"完成情况",align:"center",width:"250"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("div",[a("label",{staticStyle:{width:"90px",display:"inline-block","text-align":"right"}},[t._v("好友通过率：")]),t._v(" "),a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:Number(e.row.add_rate)<70?"#f00":"#67C23A",percentage:Number(e.row.add_rate)}})],1),t._v(" "),a("div",[a("label",{staticStyle:{width:"90px",display:"inline-block","text-align":"right"}},[t._v("任务处理率：")]),t._v(" "),a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:100===Number(e.row.done_rate)?"#67C23A":"#f00",percentage:Number(e.row.done_rate)}})],1)]}}])})],1)],1)],1),t._v(" "),a("el-col",{attrs:{span:8}},[a("el-card",{staticClass:"box-card"},[a("div",{staticClass:"clearfix",attrs:{slot:"header"},slot:"header"},[a("span",{staticStyle:{"font-size":"18px","font-weight":"bold"}},[t._v("附加任务:外部用户激活")])]),t._v(" "),a("el-table",{attrs:{border:"",data:t.task6Obj&&t.task6Obj.list?[t.task6Obj]:[],align:"center","header-cell-style":{background:"#e4eff7"}}},[a("el-table-column",{attrs:{prop:"title",label:"标题",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{"class-name":"hightLight",prop:"total",label:"当日需激活人数",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{staticStyle:{"font-size":"20px"},attrs:{type:"text",size:"mini"},on:{click:function(e){t.showTask6Detail()}}},[t._v(t._s(e.row.total))])]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"into_periods_num",label:"当日已激活人数",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{staticStyle:{"font-size":"20px"},attrs:{type:"text",size:"mini"},on:{click:function(e){t.showTask6Detail2()}}},[t._v(t._s(e.row.into_periods_num))])]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"total",label:"激活率",align:"center"},scopedSlots:t._u([{key:"default",fn:function(t){return[a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:Number(t.row.exec_rate)<70?"#f00":"#67C23A",percentage:Number(t.row.exec_rate)}})]}}])})],1),t._v(" "),a("el-table",{attrs:{border:"","show-header":!1,data:t.task7Obj&&t.task7Obj.list?[t.task7Obj]:[],align:"center","header-cell-style":{background:"#e4eff7"}}},[a("el-table-column",{attrs:{prop:"title",label:"标题",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{"class-name":"hightLight",prop:"total",label:"当日需激活人数",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{staticStyle:{"font-size":"20px"},attrs:{type:"text",size:"mini"},on:{click:function(e){t.showTask7Detail()}}},[t._v(t._s(e.row.total))])]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"into_periods_num",label:"当日已激活人数",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{staticStyle:{"font-size":"20px"},attrs:{type:"text",size:"mini"},on:{click:function(e){t.showTask7Detail2()}}},[t._v(t._s(e.row.into_periods_num))])]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"total",label:"激活率",align:"center"},scopedSlots:t._u([{key:"default",fn:function(t){return[a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:Number(t.row.exec_rate)<70?"#f00":"#67C23A",percentage:Number(t.row.exec_rate)}})]}}])})],1)],1)],1)],1),t._v(" "),a("el-dialog",{directives:[{name:"show",rawName:"v-show",value:5!=t.teacherShow,expression:"teacherShow != 5"}],attrs:{"append-to-body":"",visible:t.task7Show,title:"外部渠道待激活列表",width:"85%"},on:{"update:visible":function(e){t.task7Show=e}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc7()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{attrs:{border:"",size:"mini",data:t.task7Obj&&t.task7Obj.list?t.task7Obj.list:[]},on:{"selection-change":t.handleSelectionChange123}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{prop:"name",label:"宝宝昵称",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{prop:"telephone",label:"手机号",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{prop:"goods_id",label:"商品编号"}}),t._v(" "),a("el-table-column",{attrs:{prop:"source",label:"来源"}}),t._v(" "),a("el-table-column",{attrs:{prop:"create_at",label:"激活时间"}}),t._v(" "),a("el-table-column",{attrs:{prop:"status",width:"260px",label:"沟通状态"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-select",{attrs:{size:"medium"},on:{change:function(a){t.updateContact2(e.row)}},model:{value:e.row.status,callback:function(a){t.$set(e.row,"status",a)},expression:"scope.row.status"}},[a("el-option",{attrs:{label:"假号",value:2}}),t._v(" "),a("el-option",{attrs:{label:"没兴趣",value:3}}),t._v(" "),a("el-option",{attrs:{label:"待激活",value:0}})],1)]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"备注",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{width:"100",prop:"desc",label:"操作",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{size:"mini",plain:"",type:"primary"},on:{click:function(a){t.editNote2(e.row.id,e.row.desc)}}},[t._v("编辑备注")])]}}])})],1),t._v(" "),a("page",{attrs:{total:t.total7,limit:t.limit},on:{pageChange:t.onPageChange7,sizeChange:t.onSizeChange7}})],1),t._v(" "),a("el-dialog",{directives:[{name:"show",rawName:"v-show",value:5!=t.teacherShow,expression:"teacherShow != 5"}],attrs:{"append-to-body":"",visible:t.task6Show,title:"外部订单待激活列表",width:"85%"},on:{"update:visible":function(e){t.task6Show=e}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc6()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{attrs:{border:"",size:"mini",data:t.task6Obj&&t.task6Obj.list?t.task6Obj.list:[]},on:{"selection-change":t.handleSelectionChange123}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{prop:"receiver_mobile",label:"手机号",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{prop:"all_num",label:"支付金额"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v(t._s(e.row.money/100)+"元")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"goods_id",label:"商品编号"}}),t._v(" "),a("el-table-column",{attrs:{prop:"invite_type",label:"来源"}}),t._v(" "),a("el-table-column",{attrs:{prop:"created_at",label:"导入时间"}}),t._v(" "),a("el-table-column",{attrs:{prop:"all_num",label:"收货信息",width:"150px"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          姓名："+t._s(e.row.receiver_name)+"\n          "),a("br"),t._v("\n          地址："+t._s(e.row.receiver_province)+t._s(e.row.receiver_city)+t._s(e.row.receiver_area)+t._s(e.row.receiver_address)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"user_status",width:"260px",label:"沟通状态"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-select",{attrs:{size:"medium"},on:{change:function(a){t.updateContact(e.row)}},model:{value:e.row.user_status,callback:function(a){t.$set(e.row,"user_status",a)},expression:"scope.row.user_status"}},[a("el-option",{attrs:{label:"手机号不是微信号",value:1}}),t._v(" "),a("el-option",{attrs:{label:"待通过",value:2}}),t._v(" "),a("el-option",{attrs:{label:"已加微信未激活",value:3}}),t._v(" "),a("el-option",{attrs:{label:"第一次电话无人接/挂断/关机",value:4}}),t._v(" "),a("el-option",{attrs:{label:"第二次电话无人接/挂断/关机",value:5}}),t._v(" "),a("el-option",{attrs:{label:"第三次电话无人接/挂断/关机",value:6}}),t._v(" "),a("el-option",{attrs:{label:"用户已拒绝",value:7}}),t._v(" "),a("el-option",{attrs:{label:"手机号是空号",value:8}}),t._v(" "),a("el-option",{attrs:{label:"待处理",value:0}})],1)]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"备注",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{width:"100",prop:"desc",label:"操作",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{size:"mini",plain:"",type:"primary"},on:{click:function(a){t.editNote(e.row.id,e.row.desc)}}},[t._v("编辑备注")])]}}])})],1),t._v(" "),a("page",{attrs:{total:t.total,limit:t.limit},on:{pageChange:t.onPageChange6,sizeChange:t.onSizeChange6}})],1),t._v(" "),a("el-dialog",{directives:[{name:"show",rawName:"v-show",value:5!=t.teacherShow,expression:"teacherShow != 5"}],attrs:{"append-to-body":"",visible:t.task7Show2,title:"外部渠道已激活列表",width:"85%"},on:{"update:visible":function(e){t.task7Show2=e}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc7()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{attrs:{border:"",size:"mini",data:t.task7Obj&&t.task7Obj.into_periods_list?t.task7Obj.into_periods_list:[]},on:{"selection-change":t.handleSelectionChange123}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{prop:"name",label:"宝宝昵称",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{prop:"telephone",label:"手机号",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{prop:"goods_id",label:"商品编号"}}),t._v(" "),a("el-table-column",{attrs:{prop:"source",label:"来源"}}),t._v(" "),a("el-table-column",{attrs:{prop:"create_at",label:"激活时间"}}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"备注",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{width:"100",prop:"desc",label:"操作",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{size:"mini",plain:"",type:"primary"},on:{click:function(a){t.editNote2(e.row.id,e.row.desc)}}},[t._v("编辑备注")])]}}])})],1),t._v(" "),a("page",{attrs:{total:t.into_periods_num7,limit:t.limit},on:{pageChange:t.onPageChange7,sizeChange:t.onSizeChange7}})],1),t._v(" "),a("el-dialog",{directives:[{name:"show",rawName:"v-show",value:5!=t.teacherShow,expression:"teacherShow != 5"}],attrs:{"append-to-body":"",visible:t.task6Show2,title:"外部订单已激活列表",width:"85%"},on:{"update:visible":function(e){t.task6Show2=e}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc6()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{attrs:{border:"",size:"mini",data:t.task6Obj&&t.task6Obj.into_periods_list?t.task6Obj.into_periods_list:[]},on:{"selection-change":t.handleSelectionChange123}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{staticClass:"f-c",attrs:{label:"用户","min-width":"180",prop:"user_id"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticStyle:{width:"40px","min-width":"40px",height:"40px","border-radius":"50px"},attrs:{src:e.row.avatar}}),t._v("\n          "+t._s(e.row.nickname)+"(ID:"+t._s(e.row.user_id)+")\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"receiver_mobile",label:"手机号",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{prop:"all_num",label:"支付金额"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v(t._s(e.row.money/100)+"元")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"goods_id",label:"商品编号"}}),t._v(" "),a("el-table-column",{attrs:{prop:"periods_id",label:"期数"}}),t._v(" "),a("el-table-column",{attrs:{prop:"invite_type",label:"来源"}}),t._v(" "),a("el-table-column",{attrs:{prop:"periods_title",label:"期数名称"}}),t._v(" "),a("el-table-column",{attrs:{prop:"created_at",label:"导入时间"}}),t._v(" "),a("el-table-column",{attrs:{prop:"active_at",label:"激活时间"}}),t._v(" "),a("el-table-column",{attrs:{prop:"all_num",label:"收货信息",width:"150px"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          姓名："+t._s(e.row.receiver_name)+"\n          "),a("br"),t._v("\n          地址："+t._s(e.row.receiver_province)+t._s(e.row.receiver_city)+t._s(e.row.receiver_area)+t._s(e.row.receiver_address)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"备注",align:"center"}}),t._v(" "),a("el-table-column",{attrs:{width:"100",prop:"desc",label:"操作",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{size:"mini",plain:"",type:"primary"},on:{click:function(a){t.editNote(e.row.id,e.row.desc)}}},[t._v("编辑备注")])]}}])})],1),t._v(" "),a("page",{attrs:{total:t.into_periods_num,limit:t.limit},on:{pageChange:t.onPageChange6,sizeChange:t.onSizeChange6}})],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.task1Detail.show,title:t.task1Detail.title,width:"80%"},on:{"update:visible":function(e){t.$set(t.task1Detail,"show",e)}}},[a("el-table",{attrs:{data:t.task1Detail.list,size:"mini",fixed:""}},[a("el-table-column",{staticClass:"f-c",attrs:{label:"用户","min-width":"180",prop:"user_id"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticStyle:{width:"40px","min-width":"40px",height:"40px","border-radius":"50px"},attrs:{src:e.row.avatar}}),t._v("\n          "+t._s(e.row.nickname)+"(ID:"+t._s(e.row.user_id)+")\n          "),a("br"),t._v("\n          Tel:"+t._s(e.row.mobile)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"期数",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("【"+t._s(e.row.periods_id)+"】"+t._s(e.row.periods_title))]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"是否添加老师","min-width":"160",prop:"is_add_teacher"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-select",{attrs:{size:"mini"},on:{change:function(a){t.changeAddTeacher(e.row)}},model:{value:e.row.is_add_teacher,callback:function(a){t.$set(e.row,"is_add_teacher",a)},expression:"scope.row.is_add_teacher"}},[a("el-option",{attrs:{label:"老师主动添加",value:1}}),t._v(" "),a("el-option",{attrs:{label:"用户主动添加",value:2}}),t._v(" "),a("el-option",{attrs:{label:"待通过",value:3}}),t._v(" "),a("el-option",{attrs:{label:"手机号不是微信号",value:4}}),t._v(" "),a("el-option",{attrs:{label:"用户已拒绝",value:5}}),t._v(" "),a("el-option",{attrs:{label:"暂未处理",value:0}})],1)]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"沟通情况",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("teacher-desc",{attrs:{teacherId:t.teacherId,row:e.row,descType:2},on:{onSuccess:t.refDesc1}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"created_at",label:"入课时间","min-width":"140px",align:"center",sortable:""}})],1)],1)],1)},staticRenderFns:[]};var d=a("VU/8")(r,c,!1,function(t){a("DdEB")},"data-v-068fb968",null).exports,u=a("xwxU"),_={name:"task2",props:["teacherId"],components:{teacherDesc:n.a,userWeight:o.a,sourceByDateDialog:u.a},data:function(){return{sourceByDateDialogJson:{},task2List:[],lookDetail:{show:!1,loading:!1,list:[],nowPage:1,data:null,limit:500,total:0},selectedTask3:[],task2Detail:{show:!1,list:[],type:1,weight:""}}},mounted:function(){this.initPage()},methods:{handleSelectionChange123:function(t){this.selectedTask3=t},allDesc3:function(){var t=this;this.selectedTask3.length<1?this.$message({type:"error",message:"请先选择用户"}):this.$prompt("请输入沟通内容","备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea"}).then(function(e){var a=e.value,s=[];t.selectedTask3.forEach(function(t){s.push(t.id)});var n={ids:s.join(),desc:a,type:1};Object(i.w)(n).then(function(e){t.$message({type:"success",message:"批量添加备注成功"}),t.refDesc2()})})},onLookDetailPageChange:function(t){this.lookDetail.nowPage=t,this.showLook()},onLookDetailSizeChange:function(t){this.lookDetail.limit=t,this.lookDetail.nowPage=1,this.showLook()},showLook:function(t){console.log(t),this.sourceByDateDialogJson={periods_id:t.periods_id,user_id:t.user_id,json:{limit:10,page:0}},this.$refs.sourceByDateDialogDom.dialogShow=!0},initPage:function(){var t=this;Object(i._187)(this.teacherId).then(function(e){t.task2List=e})},changeWeight:function(t){var e=this;Object(i._26)(t.id,t.weight).then(function(){e.$message({type:"success",message:"数据更改成功"}),e.refDesc2()})},showTask2Detail:function(t){this.task2Detail={show:!0,list:t.detail,title:"意向等级为"+t.weight+"的用户列表",weight:t.weight},this.task2Detail.type=1},refDesc2:function(){var t=this;Object(i._187)(this.teacherId).then(function(e){t.task2List=e;var a=!0;e.forEach(function(e){e.weight===t.task2Detail.weight&&(t.task2Detail.list=e.detail,a=!1)}),a&&(t.task2Detail.list=[])})}}},h={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("div",[a("el-card",{staticClass:"box-card"},[a("div",{staticClass:"clearfix",attrs:{slot:"header"},slot:"header"},[a("span",{staticStyle:{"font-size":"18px","font-weight":"bold"}},[t._v("任务4：意向用户转化")])]),t._v(" "),a("el-table",{attrs:{border:"",data:t.task2List,align:"center","header-cell-style":{background:"#e4eff7"}}},[a("el-table-column",{attrs:{prop:"weight",label:"意向等级",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[100!==e.row.weight?a("span",[t._v("\n            "+t._s(e.row.weight)+"\n          ")]):t._e(),t._v(" "),100===e.row.weight?a("span",[t._v("\n            无法成为意向\n          ")]):t._e()]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"total_num",label:"总人数",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{type:"text",size:"mini"},on:{click:function(a){t.showTask2Detail(e.row)}}},[t._v(t._s(e.row.total_num))])]}}])})],1)],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.task2Detail.show,title:t.task2Detail.title,width:"80%"},on:{"update:visible":function(e){t.$set(t.task2Detail,"show",e)}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc3()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{staticStyle:{width:"100%"},attrs:{data:t.task2Detail.list,size:"mini",fixed:""},on:{"selection-change":t.handleSelectionChange123}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户",className:"f-c","min-width":"180",prop:"user_id"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticStyle:{width:"40px","min-width":"40px",height:"40px","border-radius":"50px"},attrs:{src:e.row.avatar}}),t._v(" "+t._s(e.row.nickname)+"(ID:"+t._s(e.row.user_id)+")\n          "),a("br"),t._v(" Tel:"+t._s(e.row.mobile)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"期数",align:"center"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          【"+t._s(e.row.periods_id)+"】"+t._s(e.row.periods_title)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{"min-width":"160",label:"沟通情况"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("teacher-desc",{attrs:{teacherId:t.teacherId,row:e.row,descType:1},on:{onSuccess:t.refDesc2}})]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"意向等级","min-width":"95",prop:"weight"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("user-weight",{attrs:{row:e.row},on:{onSuccess:t.refDesc2}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"last_watch_at",label:"最后标注时间"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n        "+t._s(e.row.last_weight_at?e.row.last_weight_at:"-")+"\n      ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"last_weight_desc",label:"标注意向原因"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          "+t._s(e.row.last_weight_desc?e.row.last_weight_desc:"-")+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"操作",width:"200px",fixed:"right"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{type:"info",size:"mini"},on:{click:function(a){t.showLook(e.row)}}},[t._v("看课情况")])]}}])})],1)],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.lookDetail.show},on:{"update:visible":function(e){t.$set(t.lookDetail,"show",e)}}},[a("el-table",{directives:[{name:"loading",rawName:"v-loading",value:t.lookDetail.loading,expression:"lookDetail.loading"}],staticStyle:{width:"100%"},attrs:{data:t.lookDetail.list}},[a("el-table-column",{attrs:{prop:"start_at",label:"日期"}}),t._v(" "),a("el-table-column",{attrs:{label:"爸妈看一看"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 1===t.page_id})?a("span",[t._v("\n            "+t._s(e.row.watch_list.find(function(t){return 1===t.page_id}).stay_time)+"\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 1===t.page_id})?t._e():a("span",[t._v("\n            暂未上课\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"宝贝玩一玩"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 2===t.page_id})?a("span",[t._v("\n            "+t._s(e.row.watch_list.find(function(t){return 2===t.page_id}).stay_time)+"\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 2===t.page_id})?t._e():a("span",[t._v("\n            暂未上课\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"爸妈秀宝贝"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 3===t.page_id})?a("span",[a("div",{domProps:{innerHTML:t._s(e.row.watch_list.find(function(t){return 3===t.page_id}).learn_report)}})]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 3===t.page_id})?t._e():a("span",[t._v("\n            暂未秀宝贝\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"多元趣味课"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 5===t.page_id})?a("span",[t._v("\n            "+t._s(e.row.watch_list.find(function(t){return 5===t.page_id}).stay_time)+"\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 5===t.page_id})?t._e():a("span",[t._v("\n            暂未上课\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"分享"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 4===t.page_id})?a("span",[t._v("\n            已分享\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 4===t.page_id})?t._e():a("span",[t._v("\n            暂未分享\n          ")])]}}])})],1)],1),t._v(" "),a("sourceByDateDialog",{ref:"sourceByDateDialogDom",attrs:{dialogObj:t.sourceByDateDialogJson}})],1)},staticRenderFns:[]};var p=a("VU/8")(_,h,!1,function(t){a("DJ7G")},"data-v-4fd7c583",null).exports,m={name:"task3",components:{teacherDesc:n.a,userWeight:o.a,sourceByDateDialog:u.a},props:["task3List","teacherId"],data:function(){return{sourceByDateDialogJson:{},task3Detail:{show:!1,list:[],is_true:"",is_watch:"",loading:!1,periods_id:"",cur_date:"",title:"",type:0},task4Detail:{show:!1,list:[],is_true:"",is_watch:"",loading:!1,periods_id:"",cur_date:"",title:"",type:0},selectedTask3:[],selectedTask4:[],lookDetail:{show:!1,loading:!1,list:[],nowPage:1,data:null,limit:500,total:0}}},filters:{ADDTEACHER:function(t){var e="";return 0===t?e="暂未处理":1===t?e="老师主动添加用户":2===t?e="用户主动添加老师":3===t?e="待通过":4===t?e="手机号不是微信号":5===t&&(e="用户已拒绝"),e}},methods:{periodName:function(t){var e="";return t.title?(t.goods_id&&(e+="【"+t.goods_id+"】"),t.title&&(e+=t.title+"<br>"),t.watch_num&&(e+=t.watch_num+"课时"),t.start_at&&(e+="（"+t.start_at.slice(5).replace("-","")+"）"),(t.has_watch_num||0==t.has_watch_num)&&(e+="-d"+t.has_watch_num)):e="-",e},showSourceByDate:function(t){this.sourceByDateDialogJson={periods_id:t.periods_id,user_id:t.user_id,json:{limit:10,page:0}},this.$refs.sourceByDateDialogDom.dialogShow=!0},allDesc4:function(){var t=this;this.selectedTask4.length<1?this.$message({type:"error",message:"请先选择用户"}):this.$prompt("请输入沟通内容","备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea"}).then(function(e){var a=e.value,s=[];t.selectedTask4.forEach(function(t){s.push(t.id)});var n={ids:s.join(),desc:a,type:0===t.this.task4Detail.is_watch?2:1};Object(i.w)(n).then(function(e){t.$message({type:"success",message:"批量添加备注成功"}),t.refDesc4()})})},allDesc3:function(){var t=this;this.selectedTask3.length<1?this.$message({type:"error",message:"请先选择用户"}):this.$prompt("请输入沟通内容","备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea"}).then(function(e){var a=e.value,s=[];t.selectedTask3.forEach(function(t){s.push(t.id)});var n={ids:s.join(),desc:a,type:2};Object(i.w)(n).then(function(e){t.$message({type:"success",message:"批量添加备注成功"}),t.refDesc3()})})},handleSelectionChange124:function(t){this.selectedTask4=t},handleSelectionChange123:function(t){this.selectedTask3=t},refDesc3:function(){var t=this;Object(i._95)(this.task3Detail.periods_id,this.teacherId,{}).then(function(e){t.task3Detail.loading=!1,t.task3Detail.list=e,t.selectedTask3=[]}),this.$emit("refDesc3")},refDesc4:function(){var t=this,e={is_true:this.task4Detail.is_true,is_watch:this.task4Detail.is_watch,cur_date:this.task4Detail.cur_date};this.task4Detail.show=!0,this.task4Detail.loading=!0,this.task4Detail.type=1,this.dialogType=3,Object(i._138)(this.task4Detail.periods_id,this.teacherId,e).then(function(e){t.selectedTask4=[],t.task4Detail.loading=!1,t.task4Detail.list=e}),this.$emit("refDesc3")},showLook:function(t,e){var a=void 0;a=e?this.task4Detail.periods_id:this.task3Detail.periods_id,this.sourceByDateDialogJson={periods_id:a,user_id:t.user_id,json:{limit:10,page:0}},this.$refs.sourceByDateDialogDom.dialogShow=!0},showRecallDetail:function(t){var e=this;this.task3Detail.show=!0,this.task3Detail.loading=!0,this.task3Detail.periods_id=t.periods_id,this.task3Detail.type=3,this.task3Detail.title=t.title+" 今日需要招回学员",this.dialogType=3,Object(i._95)(t.periods_id,this.teacherId,{}).then(function(t){e.task3Detail.loading=!1,e.task3Detail.list=t,e.selectedTask3=[]})},showTask3Detail:function(t,e,a,s){var n=this,o={is_true:e,is_watch:a,cur_date:s};this.selectedTask4=[],this.task4Detail.show=!0,this.task4Detail.loading=!0,this.task4Detail.is_true=e,this.task4Detail.periods_id=t.periods_id,this.task4Detail.is_watch=a,this.task4Detail.cur_date=s,this.task4Detail.type=1,this.dialogType=3,this.task4Detail.title="【"+t.periods_id+"】"+t.title+" "+(1===e?"已":"未")+(1===a?"看课":"打卡")+"学员",Object(i._138)(t.periods_id,this.teacherId,o).then(function(t){n.task4Detail.loading=!1,n.task4Detail.list=t})}}},f={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("div",[a("el-card",[a("div",{staticClass:"clearfix",attrs:{slot:"header"},slot:"header"},[a("span",{staticStyle:{"font-size":"18px","font-weight":"bold"}},[t._v("任务2：用户召回")])]),t._v(" "),!t.task3List||t.task3List.length<1?a("div",{staticStyle:{color:"#DDDDDD","text-align":"center"}},[t._v("\n      ——暂无数据——\n    ")]):t._e(),t._v(" "),t._l(t.task3List,function(e){return a("div",{staticClass:"task3-table"},[a("div",{staticClass:"table"},[a("div",{staticClass:"title",staticStyle:{width:"8%"}},[a("div",{staticClass:"header bg-h"},[t._v("期数名称")]),t._v(" "),a("div",[a("div",{domProps:{innerHTML:t._s(t.periodName(e))}})])]),t._v(" "),a("div",{staticClass:"total"},[a("div",{staticClass:"header bg-h"},[t._v("班级人数")]),t._v("\n          "+t._s(e.total_user)+"\n        ")]),t._v(" "),a("div",{staticClass:"log-list header-title bg-h"},[a("div",{staticStyle:{height:"19px","line-height":"19px"}},[t._v("日期")]),t._v(" "),a("div",{staticStyle:{height:"28px","line-height":"28px"}},[t._v("未看课人数")]),t._v(" "),a("div",{staticStyle:{height:"28px","line-height":"28px"}},[t._v("总看课人数")]),t._v(" "),a("div",{staticStyle:{height:"28px","line-height":"28px"}},[t._v("总打卡人数")]),t._v(" "),a("div",{staticStyle:{height:"19px","line-height":"19px"}},[t._v("看课率")])]),t._v(" "),a("div",{staticStyle:{display:"table-cell","max-width":"calc(80vw - 800px )","min-width":"0",overflow:"auto"}},t._l(e.watch_log,function(i){return 1===i.is_start_course?a("div",{staticClass:"log-list",staticStyle:{display:"table-cell"}},[a("div",{staticClass:" bg-h",staticStyle:{height:"19px","line-height":"19px"}},[t._v(t._s(i.cur_date))]),t._v(" "),a("div",{staticStyle:{height:"28px","line-height":"28px"}},[1!==i.is_start_course?a("span",[t._v("-")]):t._e(),t._v(" "),1===i.is_start_course?a("el-button",{attrs:{size:"mini",type:"text"},on:{click:function(a){t.showTask3Detail(e,0,1,i.cur_date)}}},[t._v(t._s(i.total_no_watch_num))]):t._e()],1),t._v(" "),a("div",{staticStyle:{height:"28px","line-height":"28px"}},[1!==i.is_start_course?a("span",[t._v("-")]):t._e(),t._v(" "),1===i.is_start_course?a("el-button",{attrs:{size:"mini",type:"text"},on:{click:function(a){t.showTask3Detail(e,1,1,i.cur_date)}}},[t._v(t._s(i.total_watch_num))]):t._e()],1),t._v(" "),a("div",{staticStyle:{height:"28px","line-height":"28px"}},[1!==i.is_start_course?a("span",[t._v("-")]):t._e(),t._v(" "),1===i.is_start_course?a("el-button",{attrs:{size:"mini",type:"text"},on:{click:function(a){t.showTask3Detail(e,1,0,i.cur_date)}}},[t._v(t._s(i.total_work_num))]):t._e()],1),t._v(" "),a("div",{staticStyle:{height:"19px","line-height":"19px"}},[1!==i.is_start_course?a("span",[t._v("-")]):t._e(),t._v(" "),1===i.is_start_course?a("span",[t._v(t._s(i.watch_rate)+"%")]):t._e()])]):t._e()})),t._v(" "),a("div",{staticClass:"recall",staticStyle:{"background-color":"#fffbe4"}},[a("div",{staticClass:"header bg-h"},[t._v("今日需召回人数")]),t._v(" "),a("el-button",{staticStyle:{"font-size":"30px","text-decoration":"underline"},attrs:{size:"mini",type:"text"},on:{click:function(a){t.showRecallDetail(e)}}},[t._v(t._s(e.need_recall_user_num))])],1),t._v(" "),a("div",{staticClass:"recall_process"},[a("div",{staticClass:"header bg-h"},[t._v("完成情况")]),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px"}},[t._v("需达标看课率："+t._s(e.standards_rate)+"%")]),t._v(" "),a("br"),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px"}},[t._v("老师已沟通："+t._s(e.total_desc_num)+"人")]),t._v(" "),a("br"),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px"}},[t._v("任务完成率：\n            "),a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:100===Number(e.recall_watch_rate)?"#67C23A":"#ff0000",percentage:Number(e.recall_watch_rate?e.recall_watch_rate:0)}})],1),t._v(" "),a("br"),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px"}},[t._v("任务处理率：\n            "),a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:100===Number(e.desc_rate)?"#67C23A":"#f00",percentage:Number(e.desc_rate)}})],1)])])])})],2),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.task3Detail.show,width:"80%",title:t.task3Detail.title},on:{"update:visible":function(e){t.$set(t.task3Detail,"show",e)}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc3()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{directives:[{name:"loading",rawName:"v-loading",value:t.task3Detail.loading,expression:"task3Detail.loading"}],staticStyle:{width:"100%"},attrs:{data:t.task3Detail.list,size:"mini",fixed:""},on:{"selection-change":t.handleSelectionChange123}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户",className:"f-c","min-width":"180",prop:"user_id"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticStyle:{width:"40px","min-width":"40px",height:"40px","border-radius":"50px"},attrs:{src:e.row.avatar}}),t._v(" "+t._s(e.row.nickname)+"(ID:"+t._s(e.row.user_id)+")\n          "),a("br"),t._v(" Tel:"+t._s(e.row.mobile)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{"min-width":"160",label:"沟通情况"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("teacher-desc",{attrs:{teacherId:t.teacherId,row:e.row,descType:2},on:{onSuccess:t.refDesc3}})]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"用户反馈"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.is_reply?a("span",[e.row.reply_content?a("span",[t._v(t._s(e.row.reply_content))]):t._e(),t._v(" "),e.row.reply_content&&""!==e.row.reply_content?t._e():a("span",[t._v("已回复")])]):t._e(),t._v(" "),e.row.is_reply?t._e():a("span",{staticStyle:{color:"red"}},[t._v("尚未回复")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"进班时间","min-width":"200",sortable:"",prop:"created_at"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户属性","min-width":"200",sortable:"",prop:"last_login_at"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          最后登录时间："+t._s(e.row.last_login_at)+"\n          "),a("br"),t._v("\n          是否添加老师："+t._s(t._f("ADDTEACHER")(e.row.is_add_teacher))+"\n          "),a("br"),t._v("\n          用户意向等级："+t._s(e.row.weight)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"操作",width:"100px",fixed:"right"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{type:"primary ",size:"small"},on:{click:function(a){t.showLook(e.row)}}},[t._v("看课情况")])]}}])})],1)],1),t._v(" "),a("sourceByDateDialog",{ref:"sourceByDateDialogDom",attrs:{dialogObj:t.sourceByDateDialogJson}}),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.task4Detail.show,width:"80%",title:t.task4Detail.title},on:{"update:visible":function(e){t.$set(t.task4Detail,"show",e)}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc4()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{directives:[{name:"loading",rawName:"v-loading",value:t.task4Detail.loading,expression:"task4Detail.loading"}],staticStyle:{width:"100%"},attrs:{data:t.task4Detail.list,size:"mini",fixed:""},on:{"selection-change":t.handleSelectionChange124}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户",className:"f-c","min-width":"180",prop:"user_id"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticStyle:{width:"40px","min-width":"40px",height:"40px","border-radius":"50px"},attrs:{src:e.row.avatar}}),t._v(" "+t._s(e.row.nickname)+"(ID:"+t._s(e.row.user_id)+")\n          "),a("br"),t._v(" Tel:"+t._s(e.row.mobile)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{"min-width":"160",label:"沟通情况"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("teacher-desc",{attrs:{teacherId:t.teacherId,row:e.row,descType:2},on:{onSuccess:t.refDesc4}})]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"用户反馈"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.is_reply?a("span",[e.row.reply_content?a("span",[t._v(t._s(e.row.reply_content))]):t._e(),t._v(" "),e.row.reply_content&&""!==e.row.reply_content?t._e():a("span",[t._v("已回复")])]):t._e(),t._v(" "),e.row.is_reply?t._e():a("span",{staticStyle:{color:"red"}},[t._v("尚未回复")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"进班时间","min-width":"200",sortable:"",prop:"created_at"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户属性","min-width":"200",sortable:"",prop:"last_login_at"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          最后登录时间："+t._s(e.row.last_login_at)+"\n          "),a("br"),t._v("\n          是否添加老师："+t._s(t._f("ADDTEACHER")(e.row.is_add_teacher))+"\n          "),a("br"),t._v("\n          用户意向等级："+t._s(e.row.weight)+"\n        ")]}}])}),t._v(" "),0!==t.task4Detail.is_true||1!==t.task4Detail.is_watch?a("el-table-column",{attrs:{label:"意向等级","min-width":"95",prop:"weight"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("user-weight",{attrs:{row:e.row},on:{onSuccess:t.refDesc4}})]}}])}):t._e(),t._v(" "),0!==t.task4Detail.is_true||1!==t.task4Detail.is_watch?a("el-table-column",{attrs:{prop:"last_watch_at",label:"最后标注时间"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          "+t._s(e.row.last_weight_at?e.row.last_weight_at:"-")+"\n        ")]}}])}):t._e(),t._v(" "),0!==t.task4Detail.is_true||1!==t.task4Detail.is_watch?a("el-table-column",{attrs:{prop:"last_weight_desc",label:"标注意向原因"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          "+t._s(e.row.last_weight_desc?e.row.last_weight_desc:"-")+"\n        ")]}}])}):t._e(),t._v(" "),a("el-table-column",{attrs:{label:"操作",width:"100px",fixed:"right"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{type:"info",size:"mini"},on:{click:function(a){t.showLook(e.row,1)}}},[t._v("看课情况")])]}}])})],1)],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.lookDetail.show},on:{"update:visible":function(e){t.$set(t.lookDetail,"show",e)}}},[a("el-table",{directives:[{name:"loading",rawName:"v-loading",value:t.lookDetail.loading,expression:"lookDetail.loading"}],staticStyle:{width:"100%"},attrs:{data:t.lookDetail.list}},[a("el-table-column",{attrs:{prop:"start_at",label:"日期"}}),t._v(" "),a("el-table-column",{attrs:{label:"爸妈看一看"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 1===t.page_id})?a("span",[t._v("\n            "+t._s(e.row.watch_list.find(function(t){return 1===t.page_id}).stay_time)+"\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 1===t.page_id})?t._e():a("span",[t._v("\n            暂未上课\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"宝贝玩一玩"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 2===t.page_id})?a("span",[t._v("\n            "+t._s(e.row.watch_list.find(function(t){return 2===t.page_id}).stay_time)+"\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 2===t.page_id})?t._e():a("span",[t._v("\n            暂未上课\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"爸妈秀宝贝"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 3===t.page_id})?a("span",[a("div",{domProps:{innerHTML:t._s(e.row.watch_list.find(function(t){return 3===t.page_id}).learn_report)}})]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 3===t.page_id})?t._e():a("span",[t._v("\n            暂未秀宝贝\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"多元趣味课"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 5===t.page_id})?a("span",[t._v("\n            "+t._s(e.row.watch_list.find(function(t){return 5===t.page_id}).stay_time)+"\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 5===t.page_id})?t._e():a("span",[t._v("\n            暂未上课\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"分享"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 4===t.page_id})?a("span",[t._v("\n            已分享\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 4===t.page_id})?t._e():a("span",[t._v("\n            暂未分享\n          ")])]}}])})],1)],1)],1)},staticRenderFns:[]};var v=a("VU/8")(m,f,!1,function(t){a("YHy9")},"data-v-0720f3ea",null).exports,g=a("mWMt");var b={name:"customer",props:{customerObj:{type:Object,default:function(){return{}}}},components:{page:l.a,task1:d},data:function(){return{total:0,limit:10,pageIndex:1,chatrecord:[],infoData:{add_friend:"",chat_contact_count:"",chat_counts:"",phone_counts:"",phone_total_time:"",valid_chat_contact_count:"",wait_add_friend:"",wechat_friend_total:""},infoLoading:!0,infoLoadingDialog:!0,table:{th:[],td1:[],td2:[],td3:[]},phoneRecordList:{headerTh:[],pageData:[]},dialogTitle:"",dialogTableVisible:!1,dialogTable:!1,infoText:"",infoShow:"",realTime:""}},mounted:function(){this.getData()},methods:{strip:function(t){return+parseFloat(t.toPrecision(12))},getData:function(){var t=this;this.customerObj.alias&&(this.infoLoading=!0,Object(i._94)(this.customerObj.alias).then(function(e){t.infoData=e,t.infoLoading=!1}))},getSTime:function(t){g.a.isEmpty(t)&&(t=new Date),this.realTime=t.getFullYear()+"-"+(t.getMonth()+1)+"-"+t.getDate(),this.infoLoadingDialog=!0;var e={page:this.pageIndex,start_at:this.realTime,limit:this.limit};2===this.infoShow?this.infoPhonerecord(i._88,e,this.infoShow):1===this.infoShow?this.infoPhonerecord(i._132,e,this.infoShow):3===this.infoShow?(e=Object.assign({},e,{limit:10}),this.infoPhonerecord(i._64,e,this.infoShow)):4===this.infoShow&&this.infoPhonerecord(i._32,e,this.infoShow)},dialogTableClick:function(t){var e=this;Object(i._48)(t,{start_at:this.realTime}).then(function(t){t.length>0?(e.dialogTable=!0,t.map(function(t){g.a.isJSON(t.sentence)||"NULL"!==String(t.image_type).toUpperCase()||(t.image_type=1e3)}),e.chatrecord=t):e.$message.error("没有聊天记录")})},audioClick:function(t){for(var e=document.querySelectorAll(".le-content-audio"),a=0;a<e.length;a++){e[a].getAttribute("data-id")===t?e[a].play():e[a].pause()}},videoClick:function(t){for(var e=document.querySelectorAll(".my-video"),a=0;a<e.length;a++){e[a].getAttribute("data-id")==t?e[a].play():e[a].pause()}},customerNum:function(t,e){var a=this;this.infoLoadingDialog=!0,this.infoText=t,this.infoShow=e;var s={page:1,start_at:this.realTime};2===e?this.infoPhonerecord(i._88,s,e):1===e?this.infoPhonerecord(i._132,s,e):3===e?(s=Object.assign({},s,{limit:10}),this.infoPhonerecord(i._64,s,e)):4===e?this.infoPhonerecord(i._32,s,e):Object(i._186)(this.customerObj.id).then(function(t){a.$refs.mychild.showTask1Detail(t[0])})},infoPhonerecord:function(t,e,a){var i=this;t(this.customerObj.alias,e).then(function(t){i.infoLoadingDialog=!1,i.dialogTableVisible=!0;var e=3===a?" 全部好友："+t.friend_total:"";if(i.dialogTitle="老师名："+i.customerObj.name+"　销售顾问："+i.customerObj.adviser+e,g.a.isEmpty(t)&&(i.dialogTableVisible=!1,i.$message.error("暂无数据")),2===a?(i.phoneRecordList.headerTh=["序号","老师","客户名称","电话号码","呼出时间","通话时长","最后一次备注","下次回访","操作"],i.phoneRecordList.pageData=t.phone_record_list.page_data,i.total=t.phone_record_list.total):1===a?(i.phoneRecordList.headerTh=["序号","老师","UID","客户微信昵称","聊天条数","备注信息","下次回访","操作"],i.phoneRecordList.pageData=t.chat_friend_list.page_data,i.total=t.chat_friend_list.total):3===a?(i.phoneRecordList.headerTh=["用户头像","用户昵称","UID","电话号码","添加时间","用户属性","意向度","最后沟通","下次回访"],i.phoneRecordList.pageData=t.friend_list,i.total=t.friend_total):4===a&&(i.phoneRecordList.headerTh=["老师","UID","客户微信昵称","电话号码","添加时间","添加间隔"],i.phoneRecordList.pageData=t.add_friend_list.page_data,i.total=t.add_friend_list.total),2===a||1===a){t.time.unshift(" "),t.time.push("合计"),i.table.th=t.time;var s=2===a?t.min_count:1===a?t.chat_count:"",n=2===a?t.min_count_total:"";s.unshift(i.customerObj.name+"(总)"),i.table.td1=s;var o=2===a?t.one_min:1===a?t.chat_count10:"",l=2===a?"1分钟+":1===a?"10条+":"",r=2===a?t.one_min_total:"";o.unshift(l),i.table.td2=o;var c=2===a?t.three_min:1===a?t.chat_count20:"";2===a&&t.three_min_total;c.unshift(2===a?"3分钟+":1===a?"20条+":""),i.table.td3=c,2===a&&(s.push(n),o.push(r),c.push(r))}else if(4===a){t.time.unshift(" "),t.time.push("合计"),i.table.th=t.time;var d=t.count;d.unshift(i.customerObj.name+"(总)"),d.push(t.count_total),i.table.td1=d}})},onPageChange:function(t){this.pageIndex=t;var e={page:t,limit:this.limit,start_at:this.realTime};this.infoLoadingDialog=!0,2===this.infoShow?this.infoPhonerecord(i._88,e,this.infoShow):1===this.infoShow?this.infoPhonerecord(i._132,e,this.infoShow):3===this.infoShow?(e=Object.assign({},e,{limit:10}),this.infoPhonerecord(i._64,e,this.infoShow)):4===this.infoShow&&this.infoPhonerecord(i._32,e,this.infoShow)},onSizeChange:function(t){this.limit=t,this.infoLoadingDialog=!0;var e={page:1,limit:t,start_at:this.realTime};2===this.infoShow?this.infoPhonerecord(i._88,e,this.infoShow):1===this.infoShow?this.infoPhonerecord(i._132,e,this.infoShow):3===this.infoShow?(e=Object.assign({},e,{limit:10}),this.infoPhonerecord(i._64,e,this.infoShow)):4===this.infoShow&&this.infoPhonerecord(i._32,e,this.infoShow)},chatRecord:function(){this.dialogTable=!0},sourceFileClick:function(t,e){for(var a=document.querySelectorAll(".sourceFile-audio"),i=0;i<a.length;i++)e===i?a[i].play():a[i].pause()},tableRowClassName:function(t){t.row;return 0===t.rowIndex?"warning-row":""}}},w={render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{staticClass:"customer"},[i("el-row",{attrs:{gutter:20}},[i("el-col",{attrs:{span:24}},[i("el-card",{directives:[{name:"loading",rawName:"v-loading",value:t.infoLoading,expression:"infoLoading"}]},[i("div",{staticClass:"clearfix",attrs:{slot:"header"},slot:"header"},[i("span",{staticStyle:{"font-size":"18px","font-weight":"bold","padding-right":"20px"}},[t._v("今日实时数据")]),t._v(" "),i("el-button",{attrs:{size:"mini",type:"primary"},on:{click:t.getData}},[t._v("刷新")])],1),t._v(" "),i("div",[i("el-breadcrumb",{staticStyle:{"padding-bottom":"30px"}},[i("el-breadcrumb-item",{staticClass:"hand",nativeOn:{click:function(e){t.customerNum("录音",2)}}},[t._v("\n              通次："),i("span",[t._v(t._s(t.infoData.phone_counts))])]),t._v(" "),i("el-breadcrumb-item",[t._v("通时："+t._s(t.infoData.phone_total_time)+"min")]),t._v(" "),i("el-breadcrumb-item",[t._v("聊天次数："+t._s(t.infoData.chat_counts))]),t._v(" "),i("el-breadcrumb-item",[t._v("沟通人数："+t._s(t.infoData.chat_contact_count))]),t._v(" "),i("el-breadcrumb-item",{staticClass:"hand",nativeOn:{click:function(e){t.customerNum("查看聊天记录",1)}}},[t._v("\n              有效沟通："),i("span",[t._v(t._s(t.infoData.valid_chat_contact_count))])])],1),t._v(" "),i("el-breadcrumb",[i("el-breadcrumb-item",{staticClass:"hand",nativeOn:{click:function(e){t.customerNum("全部好友",3)}}},[t._v("总好友："),i("span",[t._v(t._s(t.infoData.wechat_friend_total))])]),t._v(" "),i("el-breadcrumb-item",{staticClass:"hand",nativeOn:{click:function(e){t.customerNum("添加好友",4)}}},[t._v("添加好友："),i("span",[t._v(t._s(t.infoData.add_friend))])]),t._v(" "),i("el-breadcrumb-item",{staticClass:"hand",nativeOn:{click:function(e){t.customerNum("待添加",5)}}},[t._v("待添加好友："),i("span",[t._v(t._s(t.infoData.wait_add_friend))])]),t._v(" "),i("el-breadcrumb-item",[t._v("好友处理率："+t._s(t.infoData.wait_add_friend?parseInt(t.strip(100*t.infoData.add_friend/t.infoData.wait_add_friend))+"%":"-"))])],1)],1)])],1)],1),t._v(" "),i("el-dialog",{attrs:{"append-to-body":"",visible:t.dialogTableVisible,width:"90%",top:"5vh",title:t.dialogTitle},on:{"update:visible":function(e){t.dialogTableVisible=e}}},[i("div",{staticClass:"block"},[i("el-date-picker",{attrs:{type:"date",placeholder:"选择日期"},on:{change:t.getSTime},model:{value:t.realTime,callback:function(e){t.realTime=e},expression:"realTime"}})],1),t._v(" "),i("table",{directives:[{name:"show",rawName:"v-show",value:3!=t.infoShow,expression:"infoShow != 3"},{name:"loading",rawName:"v-loading",value:t.infoLoadingDialog,expression:"infoLoadingDialog"}],staticClass:"custom-table"},[i("thead",[i("tr",t._l(t.table.th,function(e){return i("th",[t._v(t._s(e))])}))]),t._v(" "),i("tbody",[t.table.td1.length?i("tr",t._l(t.table.td1,function(e){return i("td",[t._v(t._s(e))])})):t._e(),t._v(" "),t.table.td2.length?i("tr",t._l(t.table.td2,function(e){return i("td",[t._v(t._s(e))])})):t._e(),t._v(" "),t.table.td3.length?i("tr",t._l(t.table.td3,function(e){return i("td",[t._v(t._s(e))])})):t._e()])]),t._v(" "),i("table",{directives:[{name:"loading",rawName:"v-loading",value:t.infoLoadingDialog,expression:"infoLoadingDialog"},{name:"show",rawName:"v-show",value:0!=t.phoneRecordList.pageData.length,expression:"phoneRecordList.pageData.length != 0"}],staticClass:"custom-table",staticStyle:{"margin-top":"50px"}},[i("thead",[i("tr",t._l(t.phoneRecordList.headerTh,function(e){return i("th",{key:e.id},[t._v(t._s(e))])}))]),t._v(" "),i("tbody",t._l(t.phoneRecordList.pageData,function(e,a){return i("tr",{key:e.id,staticStyle:{"text-align":"center"}},[2==t.infoShow?[i("td",[t._v(t._s(a+1))]),t._v(" "),i("td",[t._v(t._s(t.customerObj.name))]),t._v(" "),i("td",[t._v(t._s(e.contact_name))]),t._v(" "),i("td",[t._v(t._s(e.contact_phone))]),t._v(" "),i("td",[t._v(t._s(e.start_time))]),t._v(" "),i("td",[t._v(t._s(e.duration))]),t._v(" "),i("td",[t._v(t._s(e.visit_desc))]),t._v(" "),i("td",[t._v(t._s(e.next_visit_at))]),t._v(" "),i("td",[i("audio",{staticClass:"sourceFile-audio",staticStyle:{display:"none"},attrs:{controls:"controls",id:"sourceFile"+e.id}},[i("source",{attrs:{src:e.source_file,type:"audio/mp3"}})]),t._v(" "),i("el-button",{attrs:{size:"mini",type:"primary",round:""},on:{click:function(i){t.sourceFileClick("sourceFile"+e.id,a)}}},[t._v(t._s(t.infoText))])],1)]:t._e(),t._v(" "),1==t.infoShow?[i("td",[t._v(t._s(a+1))]),t._v(" "),i("td",[t._v(t._s(t.customerObj.name))]),t._v(" "),i("td",[t._v(t._s(e.friend_uid))]),t._v(" "),i("td",[t._v(t._s(e.nick))]),t._v(" "),i("td",[t._v(t._s(e.chat_count))]),t._v(" "),i("td",[t._v(t._s(e.visit_desc))]),t._v(" "),i("td",[t._v(t._s(e.next_visit_at))]),t._v(" "),i("td",{on:{click:function(a){t.dialogTableClick(e.friend_id)}}},[i("el-button",{attrs:{size:"mini",type:"primary",round:""}},[t._v(t._s(t.infoText))])],1)]:t._e(),t._v(" "),3==t.infoShow?[i("td",[i("img",{staticStyle:{width:"40px",height:"40px"},attrs:{src:e.headimg,alt:""}})]),t._v(" "),i("td",[t._v(t._s(e.nick))]),t._v(" "),i("td",[t._v(t._s(e.friend_uid))]),t._v(" "),i("td",[t._v(t._s(e.mobile))]),t._v(" "),i("td",[t._v(t._s(e.create_time))]),t._v(" "),i("td",[t._v(t._s(e.wx_friend_type))]),t._v(" "),i("td",[t._v(t._s(1==e.visit_intention?"低意向":2==e.visit_intention?"中意向":3==e.visit_intention?"高意向":"不跟踪"))]),t._v(" "),i("td",[t._v(t._s(e.last_contact))]),t._v(" "),i("td",[t._v(t._s(e.next_visit_at))])]:t._e(),t._v(" "),4==t.infoShow?[i("td",[t._v(t._s(t.customerObj.name))]),t._v(" "),i("td",[t._v(t._s(e.friend_uid))]),t._v(" "),i("td",[t._v(t._s(e.friend_nickname))]),t._v(" "),i("td",[t._v(t._s(e.mobile))]),t._v(" "),i("td",[t._v(t._s(e.allow_time))]),t._v(" "),i("td",[t._v(t._s(e.add_time_long))])]:t._e()],2)}))]),t._v(" "),i("page",{directives:[{name:"show",rawName:"v-show",value:0!=t.phoneRecordList.pageData.length,expression:"phoneRecordList.pageData.length != 0"}],attrs:{total:t.total,limit:t.limit},on:{pageChange:t.onPageChange,sizeChange:t.onSizeChange}})],1),t._v(" "),i("el-dialog",{attrs:{"append-to-body":"",visible:t.dialogTable},on:{"update:visible":function(e){t.dialogTable=e}}},[i("div",{staticClass:"liaotian-content",staticStyle:{height:"500px",overflow:"auto"}},t._l(t.chatrecord,function(e){return i("div",{key:e.id,staticClass:"chat-record"},[i("div",{staticClass:"le"},["left"==e.author?i("div",{staticClass:"le-content"},[i("div",{staticClass:"le-content-image"},[i("img",{attrs:{src:e.headimg,alt:""}})]),t._v(" "),i("div",{staticClass:"le-content-box"},[i("div",{staticClass:"le-content-box-title"},[t._v(t._s(e.nick)+" "+t._s(e.gmt_create))]),t._v(" "),1e3==e.image_type?i("div",{staticClass:"chat-record-content",domProps:{innerHTML:t._s(e.sentence)}}):t._e(),t._v(" "),3==e.image_type?i("div",{staticClass:"chat-record-content-image"},[i("img",{attrs:{src:"https://hjapi.aihujing.com/ims/file/down?file_path="+e.image_osskey,alt:""}})]):t._e(),t._v(" "),34==e.image_type?i("div",{staticClass:"chat-record-content-audio"},[i("audio",{staticClass:"le-content-audio",attrs:{controls:"controls",width:"260px",height:"40px",id:"sourceFile"+e.id,"data-id":"sourceFile"+e.id},on:{play:function(a){t.audioClick("sourceFile"+e.id)}}},[i("source",{attrs:{src:"https://hjapi.aihujing.com/ims/file/down?file_path="+e.image_osskey,type:"audio/mp3"}})])]):t._e(),t._v(" "),42==e.image_type?i("div",{staticClass:"share-business-card"},[i("div",{staticClass:"share-business-card-image"},[i("div",{staticClass:"share-business-card-image-avtive"},[i("img",{attrs:{src:e.sentence.small_headimg,alt:""}})]),t._v(" "),i("div",{staticClass:"share-business-card-name"},[t._v(t._s(e.sentence.nickname))])]),t._v(" "),i("div",{staticClass:"card"},[t._v("\n                  个人名片\n                ")])]):t._e(),t._v(" "),42==e.image_type?i("div",{staticClass:"video-news",staticStyle:{width:"65%"}},[i("video",{staticClass:"my-video",staticStyle:{width:"100%",outline:"none"},attrs:{"data-id":"sourceFile"+e.id,src:e.sentence.video_url,poster:e.sentence.img_url,controls:"controls"},on:{play:function(a){t.videoClick("sourceFile"+e.id)}}})]):t._e(),t._v(" "),47==e.image_type?i("div",{staticClass:"chat-record-content",staticStyle:{width:"20%"}},[i("img",{attrs:{width:"100%",src:e.sentence,alt:""}})]):t._e(),t._v(" "),49===e.image_type?i("div",{staticClass:"share-kuang"},[i("div",{staticClass:"title"},[t._v("\n                  "+t._s(e.sentence.des)+"\n                ")]),t._v(" "),i("div",{staticClass:"share-kuang-content"},[i("div",{staticClass:"kuang-content"},[t._v("\n                    "+t._s(e.sentence.title)+"\n                  ")]),t._v(" "),i("div",{staticClass:"kuang-image"},[i("img",{attrs:{src:e.sentence.img_url,width:"100%",height:"100%",alt:""}})])])]):t._e(),t._v(" "),436207665==e.image_type||419430449==e.image_type?i("div",{staticClass:"red-envelopes"},[i("div",{staticClass:"red-envelopes-content"},[i("div",{staticClass:"red-envelopes-content-image"},[436207665==e.image_type?i("img",{attrs:{src:"https://wx.gtimg.com/hongbao/1800/hb.png",alt:""}}):t._e(),t._v(" "),419430449==e.image_type?i("img",{attrs:{src:a("1Bte"),alt:""}}):t._e()]),t._v(" "),i("div",{staticClass:"red-envelopes-content-gongxi"},[t._v("\n                    "+t._s(e.sentence.des)+"\n                  ")])]),t._v(" "),i("div",{staticClass:"title"},[t._v(t._s(e.sentence.title))])]):t._e()])]):t._e()]),t._v(" "),i("div",{directives:[{name:"show",rawName:"v-show",value:"right"==e.author,expression:"item.author == 'right'"}],staticClass:"ri"},[i("div",{staticClass:"ri-content"},[i("div",{staticClass:"le-content-image"},[i("img",{attrs:{src:e.headimg,alt:""}})]),t._v(" "),i("div",{staticClass:"le-content-box"},[i("div",{staticClass:"le-content-box-title"},[t._v(t._s(e.gmt_create)+" "+t._s(e.nick))]),t._v(" "),1e3==e.image_type||47==e.image_type?i("div",{staticClass:"chat-record-content"},[t._v(t._s(e.sentence))]):t._e(),t._v(" "),3==e.image_type?i("div",{staticClass:"chat-record-content-image"},[i("img",{attrs:{src:"https://hjapi.aihujing.com/ims/file/down?file_path="+e.image_osskey,alt:""}})]):t._e(),t._v(" "),34==e.image_type?i("div",{staticClass:"chat-record-content-audio"},[i("audio",{staticClass:"le-content-audio",attrs:{controls:"controls",width:"260px",height:"40px",id:"sourceFile"+e.id,"data-id":"sourceFile"+e.id},on:{play:function(a){t.audioClick("sourceFile"+e.id)}}},[i("source",{attrs:{src:"https://hjapi.aihujing.com/ims/file/down?file_path="+e.image_osskey,type:"audio/mp3"}})])]):t._e(),t._v(" "),42==e.image_type?i("div",{staticClass:"share-business-card"},[i("div",{staticClass:"share-business-card-image"},[i("div",{staticClass:"share-business-card-image-avtive"},[i("img",{attrs:{src:e.sentence.small_headimg,alt:""}})]),t._v(" "),i("div",{staticClass:"share-business-card-name"},[t._v(t._s(e.sentence.nickname))])]),t._v(" "),i("div",{staticClass:"card"},[t._v("\n                  个人名片\n                ")])]):t._e(),t._v(" "),43==e.image_type?i("div",{staticClass:"video-news",staticStyle:{width:"65%",float:"right"}},[i("video",{staticClass:"my-video",staticStyle:{width:"100%",outline:"none"},attrs:{"data-id":"sourceFile"+e.id,src:e.sentence.video_url,poster:e.sentence.img_url,controls:"controls"},on:{play:function(a){t.videoClick("sourceFile"+e.id)}}})]):t._e(),t._v(" "),47==e.image_type?i("div",{staticClass:"chat-record-content",staticStyle:{width:"20%"}},[i("img",{attrs:{width:"100%",src:e.sentence,alt:""}})]):t._e(),t._v(" "),49===e.image_type?i("div",{staticClass:"share-kuang"},[i("div",{staticClass:"title"},[t._v("\n                  "+t._s(e.sentence.des)+"\n                ")]),t._v(" "),i("div",{staticClass:"share-kuang-content"},[i("div",{staticClass:"kuang-content"},[t._v("\n                    "+t._s(e.sentence.title)+"\n                  ")]),t._v(" "),i("div",{staticClass:"kuang-image"},[i("img",{attrs:{src:e.sentence.img_url,width:"100%",height:"100%",alt:""}})])])]):t._e(),t._v(" "),436207665==e.image_type||419430449==e.image_type?i("div",{staticClass:"red-envelopes"},[i("div",{staticClass:"red-envelopes-content"},[i("div",{staticClass:"red-envelopes-content-image"},[436207665==e.image_type?i("img",{attrs:{src:"https://wx.gtimg.com/hongbao/1800/hb.png",alt:""}}):t._e(),t._v(" "),419430449==e.image_type?i("img",{attrs:{src:a("1Bte"),alt:""}}):t._e()]),t._v(" "),i("div",{staticClass:"red-envelopes-content-gongxi"},[t._v("\n                    "+t._s(e.sentence.des)+"\n                  ")])]),t._v(" "),i("div",{staticClass:"title"},[t._v(t._s(e.sentence.title))])]):t._e()])])])])}))]),t._v(" "),i("task1",{directives:[{name:"show",rawName:"v-show",value:5==t.infoShow,expression:"infoShow == 5"}],ref:"mychild",attrs:{teacherId:t.customerObj.id,teacherShow:5}})],1)},staticRenderFns:[]};var k=a("VU/8")(b,w,!1,function(t){a("khlY")},null,null).exports,y={name:"",data:function(){return{dialogTitle:"",dialogTableVisible:!1,dialogFormVisible:!1,infoData:[],infoDataChild:[],infoLoading:!0,infoLoadingDialog:!0,realTime:"",fromTimer:"",formLabelWidth:"120px",remarks:"",handleSelectionValue:[]}},props:{customerObj:{type:Object,default:function(){return{}}}},mounted:function(){this.getData()},methods:{getData:function(){var t=this;this.infoLoading=!0,Object(i._134)(this.customerObj.id).then(function(e){t.infoLoading=!1;var a=[];Object.keys(e.weekday).map(function(t,i){a.push({day:t,time:Object.keys(e.visit_count)[i],num:Object.values(e.visit_count)[i],weekday:Object.values(e.weekday)[i]})}),t.infoData=a})},listContentClick:function(t){var e=this;this.infoLoadingDialog=!0,this.fromTimer=t,Object(i._135)(this.customerObj.id,{date_time:t}).then(function(t){e.dialogTableVisible=!0,e.infoLoadingDialog=!1,e.dialogTitle="老师名："+e.customerObj.name+"　销售顾问："+e.customerObj.adviser,e.infoDataChild=t})},handleSelectionChange:function(t){this.handleSelectionValue=t},batchRemarks:function(){this.dialogFormVisible=!0},getSTime:function(t){g.a.isEmpty(t)&&(t=new Date),this.infoLoadingDialog=!0,this.realTime=t.getFullYear()+"-"+(t.getMonth()+1)+"-"+t.getDate(),this.listContentClick(this.realTime)},OK:function(){var t=this,e="";this.handleSelectionValue.map(function(t){e+=t.id+","});var a={id:e,remark:this.remarks};Object(i._150)(a).then(function(e){t.dialogFormVisible=!1,t.listContentClick(t.fromTimer)})}}},D={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("div",{attrs:{id:"replayed"}},[a("el-row",{attrs:{gutter:20}},[a("el-col",{attrs:{span:24}},[a("el-card",{directives:[{name:"loading",rawName:"v-loading",value:t.infoLoading,expression:"infoLoading"}]},[a("div",{staticClass:"clearfix",attrs:{slot:"header"},slot:"header"},[a("span",{staticStyle:{"font-size":"18px","font-weight":"bold","padding-right":"20px"}},[t._v("待回访日历")]),t._v(" "),a("el-button",{attrs:{size:"mini",type:"primary"},on:{click:t.getData}},[t._v("刷新")])],1),t._v(" "),a("div",{staticClass:"list-yi"},t._l(t.infoData,function(e){return a("div",{staticClass:"list-content",on:{click:function(a){t.listContentClick(e.time)}}},[a("div",[t._v(t._s(e.day))]),t._v(" "),a("div",[t._v(t._s(e.num))]),t._v(" "),a("div",{staticStyle:{color:"#409EFF","padding-bottom":"4px"}},[t._v(t._s(e.weekday))])])}))])],1)],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",width:"90%",visible:t.dialogTableVisible,top:"5vh",title:t.dialogTitle},on:{"update:visible":function(e){t.dialogTableVisible=e}}},[a("div",{staticClass:"block"},[a("el-date-picker",{attrs:{type:"date",placeholder:"选择日期"},on:{change:t.getSTime},model:{value:t.realTime,callback:function(e){t.realTime=e},expression:"realTime"}}),t._v(" "),a("el-button",{attrs:{size:"medium",type:"primary"},on:{click:t.batchRemarks}},[t._v("批量备注")])],1),t._v(" "),a("el-table",{directives:[{name:"loading",rawName:"v-loading",value:t.infoLoadingDialog,expression:"infoLoadingDialog"}],ref:"multipleTable",staticStyle:{width:"100%"},attrs:{data:t.infoDataChild,"tooltip-effect":"dark"},on:{"selection-change":t.handleSelectionChange}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{prop:"user_id",label:"UID",width:"120"}}),t._v(" "),a("el-table-column",{attrs:{prop:"nickname",label:"客户微信昵称",width:"120"}}),t._v(" "),a("el-table-column",{attrs:{prop:"mobile",label:"电话号码","show-overflow-tooltip":""}}),t._v(" "),a("el-table-column",{attrs:{label:"意向度","show-overflow-tooltip":""},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v(t._s(1===e.row.intention?"低意向":2===e.row.intention?"中意向":3===e.row.intention?"高意向":"不跟踪"))]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"next_visit_at",label:"最近关注时间","show-overflow-tooltip":""}}),t._v(" "),a("el-table-column",{attrs:{prop:"created_at",label:"回访时间","show-overflow-tooltip":""}}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"操作","show-overflow-tooltip":""}})],1)],1),t._v(" "),a("el-dialog",{staticStyle:{"z-index":"7000"},attrs:{title:"批量备注","append-to-body":"",visible:t.dialogFormVisible},on:{"update:visible":function(e){t.dialogFormVisible=e}}},[a("el-input",{attrs:{placeholder:"请输入内容"},model:{value:t.remarks,callback:function(e){t.remarks=e},expression:"remarks"}}),t._v(" "),a("div",{staticClass:"dialog-footer",attrs:{slot:"footer"},slot:"footer"},[a("el-button",{on:{click:function(e){t.dialogFormVisible=!1}}},[t._v("取 消")]),t._v(" "),a("el-button",{attrs:{type:"primary"},on:{click:t.OK}},[t._v("确 定")])],1)],1)],1)},staticRenderFns:[]};var S=a("VU/8")(y,D,!1,function(t){a("8cIS")},null,null).exports,x={name:"task",components:{teacherDesc:n.a,task1:d,task2:p,task3:v,userWeight:o.a,sourceByDateDialog:u.a,customerDetail:k,replayedDetail:S},props:["parentDetail"],data:function(){var t=this;return{watchRecordShow:!1,sourceByDateDialogJson:{},id:this.parentDetail?this.parentDetail.id:this.$route.params.id,task3List:[],task2Detail:{show:!1,list:[],type:1,weight:""},lookDetail:{show:!1,loading:!1,list:[],nowPage:1,data:null,limit:500,total:0},task1Detail:{show:!1,list:[],title:"",cur_date:""},task5Detail:{show:!1,list:[],total:0,total_over_num:0,over_rate:0,total_over_reply_num:0,total_over_intention_num:0,over_intention_rate:0,over_reply_rate:0},recallDetail:{show:!1,list:[],weight:""},overWorkDetail:{show:!1,list:[],weight:""},descDialog:{show:!1,id:"",descList:[],user_info:null,type:null},selectedTask2:[],selectedTask3:[],selectedTask5:[],task3Detail:{show:!1,list:[],is_true:"",is_watch:"",loading:!1,periods_id:"",cur_date:"",title:"",type:0},dialogType:0,today:{text:"今天",onClick:function(e){e.$emit("pick",[t.formatTime(new Date),t.formatTime(new Date)])}},yesterday:{text:"昨天",onClick:function(e){var a=t.formatTime(new Date((new Date).getTime()-864e5));e.$emit("pick",[a,a])}},last7Day:{text:"过去7天",onClick:function(e){var a=t.formatTime(new Date((new Date).getTime()-6048e5));e.$emit("pick",[a,t.formatTime(new Date)])}},last30Day:{text:"过去30天",onClick:function(e){var a=t.formatTime(new Date((new Date).getTime()-2592e6));e.$emit("pick",[a,t.formatTime(new Date)])}},searchWatch:{dateValue:[],periods_id:0},prePeriods:[],watchRecordList:[]}},methods:{periodName:function(t){var e="";return t.title?(t.goods_id&&(e+="【"+t.goods_id+"】"),t.title&&(e+=t.title+"<br>"),t.watch_num&&(e+=t.watch_num+"课时"),t.start_at&&(e+="（"+t.start_at.slice(5).replace("-","")+"）"),(t.has_watch_num||0==t.has_watch_num)&&(e+="-d"+t.has_watch_num)):e="-",e},formatTime:function(t){var e=t.getFullYear(),a=t.getMonth()+1;a<10&&(a="0"+a);var i=t.getDate();return i<10&&(i="0"+i),e+"-"+a+"-"+i},defaultTime:function(){var t=new Date,e=t.getFullYear(),a=t.getMonth()+1;a<10&&(a="0"+a);var i=t.getDate();i<10&&(i="0"+i);var s=e+"-"+a+"-01",n=e+"-"+a+"-"+i;this.searchWatch.dateValue=[s,n]},watchListFn:function(){this.watchRecordShow=!0,this.searchPage()},searchPage:function(){var t=this,e={teacher_id:this.id};this.searchWatch.dateValue&&(e.start_at=this.searchWatch.dateValue[0],e.end_at=this.searchWatch.dateValue[1]),0!=this.searchWatch.periods_id&&(e.periods_id=this.searchWatch.periods_id),Object(i._137)(e).then(function(e){t.watchRecordList=e.list,0==t.searchWatch.periods_id&&e.periods_result&&e.periods_result.length&&(t.prePeriods=e.periods_result)})},showSourceByDate:function(t){t.periods_id?this.sourceByDateDialogJson={periods_id:t.periods_id,user_id:t.user_id,json:{limit:10,page:0}}:this.sourceByDateDialogJson={periods_id:this.task2Detail.periods_id,user_id:t.user_id,json:{limit:10,page:0}},this.$refs.sourceByDateDialogDom.dialogShow=!0},allDesc2:function(){var t=this;this.selectedTask2.length<1?this.$message({type:"error",message:"请先选择用户"}):this.$prompt("请输入沟通内容","备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea"}).then(function(e){var a=e.value,s=[];t.selectedTask2.forEach(function(t){s.push(t.id)});var n={ids:s.join(),desc:a,type:1};Object(i.w)(n).then(function(e){t.$message({type:"success",message:"批量添加备注成功"}),t.refDesc2()})})},allDesc3:function(){var t=this;this.selectedTask3.length<1?this.$message({type:"error",message:"请先选择用户"}):this.$prompt("请输入沟通内容","备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea"}).then(function(e){var a=e.value,s=[];t.selectedTask3.forEach(function(t){s.push(t.id)});var n={ids:s.join(),desc:a,type:1};Object(i.w)(n).then(function(e){t.$message({type:"success",message:"批量添加备注成功"}),t.refDesc3()})})},allDesc5:function(){var t=this;this.selectedTask5.length<1?this.$message({type:"error",message:"请先选择用户"}):this.$prompt("请输入沟通内容","备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea"}).then(function(e){var a=e.value,s=[];t.selectedTask5.forEach(function(t){s.push(t.id)});var n={ids:s.join(),desc:a,type:1};Object(i.w)(n).then(function(e){t.$message({type:"success",message:"批量添加备注成功"}),t.getTask5()})})},handleSelectionChange122:function(t){this.selectedTask2=t},handleSelectionChange123:function(t){this.selectedTask3=t},handleSelectionChange125:function(t){this.selectedTask5=t},showLook:function(t){var e=this;t&&(this.lookDetail.data=t),this.lookDetail.show=!0,this.lookDetail.loading=!0;var a={limit:this.lookDetail.limit,page:this.lookDetail.nowPage};Object(i._211)(this.lookDetail.data.periods_id,this.lookDetail.data.user_id,a).then(function(t){e.lookDetail.list=t.list,e.lookDetail.loading=!1,e.lookDetail.total=t.total})},onLookDetailPageChange:function(t){this.lookDetail.nowPage=t,this.showLook()},onLookDetailSizeChange:function(t){this.lookDetail.limit=t,this.lookDetail.nowPage=1,this.showLook()},showTask3Detail:function(t,e,a,s){var n=this,o={is_true:e,is_watch:a,cur_date:s};this.task3Detail.show=!0,this.task3Detail.loading=!0,this.task3Detail.is_true=e,this.task3Detail.periods_id=t.periods_id,this.task3Detail.is_watch=a,this.task3Detail.cur_date=s,this.task3Detail.type=1,this.dialogType=3,this.task3Detail.title="【"+t.periods_id+"】"+t.title+" "+(1===e?"已":"未")+(1===a?"看课":"打卡")+"学员",Object(i._138)(t.periods_id,this.id,o).then(function(t){n.task3Detail.loading=!1,n.task3Detail.list=t})},showOverWorkDetail:function(t){var e=this;this.task2Detail.show=!0,this.task2Detail.loading=!0,this.task2Detail.periods_id=t.periods_id,this.task2Detail.type=2,this.task2Detail.title=t.title+" 截止今日全勤学员",this.dialogType=2,Object(i._81)(t.periods_id,this.id,{}).then(function(t){e.task2Detail.loading=!1,e.task2Detail.list=t})},showRecallDetail:function(t){var e=this;this.task3Detail.show=!0,this.task3Detail.loading=!0,this.task3Detail.periods_id=t.periods_id,this.task3Detail.type=3,this.task3Detail.title=t.title+" 今日需要招回学员",this.dialogType=3,Object(i._95)(t.periods_id,this.id,{}).then(function(t){e.task3Detail.loading=!1,e.task3Detail.list=t})},editComment:function(t,e){var a=this;this.$prompt("","添加沟通话术",{confirmButtonText:"确定",cancelButtonText:"取消",inputValue:""}).then(function(e){var s=e.value;Object(i.m)(t,{desc:s}).then(function(t){switch(a.$message({type:"success",message:"添加沟通话术成功"}),a.dialogType){case 2:a.refDesc2();break;case 3:a.refDesc3();break;case 4:a.getTask5()}})})},refDesc3:function(){var t=this;if(console.log(this.task3Detail),1===this.task3Detail.type){var e={is_true:this.task3Detail.is_true,is_watch:this.task3Detail.is_watch,cur_date:this.task3Detail.cur_date};this.task3Detail.loading=!0,Object(i._138)(this.task3Detail.periods_id,this.id,e).then(function(e){t.task3Detail.loading=!1,t.task3Detail.show=!0,t.task3Detail.list=e})}else 2===this.task3Detail.type?Object(i._81)(this.task3Detail.periods_id,this.id,{}).then(function(e){t.task3Detail.loading=!1,t.task3Detail.show=!0,t.task3Detail.list=e}):3===this.task3Detail.type&&Object(i._95)(this.task3Detail.periods_id,this.id,{}).then(function(e){t.task3Detail.loading=!1,t.task3Detail.show=!0,t.task3Detail.list=e});Object(i._188)(this.id).then(function(e){t.task3List=e})},showTask5Detail:function(){this.task5Detail.show=!0,this.dialogType=4},refDesc2:function(){var t=this;1===this.task2Detail.type?task2Api(this.id).then(function(e){t.task2List=e,e.forEach(function(e){e.weight===t.task2Detail.weight&&(t.task2Detail.list=e.detail)})}):2===this.task2Detail.type&&(Object(i._81)(this.task2Detail.periods_id,this.id,{}).then(function(e){t.task2Detail.loading=!1,t.task2Detail.list=e}),Object(i._188)(this.id).then(function(e){t.task3List=e}))},changeAddTeacher:function(t){var e=this;Object(i.z)(t.id,t.is_add_teacher).then(function(){e.$message({type:"success",message:"数据更改成功"}),e.refDesc2()})},changeAddTeacher3:function(t){var e=this;Object(i.z)(t.id,t.is_add_teacher).then(function(){e.$message({type:"success",message:"数据更改成功"}),e.refDesc3()})},changeWeight3:function(t){var e=this;Object(i._26)(t.id,t.weight).then(function(){e.$message({type:"success",message:"数据更改成功"}),e.refDesc3()})},changeWeight:function(t,e){5===e?this.getTask5():this.refDesc2()},changeView:function(t){var e=this;Object(i._25)(t.id,t.is_view_course).then(function(){e.$message({type:"success",message:"数据更改成功"}),e.refDesc2()})},editDesc3:function(t){var e=this;this.$prompt("","请输入沟通情况",{confirmButtonText:"确定",cancelButtonText:"取消"}).then(function(a){var s=a.value;Object(i.m)(t.id,{desc:s}).then(function(t){e.$message({type:"success",message:"更新成功"}),e.refDesc3()})}).catch(function(){})},editDesc:function(t,e){this.descDialog.show=!0,this.descDialog.id=t.id,this.descDialog.type=e||null,this.descDialog.user_info={avatar:t.avatar,nickname:t.nickname,user_id:t.user_id},this.getUserDescList()},getUserDescList:function(){var t=this;Object(i._127)(this.descDialog.id,{limit:1e3}).then(function(e){t.descDialog.descList=e.list})},getTask5:function(){var t=this;Object(i._190)(this.id).then(function(e){t.task5Detail.list=e.list,t.task5Detail.total=e.total,t.task5Detail.over_rate=e.over_rate,t.task5Detail.total_over_num=e.total_over_num,t.task5Detail.over_reply_rate=e.over_reply_rate,t.task5Detail.total_over_reply_num=e.total_over_reply_num,t.task5Detail.total_over_intention_num=e.total_over_intention_num,t.task5Detail.over_intention_rate=e.over_intention_rate})},initPage:function(){var t=this;Object(i._188)(this.id).then(function(e){t.task3List=e}),this.getTask5()}},filters:{ADDTEACHER:function(t){var e="";return 0===t?e="暂未处理":1===t?e="老师主动添加用户":2===t?e="用户主动添加老师":3===t?e="待通过":4===t?e="手机号不是微信号":5===t&&(e="用户已拒绝"),e}},mounted:function(){this.initPage()}},C={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("div",{staticStyle:{"font-size":"14px"}},[a("el-row",{attrs:{gutter:20}},[a("el-col",{attrs:{span:13}},[a("customerDetail",{staticStyle:{"padding-bottom":"20px"},attrs:{customerObj:t.parentDetail}})],1),t._v(" "),a("el-col",{attrs:{span:11}},[a("replayedDetail",{staticStyle:{"padding-bottom":"20px"},attrs:{customerObj:t.parentDetail}})],1)],1),t._v(" "),a("el-row",{attrs:{gutter:20}},[a("el-col",{attrs:{span:24}},[a("task1",{attrs:{teacherId:t.id}})],1)],1),t._v(" "),a("el-row",{staticStyle:{"margin-top":"20px"},attrs:{gutter:20}},[a("el-col",{attrs:{span:24}},[a("task3",{attrs:{task3List:t.task3List,teacherId:t.id},on:{refDesc3:t.refDesc3}})],1)],1),t._v(" "),a("el-row",{staticStyle:{"margin-top":"20px"},attrs:{gutter:20}},[a("el-col",{attrs:{span:24}},[a("el-card",[a("div",{staticClass:"clearfix",attrs:{slot:"header"},slot:"header"},[a("span",{staticStyle:{"font-size":"18px","font-weight":"bold"}},[t._v("任务3：意向用户标记")])]),t._v(" "),a("div",[t._v("本期意向用户：")]),t._v(" "),!t.task3List||t.task3List.length<1?a("div",{staticStyle:{color:"#DDDDDD","text-align":"center"}},[t._v("\n          ——暂无数据——\n        ")]):t._e(),t._v(" "),t._l(t.task3List,function(e){return a("div",{staticClass:"task3-table",staticStyle:{width:"47%"}},[a("div",{staticClass:"table"},[a("div",{staticClass:"title",staticStyle:{width:"8%"}},[a("div",{staticClass:"header bg-h"},[t._v("期数名称")]),t._v(" "),a("div",[a("div",{domProps:{innerHTML:t._s(t.periodName(e))}})])]),t._v(" "),a("div",{staticClass:"over_work",staticStyle:{"background-color":"#fffbe4"}},[a("div",{staticClass:"header bg-h"},[t._v("今日需沟通用户")]),t._v(" "),a("el-button",{staticStyle:{"font-size":"30px","text-decoration":"underline"},attrs:{size:"mini",type:"text"},on:{click:function(a){t.showOverWorkDetail(e)}}},[t._v(t._s(e.total_watch_user_num))])],1),t._v(" "),a("div",{staticClass:"recall_process",staticStyle:{"line-height":"30px"}},[a("div",{staticClass:"header bg-h"},[t._v("完成情况")]),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px"}},[t._v("用户已标记："+t._s(e.total_over_intention_num)+"人")]),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px"}},[t._v("老师已沟通："+t._s(e.total_over_num)+"人")]),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px"}},[t._v("用户标记率：\n                "),a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:"#67C23A",percentage:Number(e.over_intention_rate)}})],1),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px"}},[t._v("任务处理率：\n                "),a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:100===Number(e.over_rate)?"#67C23A":"#f00",percentage:Number(e.over_rate)}})],1)])])])}),t._v(" "),a("br"),t._v(" "),a("div",{staticClass:"task3-table",staticStyle:{width:"47%"}},[a("div",[t._v("往期意向用户：")]),t._v(" "),a("div",{staticClass:"table"},[a("div",{staticClass:"title",staticStyle:{width:"8%"}},[a("div",{staticClass:"header bg-h"},[t._v("期数名称")]),t._v(" "),a("div",[t._v("\n                  往期活跃用户数（近三天）\n              ")])]),t._v(" "),a("div",{staticClass:"over_work",staticStyle:{"background-color":"#fffbe4"}},[a("div",{staticClass:"header bg-h"},[t._v("今日需沟通用户")]),t._v(" "),a("el-button",{staticStyle:{"font-size":"30px","text-decoration":"underline"},attrs:{size:"mini",type:"text"},on:{click:function(e){t.showTask5Detail()}}},[t._v(t._s(t.task5Detail.total))])],1),t._v(" "),a("div",{staticClass:"recall_process"},[a("div",{staticClass:"header bg-h"},[t._v("完成情况")]),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px","line-height":"30px"}},[t._v("用户已标记："+t._s(t.task5Detail.total_over_intention_num)+"人")]),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px","line-height":"30px"}},[t._v("老师已沟通："+t._s(t.task5Detail.total_over_num)+"人")]),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px","line-height":"30px"}},[t._v("用户标记率：\n                "),a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:"#67C23A",percentage:Number(t.task5Detail.over_intention_rate)}})],1),t._v(" "),a("div",{staticStyle:{"text-align":"left","margin-left":"20px","line-height":"30px"}},[t._v("任务处理率：\n                "),a("el-progress",{staticStyle:{display:"inline-block",width:"120px"},attrs:{"text-inside":!0,"stroke-width":18,color:100===Number(t.task5Detail.over_rate)?"#67C23A":"#f00",percentage:Number(t.task5Detail.over_rate)}})],1)])])]),t._v(" "),a("div",{staticClass:"task3-table",staticStyle:{width:"47%","text-align":"center"}},[a("el-button",{attrs:{type:"success"},on:{click:function(e){t.watchListFn()}}},[t._v("云集期数看课记录")]),t._v(" "),a("div",{staticStyle:{height:"130px"}})],1)],2)],1)],1),t._v(" "),a("el-row",{staticStyle:{"margin-top":"20px"},attrs:{gutter:20}},[a("el-col",{attrs:{span:12}},[a("task2",{attrs:{teacherId:t.id}})],1)],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.task3Detail.show,width:"80%",title:t.task3Detail.title},on:{"update:visible":function(e){t.$set(t.task3Detail,"show",e)}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc3()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{directives:[{name:"loading",rawName:"v-loading",value:t.task3Detail.loading,expression:"task3Detail.loading"}],staticStyle:{width:"100%"},attrs:{data:t.task3Detail.list,size:"mini",fixed:""},on:{"selection-change":t.handleSelectionChange123}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户",className:"f-c","min-width":"180",prop:"user_id"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticStyle:{width:"40px","min-width":"40px",height:"40px","border-radius":"50px"},attrs:{src:e.row.avatar}}),t._v(" "+t._s(e.row.nickname)+"(ID:"+t._s(e.row.user_id)+")\n          "),a("br"),t._v(" Tel:"+t._s(e.row.mobile)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{"min-width":"260",label:"沟通情况"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("teacher-desc",{attrs:{teacherId:t.id,row:e.row,descType:2},on:{onSuccess:t.refDesc3}})]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"用户反馈"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.is_reply?a("span",[e.row.reply_content?a("span",[t._v(t._s(e.row.reply_content))]):t._e(),t._v(" "),e.row.reply_content&&""!==e.row.reply_content?t._e():a("span",[t._v("无内容")])]):t._e(),t._v(" "),e.row.is_reply?t._e():a("span",{staticStyle:{color:"red"}},[t._v("尚未回复")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"进班时间","min-width":"200",sortable:"",prop:"created_at"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户属性","min-width":"400",sortable:"",prop:"last_login_at"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          最后登录时间："+t._s(e.row.last_login_at)+"\n          "),a("br"),t._v("\n          是否添加老师："+t._s(t._f("ADDTEACHER")(e.row.is_add_teacher))+"\n          "),a("br"),t._v("\n          用户意向等级："+t._s(e.row.weight)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"操作",width:"100px",fixed:"right"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{type:"info",size:"mini"},on:{click:function(a){t.showSourceByDate(e.row)}}},[t._v("看课情况")])]}}])})],1)],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.lookDetail.show},on:{"update:visible":function(e){t.$set(t.lookDetail,"show",e)}}},[a("el-table",{directives:[{name:"loading",rawName:"v-loading",value:t.lookDetail.loading,expression:"lookDetail.loading"}],staticStyle:{width:"100%"},attrs:{data:t.lookDetail.list}},[a("el-table-column",{attrs:{prop:"start_at",label:"日期"}}),t._v(" "),a("el-table-column",{attrs:{label:"爸妈看一看"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 1===t.page_id})?a("span",[t._v("\n            "+t._s(e.row.watch_list.find(function(t){return 1===t.page_id}).stay_time)+"\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 1===t.page_id})?t._e():a("span",[t._v("\n            暂未上课\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"宝贝玩一玩"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 2===t.page_id})?a("span",[t._v("\n            "+t._s(e.row.watch_list.find(function(t){return 2===t.page_id}).stay_time)+"\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 2===t.page_id})?t._e():a("span",[t._v("\n            暂未上课\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"爸妈秀宝贝"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 3===t.page_id})?a("span",[a("div",{domProps:{innerHTML:t._s(e.row.watch_list.find(function(t){return 3===t.page_id}).learn_report)}})]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 3===t.page_id})?t._e():a("span",[t._v("\n            暂未秀宝贝\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"多元趣味课"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 5===t.page_id})?a("span",[t._v("\n            "+t._s(e.row.watch_list.find(function(t){return 5===t.page_id}).stay_time)+"\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 5===t.page_id})?t._e():a("span",[t._v("\n            暂未上课\n          ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"分享"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.watch_list&&e.row.watch_list.length>0&&e.row.watch_list.find(function(t){return 4===t.page_id})?a("span",[t._v("\n            已分享\n          ")]):t._e(),t._v(" "),e.row.watch_list.find(function(t){return 4===t.page_id})?t._e():a("span",[t._v("\n            暂未分享\n          ")])]}}])})],1)],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.task2Detail.show,title:t.task2Detail.title,width:"80%"},on:{"update:visible":function(e){t.$set(t.task2Detail,"show",e)}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc2()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{staticStyle:{width:"100%"},attrs:{data:t.task2Detail.list,size:"mini",fixed:""},on:{"selection-change":t.handleSelectionChange122}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户",className:"f-c","min-width":"180",prop:"user_id"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticStyle:{width:"40px","min-width":"40px",height:"40px","border-radius":"50px"},attrs:{src:e.row.avatar}}),t._v(" "+t._s(e.row.nickname)+"(ID:"+t._s(e.row.user_id)+")\n          "),a("br"),t._v(" Tel:"+t._s(e.row.mobile)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{"min-width":"160",label:"沟通情况"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("teacher-desc",{attrs:{teacherId:t.id,row:e.row,descType:1},on:{onSuccess:t.refDesc2}})]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"用户反馈"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.is_reply?a("span",[e.row.reply_content?a("span",[t._v(t._s(e.row.reply_content))]):t._e(),t._v(" "),e.row.reply_content&&""!==e.row.reply_content?t._e():a("span",[t._v("无内容")])]):t._e(),t._v(" "),e.row.is_reply?t._e():a("span",{staticStyle:{color:"red"}},[t._v("尚未回复")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"学习情况","min-width":"180",prop:"weight"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          学习总时长："+t._s(e.row.total_stay_time)+"秒\n          "),a("br"),t._v("\n          学习课包模块数："+t._s(e.row.total_times)+"次\n          "),a("br"),t._v("\n          最后看课时间："+t._s(e.row.last_watch_at)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"意向等级","min-width":"95",prop:"weight"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("user-weight",{attrs:{row:e.row},on:{onSuccess:t.changeWeight}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"last_watch_at",label:"最后标注时间"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          "+t._s(e.row.last_weight_at?e.row.last_weight_at:"-")+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"last_weight_desc",label:"标注意向原因"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          "+t._s(e.row.last_weight_desc?e.row.last_weight_desc:"-")+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"操作"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{type:"primary ",size:"small"},on:{click:function(a){t.showSourceByDate(e.row)}}},[t._v("看课情况")])]}}])})],1)],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.watchRecordShow,width:"80%",title:"用户看课记录"},on:{"update:visible":function(e){t.watchRecordShow=e}}},[a("el-form",{attrs:{inline:"",model:t.searchWatch,"label-width":"100px"}},[a("el-form-item",{attrs:{label:"起止日期"}},[a("el-date-picker",{attrs:{"unlink-panels":"",type:"daterange","picker-options":{shortcuts:[t.today,t.yesterday,t.last7Day,t.last30Day]},"value-format":"yyyy-MM-dd","range-separator":"至","start-placeholder":"开始日期","end-placeholder":"结束日期"},on:{change:t.searchPage},model:{value:t.searchWatch.dateValue,callback:function(e){t.$set(t.searchWatch,"dateValue",e)},expression:"searchWatch.dateValue"}})],1),t._v(" "),a("el-form-item",{attrs:{label:""}},[a("el-button",{attrs:{type:"primary"},on:{click:function(e){t.searchPage()}}},[t._v("\n          搜索\n        ")])],1)],1),t._v(" "),a("el-tabs",{staticStyle:{background:"white","padding-top":"10px"},attrs:{type:"card"},on:{"tab-click":t.searchPage},model:{value:t.searchWatch.periods_id,callback:function(e){t.$set(t.searchWatch,"periods_id",e)},expression:"searchWatch.periods_id"}},[a("el-tab-pane",{key:"",attrs:{name:"0",label:"所有期数"}}),t._v(" "),t._l(t.prePeriods,function(t){return a("el-tab-pane",{key:t.id,attrs:{name:t.id,label:t.title}})})],2),t._v(" "),a("el-table",{staticStyle:{width:"100%"},attrs:{data:t.watchRecordList,size:"mini",fixed:""}},[a("el-table-column",{attrs:{prop:"title",label:"期数标题"}}),t._v(" "),a("el-table-column",{attrs:{prop:"user_id",label:"用户ID"}}),t._v(" "),a("el-table-column",{attrs:{prop:"nickname",label:"用户昵称"}}),t._v(" "),a("el-table-column",{attrs:{prop:"mobile",label:"用户手机号"}}),t._v(" "),a("el-table-column",{attrs:{prop:"updated_at",label:"上次看课时间"}}),t._v(" "),a("el-table-column",{attrs:{label:"沟通情况"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("teacher-desc",{attrs:{teacherId:t.id,row:e.row,descType:1},on:{onSuccess:t.searchPage}})]}}])})],1)],1),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.task5Detail.show,width:"80%",title:"往期活跃用户列表"},on:{"update:visible":function(e){t.$set(t.task5Detail,"show",e)}}},[a("el-button",{attrs:{size:"mini",type:"success"},on:{click:function(e){t.allDesc5()}}},[t._v("批量添加备注")]),t._v(" "),a("el-table",{staticStyle:{width:"100%"},attrs:{data:t.task5Detail.list,size:"mini",fixed:""},on:{"selection-change":t.handleSelectionChange125}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{label:"期数信息","min-width":"120",prop:"weight"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          "+t._s(e.row.title)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"用户",className:"f-c","min-width":"130",prop:"user_id"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticStyle:{width:"40px","min-width":"40px",height:"40px","border-radius":"50px"},attrs:{src:e.row.avatar}}),t._v(" "+t._s(e.row.nickname)+"(ID:"+t._s(e.row.user_id)+")\n          "),a("br"),t._v(" Tel:"+t._s(e.row.mobile)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"沟通情况"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("teacher-desc",{attrs:{teacherId:t.id,row:e.row,descType:1},on:{onSuccess:t.getTask5}})]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"用户反馈"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.is_reply?a("span",[e.row.reply_content?a("span",[t._v(t._s(e.row.reply_content))]):t._e(),t._v(" "),e.row.reply_content&&""!==e.row.reply_content?t._e():a("span",[t._v("无内容")])]):t._e(),t._v(" "),e.row.is_reply?t._e():a("span",{staticStyle:{color:"red"}},[t._v("尚未回复")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"学习情况","min-width":"180",prop:"weight"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          最后一天学习时长："+t._s(e.row.total_watch_time)+"秒\n          "),a("br"),t._v("\n          最后一天分享次数："+t._s(e.row.share_times)+"次\n          "),a("br"),t._v("\n          最后看课时间："+t._s(e.row.updated_at)+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"意向等级","min-width":"95",prop:"weight"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("user-weight",{attrs:{row:e.row},on:{onSuccess:t.getTask5}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"last_watch_at",label:"最后标注时间"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          "+t._s(e.row.last_weight_at?e.row.last_weight_at:"-")+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"last_weight_desc",label:"标注意向原因"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n          "+t._s(e.row.last_weight_desc?e.row.last_weight_desc:"-")+"\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"操作"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{type:"primary ",size:"small"},on:{click:function(a){t.showSourceByDate(e.row)}}},[t._v("看课情况")])]}}])})],1)],1),t._v(" "),a("sourceByDateDialog",{ref:"sourceByDateDialogDom",attrs:{dialogObj:t.sourceByDateDialogJson}})],1)},staticRenderFns:[]};var O=a("VU/8")(x,C,!1,function(t){a("3EQr")},"data-v-495e6746",null).exports,T={name:"sourceDialog",props:["dialogObj"],data:function(){return{detail:[]}},filters:{moneyYuan:function(t){return t?(t/100).toFixed(2)+"元":""},filterStatus:function(t){var e="";return 0===t?e="审核中":1===t?e="提现成功":2===t&&(e="提现失败"),e}},methods:{initPage:function(){var t=this,e={out_trade_no:this.dialogObj.out_trade_no,limit:200};Object(i._140)(e).then(function(e){t.detail=e.list})}},watch:{"dialogObj.show":function(t){!0===t&&this.initPage()}}},j={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("el-dialog",{attrs:{title:"提现详情",center:"","append-to-body":"",visible:t.dialogObj.show,width:"90%"},on:{"update:visible":function(e){t.$set(t.dialogObj,"show",e)}}},[a("el-table",{staticStyle:{width:"100%"},attrs:{data:t.detail}},[a("el-table-column",{attrs:{prop:"withdraw_no",label:"提现单号"}}),t._v(" "),a("el-table-column",{attrs:{prop:"out_trade_no",label:"订单号"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户",width:"200",className:"f-c"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticClass:"avatar",attrs:{src:e.row.user_avatar}}),t._v(" "+t._s(e.row.user_nickname)+"(ID:"+t._s(e.row.user_id)+")\n    ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"user_mobile",label:"手机号"}}),t._v(" "),a("el-table-column",{attrs:{label:"提现金额"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n      "+t._s(t._f("moneyYuan")(e.row.money))+"\n    ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"提现状态"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("span",{class:{status:!0,red:2===e.row.status,green:1===e.row.status}},[t._v("\n                  "+t._s(t._f("filterStatus")(e.row.status))+"\n                  ")])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"提现成功时间"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n      "+t._s(e.row.success_at)+"\n    ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"提现时间"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n      "+t._s(e.row.created_at)+"\n    ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"reason",label:"失败原因"}}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"备注"}})],1)],1)},staticRenderFns:[]};var L=a("VU/8")(T,j,!1,function(t){a("DWNj")},"data-v-592f7d91",null).exports,P={name:"sourceDialog",props:["dialogObj"],data:function(){return{detail:[]}},filters:{filterStatus:function(t){var e="";return 0===t?e="未使用":1===t?e="已使用":2===t&&(e="禁用"),e}},methods:{initPage:function(){var t=this,e={order_coupon_id:this.dialogObj.order_coupon_id,limit:200};Object(i._56)(e).then(function(e){t.detail=e.list})}},watch:{"dialogObj.show":function(t){!0===t&&this.initPage()}}},A={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("el-dialog",{attrs:{title:"优惠券详情",center:"","append-to-body":"",visible:t.dialogObj.show,width:"90%"},on:{"update:visible":function(e){t.$set(t.dialogObj,"show",e)}}},[a("el-table",{staticStyle:{width:"100%"},attrs:{data:t.detail}},[a("el-table-column",{attrs:{prop:"coupon_no",label:"优惠券码"}}),t._v(" "),a("el-table-column",{attrs:{prop:"out_trade_no",label:"订单号"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户信息","min-width":"140",className:"userInfo"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticClass:"avatar",attrs:{src:e.row.user_avatar}}),t._v("\n        "+t._s(e.row.user_nickname)+"(ID:"+t._s(e.row.user_id)+")\n      ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"优惠券金额"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n        "+t._s(parseFloat(e.row.money/100))+"元\n      ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"使用状态"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n        "+t._s(t._f("filterStatus")(e.row.status))+"\n      ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"use_at",label:"使用时间"}})],1)],1)},staticRenderFns:[]};var I=a("VU/8")(P,A,!1,function(t){a("mktT")},"data-v-9be36646",null).exports,N={name:"refundDetail",props:["dialogObj"],data:function(){return{detail:[]}},filters:{filterStatus:function(t){var e="";return 0===t?e="退款中":1===t?e="退款成功":2===t&&(e="退款失败"),e}},methods:{initPage:function(){var t=this,e={out_trade_no:this.dialogObj.out_trade_no,limit:200};Object(i._96)(e).then(function(e){t.detail=e.list})}},watch:{"dialogObj.show":function(t){!0===t&&this.initPage()}}},B={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("el-dialog",{attrs:{title:"退款详情",center:"","append-to-body":"",visible:t.dialogObj.show,width:"90%"},on:{"update:visible":function(e){t.$set(t.dialogObj,"show",e)}}},[a("el-table",{staticStyle:{width:"100%"},attrs:{data:t.detail}},[a("el-table-column",{attrs:{prop:"refund_no",label:"退款编号"}}),t._v(" "),a("el-table-column",{attrs:{prop:"out_trade_no",label:"订单号"}}),t._v(" "),a("el-table-column",{attrs:{label:"用户信息","min-width":"140",className:"userInfo"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticClass:"avatar",attrs:{src:e.row.user_avatar}}),t._v("\n        "+t._s(e.row.user_nickname)+"(ID:"+t._s(e.row.user_id)+")\n      ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"order_money",label:"订单金额"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n        "+t._s(parseFloat(e.row.order_money/100))+"元\n      ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"refund_money",label:"退款金额"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n        "+t._s(parseFloat(e.row.refund_money/100))+"元\n      ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"备注"}}),t._v(" "),a("el-table-column",{attrs:{label:"退款状态"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n        "+t._s(t._f("filterStatus")(e.row.status))+"\n      ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"success_at",label:"退款成功时间"}})],1)],1)},staticRenderFns:[]};var z=a("VU/8")(N,B,!1,function(t){a("T4rw")},"data-v-593bab5f",null).exports,F=a("0qGg"),J=a("CfzE"),E={},U={name:"index",props:["parentDetail"],components:{page:l.a,task:O,UserList:F.a,chooseGoodDialog:J.a,couponDialog:I,refundDetail:z,sourceDialog:L},data:function(){var t=new Date,e=t.getMonth()+1;return e<10&&(e="0"+e.toString()),{modularContentTitle:"",modularTotal:0,modularNowPage:1,modularLimit:10,contentTotal:0,contentNowPage:1,contentLimit:10,postModularContentDialog:!1,modularId:"",questionListParams:{type:"1",pid:"",keywords:""},postModularParams:{},modularList:[],modularContent:[],tabs:"task",nowDate:t=t.getFullYear()+"-"+e,yunjiList:[],searchFrom:{user_id:"",is_add_teacher:"",is_view_course:"",start_at:"",end_at:""},form:{nickname:"",user_id:"",status:[1,3,4,5],goods_id:"",out_trade_no:"",receive_mobile:"",mobile:""},task4Data:null,goodList:[],orderStatusOption:s.u,tableData:[],userList:[],list:[],id:"",isBindUser:!0,addShow:!1,detail:{},total:0,limit:10,nowPage:1,customerObj:{alias:"",name:"",adviser:""},userObj:{classId:"",title:"",show:!1,total:0,limit:10,nowPage:1},addId:"",multipleSelection:[],chooseGoodDialogObj:{show:!1,code:""},orderListObj:{total:0,limit:10,nowPage:1},yunjiListObj:{total:0,limit:10,nowPage:1},sourceDialog:{show:!1,out_trade_no:""},couponDetail:{show:!1,order_coupon_id:""},refundDetail:{show:!1,out_trade_no:""}}},methods:{periodName:function(t){var e="";return t.periods_title?(t.goods_id&&(e+="【"+t.goods_id+"】"),t.periods_title&&(e+=t.periods_title+"<br>"),t.watch_num&&(e+=t.watch_num+"课时"),t.start_at&&(e+="（"+t.start_at.slice(5).replace("-","")+"）"),(t.has_watch_num||0==t.has_watch_num)&&(e+="-d"+t.has_watch_num)):e="-",e},onPageChangeModular:function(t){this.modularNowPage=t,this.getList()},onSizeChangeModular:function(t){this.modularNowPage=1,this.modularLimit=t,this.getList()},onPageChangeC:function(t){this.contentNowPage=t,this.handleChange()},onSizeChangeC:function(t){this.contentNowPage=1,this.contentLimit=t,this.handleChange()},showContent:function(t){var e=this;this.modularContentTitle=t.title,Object(i._92)(t.id).then(function(t){e.postModularParams=Object.assign({},t),e.postModularContentDialog=!0})},handleChange:function(){var t=this;this.modularContent=[];var e={type:this.questionListParams.type,page:this.contentNowPage,limit:this.contentLimit};this.modularId&&(e.pid=this.modularId),this.questionListParams.keywords&&(e.keywords=this.questionListParams.keywords),Object(i._93)(e.type,e).then(function(e){t.modularContent=e.list,console.log(e),t.contentTotal=e.total})},handleClick:function(t){this.questionListParams.type=t.name,this.getList()},getList:function(){var t=this,e={type:this.questionListParams.type,modularPage:this.modularNowPage,modularLimit:this.modularLimit};this.questionListParams.pid&&(e.pid=this.questionListParams.pid),Object(i._93)(e.type,e).then(function(e){t.modularList=e.list,console.log(t.modularList),t.modularTotal=e.total})},userStatusFormatter:function(t){return s.B[t.user_status]},getTask4:function(){var t=this;Object(i._189)(this.id).then(function(e){t.task4Data=e})},handleSelectionChange:function(t){this.multipleSelection=t},onAdd:function(){var t=this;0!==this.multipleSelection.length?1===this.multipleSelection.length?(this.addId=this.multipleSelection[0].user_id,this.addId&&this.isBindUser&&Object(i._193)(this.id,{user_id:this.addId}).then(function(e){t.$message({type:"success",message:"绑定成功!"}),t.id=t.parentDetail?t.parentDetail.id:t.$route.params.id,t.getTeacherDetail(),t.getGoodsOption(),t.addShow=!1})):this.$message({type:"error",message:"只能选择一个用户!"}):this.$message({type:"error",message:"请选择用户!"})},onAddUser:function(t){this.isBindUser=t,this.addShow=!0,this.getUser()},getUser:function(){var t=this,e={page:this.userObj.nowPage,limit:this.userObj.limit};this.searchFrom.userId&&(e.user_id=this.searchFrom.userId),this.searchFrom.nickName&&(e.nickname=this.searchFrom.nickName),this.searchFrom.mobile&&(e.mobile=this.searchFrom.mobile),Object(i._129)(e).then(function(e){t.userList=e.list,t.userObj.total=e.total})},changeRow:function(t,e){e.indexOf(t)>-1&&Object(i._52)(t.periods_id,t.id).then(function(e){t.arrive_course_rate=e.arrive_course_rate,t.watch_course_rate=e.watch_course_rate,t.over_course_rate=e.over_course_rate,t.work_rate=e.work_rate,t.over_work_rate=e.over_work_rate,t.clock_rate=e.clock_rate,t.over_clock_rate=e.over_clock_rate,t.transform_rate=e.transform_rate})},showUser:function(t){console.log(t);var e=1==t.type?"(带班班级)":"(观摩班级)";this.userObj={classId:t.id,show:!0,title:this.detail.name+"班级用户列表"+e,teacherId:t.teacher_id,periods_id:t.periods_id,goods_id:t.goods_id,type:t.type}},onPageChange:function(t){this.nowPage=t,this.getTeacherDetail()},onSizeChange:function(t){this.limit=t,this.nowPage=1,this.getTeacherDetail()},onPageChange2:function(t){this.orderListObj.nowPage=t,this.getOrderList()},onSizeChange2:function(t){this.orderListObj.limit=t,this.orderListObj.nowPage=1,this.getOrderList()},onPageChange3:function(t){this.yunjiListObj.nowPage=t,this.getyunjiList()},onSizeChange3:function(t){this.yunjiListObj.limit=t,this.yunjiListObj.nowPage=1,this.getyunjiList()},getTeacherDetail:function(){var t=this;this.searchFrom={user_id:"",is_add_teacher:"",is_view_course:"",start_at:"",end_at:""};var e=this.id,a={limit:this.limit,page:this.nowPage};console.log(this.id),Object(i._119)(e,a).then(function(e){console.log(e),t.detail=e,t.detail.class_list&&(t.detail.class_list.list.forEach(function(t){t.arrive_course_rate=0,t.watch_course_rate=0,t.over_course_rate=0,t.work_rate=0,t.over_work_rate=0,t.clock_rate=0,t.over_clock_rate=0,t.transform_rate=0}),t.list=t.detail.class_list.list||[],t.total=t.detail.class_list.total)})},createInviteLink:function(t){this.chooseGoodDialogObj.show=!0,0==this.detail.type?this.chooseGoodDialogObj.code="CC-TEACHER-"+t.user_id:1==this.detail.type?this.chooseGoodDialogObj.code="CC-XXMM-"+t.user_id:this.chooseGoodDialogObj.code="CC-TEACHER-"+t.user_id},changeShow:function(){this.chooseGoodDialogObj.show=!1,this.chooseGoodDialogObj.code=""},getOrderList:function(){var t=this,e={limit:this.orderListObj.limit,page:this.orderListObj.nowPage};this.form.nickname&&(e.nickname=this.form.nickname),this.form.user_id&&(e.user_id=this.form.user_id),this.form.status&&(e.status=this.form.status.toString()),this.form.goods_id&&(e.goods_id=this.form.goods_id),this.form.receive_mobile&&(e.receive_mobile=this.form.receive_mobile),this.form.out_trade_no&&(e.out_trade_no=this.form.out_trade_no),this.form.mobile&&(e.mobile=this.form.mobile),0!==this.detail.user_id&&(e.invite_id=this.detail.user_id,Object(i._79)(e).then(function(e){e.list.forEach(function(t){t.refundList=[]}),t.tableData=e.list,t.orderListObj.total=e.total}))},getGoodsOption:function(){var t=this;Object(i._66)({page:1,limit:100,course_type:0}).then(function(e){t.goodList=e.list})},editComment:function(t,e){var a=this;this.$prompt("","编辑备注",{confirmButtonText:"确定",cancelButtonText:"取消",inputType:"textarea",inputValue:e||""}).then(function(e){var s=e.value;a.$confirm("确定保存?","提示",{confirmButtonText:"确定",cancelButtonText:"取消",type:"warning"}).then(function(){Object(i._20)(t,"order",{desc:s}).then(function(t){a.$message({type:"success",message:"编辑备注成功"}),a.getOrderList()})})})},showRef:function(t){this.refundDetail.show=!0,this.refundDetail.out_trade_no=t.out_trade_no},showCoupon:function(t){this.couponDetail.show=!0,this.couponDetail.order_coupon_id=t.order_coupon_id},showSource:function(t){this.sourceDialog.show=!0,this.sourceDialog.out_trade_no=t.out_trade_no},getyunjiList:function(){var t=this,e={limit:this.yunjiListObj.limit,page:this.yunjiListObj.nowPage};this.form.nickname&&(e.nickname=this.form.nickname),this.form.user_id&&(e.user_id=this.form.user_id),this.form.status&&(e.status=this.form.status.toString()),this.form.goods_id&&(e.goods_id=this.form.goods_id),this.form.receive_mobile&&(e.receive_mobile=this.form.receive_mobile),this.form.out_trade_no&&(e.out_trade_no=this.form.out_trade_no),this.form.mobile&&(e.mobile=this.form.mobile),this.id&&(e.teacher_id=this.id),Object(i._144)(e).then(function(e){t.yunjiListObj.total=e.total,t.yunjiList=e.list?e.list:[]})}},filters:{teacherType:function(t){return s.z[t]},percent:function(t){return(100*t).toFixed(2)+"%"},status:function(t){return s.t[t]},moneytFilter:function(t){return t/100+"元"},filterGoods:function(t){return"["+t.id+"]["+s.j[t.goods_type]+"]["+t.current_price/100+"元]"+t.name},classSource:function(t){return E[t]}},created:function(){this.customerObj.alias=this.parentDetail?this.parentDetail.alias:this.$route.params.alias,this.customerObj.name=this.parentDetail?this.parentDetail.name:this.$route.params.name,this.customerObj.adviser=this.parentDetail?this.parentDetail.adviser:this.$route.params.adviser},mounted:function(){this.id=this.parentDetail?this.parentDetail.id:this.$route.params.id,this.getTask4(),Object(i._104)().then(function(t){var e={};t.forEach(function(t,a){e[t.type]=t.name}),E=e}),this.getTeacherDetail(),this.getGoodsOption()},watch:{tabs:function(t){"order"===t&&this.getOrderList(),"yunji"===t&&this.getyunjiList(),"huashu"===t&&this.getList()}}},q={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("div",{staticClass:"teacher"},[a("div",{staticClass:"header"},[a("el-card",{staticStyle:{width:"450px",display:"inline-block","margin-right":"10px"}},[a("div",{attrs:{slot:"header"},slot:"header"},[a("span",[a("label",[t._v(t._s(t._f("teacherType")(t.detail.type))+"：")]),t._v(" "+t._s(t.detail.name)+"（T"+t._s(t.detail.squad)+"）")]),t._v(" "),t.$store.state.readonly?t._e():a("el-button",{staticStyle:{float:"right","margin-top":"-6px"},attrs:{size:"small",type:"success",plain:""},on:{click:function(e){t.onAddUser(!0)}}},[t._v("老师绑定用户")])],1),t._v(" "),a("div",{staticClass:"card-content"},[a("div",{staticClass:"text item"},[a("a",{attrs:{href:t.detail.qr,target:"_blank"}},[a("img",{attrs:{src:t.detail.qr}})])]),t._v(" "),a("div",{staticClass:"text item style-fix"},[a("span",[a("label",[t._v("微信号：")]),t._v(" "+t._s(t.detail.alias)+"\n          ")]),t._v(" "),a("span",[a("label",[t._v("带班总人数：")]),t._v(t._s(t.detail.total_join_num)+"\n          ")]),t._v(" "),a("span",[a("label",[t._v("老师状态：")]),t._v(t._s(0===t.detail.status?"正常":"禁用")+"\n          ")]),t._v(" "),a("span",[a("label",[t._v("顾问：")]),t._v(t._s(t.detail.adviser)+"\n          ")]),t._v(" "),a("span",[a("label",[t._v("开始时间：")]),t._v(t._s(t.detail.teacher_start)+"\n          ")])])])]),t._v(" "),t.detail.user_info?a("el-card",{staticStyle:{width:"450px",display:"inline-block","margin-right":"10px"}},[a("div",{attrs:{slot:"header"},slot:"header"},[a("span",[t._v("绑定用户")]),t._v(" "),a("el-button",{staticStyle:{float:"right"},attrs:{size:"mini",plain:"",type:"primary"},on:{click:function(e){t.createInviteLink(t.detail.user_info)}}},[t._v("复制专属链接")])],1),t._v(" "),a("div",{staticClass:"card-content"},[a("div",{staticClass:"text item"},[a("a",{attrs:{href:t.detail.user_info.avatar,target:"_blank"}},[a("img",{staticClass:"avatar",attrs:{src:t.detail.user_info.avatar}})])]),t._v(" "),a("div",{staticClass:"text item"},[a("label",[t._v("微信号：")]),t._v(" "+t._s(t.detail.user_info.nickname)+"\n        ")]),t._v(" "),a("div",{staticClass:"text item"},[a("label",[t._v("用户ID：")]),t._v(" "+t._s(t.detail.user_info.user_id)+"\n        ")])])]):t._e(),t._v(" "),t.task4Data?a("el-card",{staticStyle:{width:"320px",display:"inline-block"}},[a("div",{attrs:{slot:"header"},slot:"header"},[a("span",[t._v("当月销售转化率【"+t._s(t.nowDate)+"】")])]),t._v(" "),a("div",{staticClass:"text item"},[a("el-progress",{staticStyle:{float:"left","margin-right":"10px"},attrs:{type:"circle",percentage:Number(t.task4Data.trans_rate.split("%")[0])}})],1),t._v(" "),a("div",{staticClass:"card-content"},[a("div",{staticClass:"text item"},[a("label",[t._v("当月带班人数：")]),t._v(" "+t._s(t.task4Data.total_user_num)+"\n        ")]),t._v(" "),a("div",{staticClass:"text item"},[a("label",[t._v("当月购课人数：")]),t._v(" "+t._s(t.task4Data.total_sale_num)+"\n        ")]),t._v(" "),a("div",{staticClass:"text item"},[a("label",[t._v("当月累计业绩：")]),t._v(" "+t._s(t.task4Data.total_money)+"\n        ")])])]):t._e()],1),t._v(" "),a("el-tabs",{attrs:{type:"border-card"},model:{value:t.tabs,callback:function(e){t.tabs=e},expression:"tabs"}},[a("el-tab-pane",{attrs:{label:"今日任务",name:"task"}},[a("task",{attrs:{parentDetail:t.parentDetail}})],1),t._v(" "),a("el-tab-pane",{attrs:{label:"期数列表",name:"periods"}},[a("el-table",{attrs:{data:t.list},on:{"expand-change":t.changeRow}},[a("el-table-column",{attrs:{type:"expand"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-table",{attrs:{data:[e.row]}},[a("el-table-column",{attrs:{label:"到课率"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("span",[t._v(t._s(t._f("percent")(e.row.arrive_course_rate)))])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"看课率"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("span",[t._v(t._s(t._f("percent")(e.row.watch_course_rate)))])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"完课率"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("span",[t._v(t._s(t._f("percent")(e.row.over_course_rate)))])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"作业率"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("span",[t._v(t._s(t._f("percent")(e.row.work_rate)))])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"全勤作业率"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("span",[t._v(t._s(t._f("percent")(e.row.over_work_rate)))])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"打卡率"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("span",[t._v(t._s(t._f("percent")(e.row.clock_rate)))])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"全勤打卡率"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("span",[t._v(t._s(t._f("percent")(e.row.over_clock_rate)))])]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"转化率"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("span",[t._v(t._s(t._f("percent")(e.row.transform_rate)))])]}}])})],1)]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"periods_title",label:"期数名称"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("div",{domProps:{innerHTML:t._s(t.periodName(e.row))}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"class_name",label:"班级名称"}}),t._v(" "),a("el-table-column",{attrs:{prop:"join_num",label:"已进班人数",width:"90px"}}),t._v(" "),a("el-table-column",{attrs:{prop:"need_add_teacher_num",label:"需加好友数",width:"90px"}}),t._v(" "),a("el-table-column",{attrs:{prop:"max_join_num",label:"最大班级人数",width:"105px"}}),t._v(" "),a("el-table-column",{attrs:{prop:"start_at",label:"开课时间",width:"110px"}}),t._v(" "),a("el-table-column",{attrs:{prop:"source",label:"活动方案"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n            "+t._s(t._f("classSource")(e.row.source))+"\n          ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"操作",width:"100"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{size:"mini",plain:"",type:"primary"},on:{click:function(a){t.showUser(e.row)}}},[t._v("班级成员")])]}}])})],1),t._v(" "),a("page",{attrs:{total:t.total,limit:t.limit},on:{pageChange:t.onPageChange,sizeChange:t.onSizeChange}})],1),t._v(" "),a("el-tab-pane",{attrs:{label:"系统订单列表",name:"order"}},[a("el-form",{ref:"form",attrs:{model:t.form,"label-width":"100px",inline:""}},[a("el-form-item",{attrs:{label:"用户ID"}},[a("el-input",{model:{value:t.form.user_id,callback:function(e){t.$set(t.form,"user_id",e)},expression:"form.user_id"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"用户昵称"}},[a("el-input",{model:{value:t.form.nickname,callback:function(e){t.$set(t.form,"nickname",e)},expression:"form.nickname"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"用户手机号"}},[a("el-input",{model:{value:t.form.mobile,callback:function(e){t.$set(t.form,"mobile",e)},expression:"form.mobile"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"收件人手机号"}},[a("el-input",{model:{value:t.form.receive_mobile,callback:function(e){t.$set(t.form,"receive_mobile",e)},expression:"form.receive_mobile"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"商品名称"}},[a("el-select",{attrs:{filterable:"",placeholder:"请选择",clearable:""},on:{change:t.getOrderList},model:{value:t.form.goods_id,callback:function(e){t.$set(t.form,"goods_id",e)},expression:"form.goods_id"}},t._l(t.goodList,function(e,i){return a("el-option",{key:i,attrs:{label:t._f("filterGoods")(e),value:e.id}})}))],1),t._v(" "),a("el-form-item",{attrs:{label:"订单状态"}},[a("el-select",{attrs:{multiple:"",placeholder:"请选择",clearable:""},on:{change:t.getOrderList},model:{value:t.form.status,callback:function(e){t.$set(t.form,"status",e)},expression:"form.status"}},t._l(t.orderStatusOption,function(t){return a("el-option",{key:t.id,attrs:{label:t.value,value:t.id}})}))],1),t._v(" "),a("el-form-item",{attrs:{label:"交易订单号"}},[a("el-input",{model:{value:t.form.out_trade_no,callback:function(e){t.$set(t.form,"out_trade_no",e)},expression:"form.out_trade_no"}})],1),t._v(" "),a("el-form-item",[a("el-button",{attrs:{type:"primary",plain:""},on:{click:t.getOrderList}},[t._v("搜索")])],1)],1),t._v(" "),a("el-table",{staticClass:"order_list",attrs:{data:t.tableData,fixed:""}},[a("el-table-column",{attrs:{prop:"out_trade_no",label:"订单号"}}),t._v(" "),a("el-table-column",{attrs:{label:"购买人",className:"f-c",width:"150"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticClass:"avatar",attrs:{src:e.row.user_avatar}}),t._v(" "+t._s(e.row.user_nickname)),a("br"),t._v("(ID:"+t._s(e.row.user_id)+")"),a("br"),t._v("手机："+t._s(e.row.user_mobile)+"\n          ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"periods_title",label:"期数名称",width:"170px"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("div",{domProps:{innerHTML:t._s(t.periodName(e.row))}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"goods_name",label:"商品名称"}}),t._v(" "),a("el-table-column",{attrs:{width:"250",prop:"invite_id",className:"f-c",label:"推广人"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.invite_earnings>0&&0!==e.row.invite_id?a("div",{staticStyle:{width:"100%",display:"flex",color:"#409eff",cursor:"pointer"},on:{click:function(a){t.showSource(e.row)}}},[a("img",{staticClass:"avatar",attrs:{src:e.row.invite_avatar}}),t._v("\n              类型："+t._s(e.row.invite_type)+" ("+t._s(e.row.invite_name)+")\n              "),a("br"),t._v("\n              收益："+t._s(e.row.invite_earnings/100)+"\n              "),a("br"),t._v("\n              用户ID:"+t._s(e.row.invite_id)+"\n              "),a("br"),t._v("\n              昵称："+t._s(e.row.invite_nickname)+"\n              "),a("br"),t._v("\n              手机："+t._s(e.row.invite_mobile)+"\n            ")]):t._e(),t._v(" "),0===e.row.invite_earnings&&0!==e.row.invite_id?a("div",{staticStyle:{display:"flex"}},[a("img",{staticClass:"avatar",attrs:{src:e.row.invite_avatar}}),t._v("\n              类型："+t._s(e.row.invite_type)+" ("+t._s(e.row.invite_name)+")\n              "),a("br"),t._v("\n              收益："+t._s(e.row.invite_earnings/100)+"\n              "),a("br"),t._v("\n              用户ID:"+t._s(e.row.invite_id)+"\n              "),a("br"),t._v("\n              昵称："+t._s(e.row.invite_nickname)+"\n              "),a("br"),t._v("\n              手机："+t._s(e.row.invite_mobile)+"\n            ")]):t._e(),t._v(" "),0===e.row.invite_id?a("div",[t._v("无")]):t._e()]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"优惠活动"},scopedSlots:t._u([{key:"default",fn:function(e){return[0===e.row.order_coupon_id?a("span",[t._v("无")]):t._e(),t._v(" "),0!==e.row.order_coupon_id?a("el-button",{attrs:{type:"text"},on:{click:function(a){t.showCoupon(e.row)}}},[t._v("\n              优惠券\n            ")]):t._e()]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"付款状态",width:"80"},scopedSlots:t._u([{key:"default",fn:function(e){return[5===e.row.status||3===e.row.status?a("el-button",{attrs:{type:"text"},on:{click:function(a){t.showRef(e.row)}}},[t._v(t._s(t._f("status")(e.row.status)))]):t._e(),t._v(" "),5!==e.row.status&&3!==e.row.status?a("div",[t._v(t._s(t._f("status")(e.row.status)))]):t._e()]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"实付金额",width:"80"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n            "+t._s(t._f("moneytFilter")(e.row.money))+"\n          ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"收货地址"},scopedSlots:t._u([{key:"default",fn:function(e){return[e.row.user_address_id&&e.row.address_info?a("div",[t._v("\n              "+t._s(e.row.address_info.receive_name)),a("br"),t._v("\n              "+t._s(e.row.address_info.receive_mobile)),a("br"),t._v("\n              "+t._s(e.row.address_info.province_name)+t._s(e.row.address_info.city)+t._s(e.row.address_info.area)+t._s(e.row.address_info.address)+"\n            ")]):t._e()]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"pay_at",label:"购买时间",sortable:""}}),t._v(" "),a("el-table-column",{attrs:{prop:"created_at",label:"下单时间",sortable:""}}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"备注"}}),t._v(" "),t.$store.state.readonly?t._e():a("el-table-column",{attrs:{width:"50",label:"操作",fixed:"right"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-popover",{attrs:{placement:"top",width:"200"}},[a("div",{staticStyle:{"text-align":"center"}},[a("el-button",{attrs:{type:"info",plain:"",size:"mini"},on:{click:function(a){t.editComment(e.row.id,e.row.desc)}}},[t._v("编辑备注")])],1),t._v(" "),a("el-button",{attrs:{slot:"reference",size:"mini",type:"text"},slot:"reference"},[t._v("操作")])],1)]}}])})],1),t._v(" "),a("page",{attrs:{total:t.orderListObj.total,limit:t.orderListObj.limit},on:{pageChange:t.onPageChange2,sizeChange:t.onSizeChange2}})],1),t._v(" "),a("el-tab-pane",{attrs:{label:"外部订单列表",name:"yunji"}},[a("el-form",{ref:"form",attrs:{model:t.form,"label-width":"100px",inline:""}},[a("el-form-item",{attrs:{label:"用户ID"}},[a("el-input",{model:{value:t.form.user_id,callback:function(e){t.$set(t.form,"user_id",e)},expression:"form.user_id"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"用户昵称"}},[a("el-input",{model:{value:t.form.nickname,callback:function(e){t.$set(t.form,"nickname",e)},expression:"form.nickname"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"用户手机号"}},[a("el-input",{model:{value:t.form.mobile,callback:function(e){t.$set(t.form,"mobile",e)},expression:"form.mobile"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"收件人手机号"}},[a("el-input",{model:{value:t.form.receive_mobile,callback:function(e){t.$set(t.form,"receive_mobile",e)},expression:"form.receive_mobile"}})],1),t._v(" "),a("el-form-item",{attrs:{label:"商品名称"}},[a("el-select",{attrs:{filterable:"",placeholder:"请选择",clearable:""},on:{change:t.getyunjiList},model:{value:t.form.goods_id,callback:function(e){t.$set(t.form,"goods_id",e)},expression:"form.goods_id"}},t._l(t.goodList,function(e,i){return a("el-option",{key:i,attrs:{label:t._f("filterGoods")(e),value:e.id}})}))],1),t._v(" "),a("el-form-item",{attrs:{label:"订单状态"}},[a("el-select",{attrs:{multiple:"",placeholder:"请选择",clearable:""},on:{change:t.getyunjiList},model:{value:t.form.status,callback:function(e){t.$set(t.form,"status",e)},expression:"form.status"}},t._l(t.orderStatusOption,function(t){return a("el-option",{key:t.id,attrs:{label:t.value,value:t.id}})}))],1),t._v(" "),a("el-form-item",{attrs:{label:"交易订单号"}},[a("el-input",{model:{value:t.form.out_trade_no,callback:function(e){t.$set(t.form,"out_trade_no",e)},expression:"form.out_trade_no"}})],1),t._v(" "),a("el-form-item",[a("el-button",{attrs:{type:"primary",plain:""},on:{click:t.getyunjiList}},[t._v("搜索")])],1)],1),t._v(" "),a("el-table",{staticClass:"order_list",attrs:{data:t.yunjiList,fixed:""}},[a("el-table-column",{attrs:{prop:"order_id",width:"80",label:"订单号"}}),t._v(" "),a("el-table-column",{attrs:{prop:"nickname",label:"购买人"},scopedSlots:t._u([{key:"default",fn:function(e){return[0!==e.row.user_id?a("div",[a("img",{staticClass:"avatar",attrs:{src:e.row.avatar}}),t._v(" "),a("div",[t._v(t._s(e.row.nickname)),a("br"),t._v("(ID:"+t._s(e.row.user_id)+")")])]):t._e(),t._v(" "),0===e.row.user_id?a("div",[t._v("暂未绑定用户")]):t._e()]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"periods_title",label:"期数名称",width:"170px"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("div",{domProps:{innerHTML:t._s(t.periodName(e.row))}})]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"goods_name",label:"商品名称"}}),t._v(" "),a("el-table-column",{attrs:{prop:"invite_type",label:"来源"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n            "+t._s(e.row.invite_type)+"（"+t._s(e.row.invite_name)+"）\n          ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"付款状态",width:"80"},scopedSlots:t._u([{key:"default",fn:function(e){return[5===e.row.status||3===e.row.status?a("el-button",{attrs:{type:"text"},on:{click:function(a){t.showRef(e.row)}}},[t._v(t._s(t._f("status")(e.row.status)))]):t._e(),t._v(" "),5!==e.row.status&&3!==e.row.status?a("div",[t._v(t._s(t._f("status")(e.row.status)))]):t._e()]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"money",label:"实付金额",width:"70"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n            "+t._s(e.row.money/100)+"元\n          ")]}}])}),t._v(" "),a("el-table-column",{attrs:{label:"收货地址",width:"150px"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n            姓名："+t._s(e.row.receiver_name)+"\n            "),a("br"),t._v("\n            tel："+t._s(e.row.receiver_phone)+"\n            "),a("br"),t._v("\n            "+t._s(e.row.receiver_province)+" "+t._s(e.row.receiver_city)+" "+t._s(e.row.receiver_area)+" "+t._s(e.row.receiver_address)+"\n          ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"active_at",label:"激活时间",width:"90"},scopedSlots:t._u([{key:"default",fn:function(e){return[t._v("\n            "+t._s("0000-00-00 00:00:00"===e.row.active_at?"未激活":e.row.active_at)+"\n          ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"create_time",label:"下单时间",width:"90"}}),t._v(" "),a("el-table-column",{attrs:{prop:"pay_time",label:"付款时间",width:"90"}}),t._v(" "),a("el-table-column",{attrs:{prop:"user_status",formatter:t.userStatusFormatter,label:"沟通状态",width:"90"}}),t._v(" "),a("el-table-column",{attrs:{prop:"desc",label:"备注"}})],1),t._v(" "),a("page",{attrs:{total:t.yunjiListObj.total,limit:t.yunjiListObj.limit},on:{pageChange:t.onPageChange3,sizeChange:t.onSizeChange3}})],1),t._v(" "),a("el-tab-pane",{attrs:{label:"话术列表",name:"huashu"}},[a("div",{staticClass:"cssbox"},[a("el-tabs",{attrs:{type:"card"},on:{"tab-click":t.handleClick},model:{value:t.questionListParams.type,callback:function(e){t.$set(t.questionListParams,"type",e)},expression:"questionListParams.type"}},[a("el-tab-pane",{attrs:{label:"话术",name:"1"}}),t._v(" "),a("el-tab-pane",{attrs:{label:"流程",name:"2"}})],1),t._v(" "),a("el-collapse",{attrs:{accordion:""},on:{change:t.handleChange},model:{value:t.modularId,callback:function(e){t.modularId=e},expression:"modularId"}},t._l(t.modularList,function(e,i){return a("el-collapse-item",{key:i,attrs:{name:e.id}},[a("template",{slot:"title"},[t._v("\n              "+t._s(e.title)+"\n            ")]),t._v(" "),a("div",{staticClass:"search"},[a("el-input",{attrs:{placeholder:"请输入关键字"},model:{value:t.questionListParams.keywords,callback:function(e){t.$set(t.questionListParams,"keywords",e)},expression:"questionListParams.keywords"}}),t._v(" "),a("el-button",{attrs:{type:"primary",plain:""},on:{click:t.handleChange}},[t._v("搜索")])],1),t._v(" "),a("el-table",{staticStyle:{width:"100%"},attrs:{data:t.modularContent}},[a("el-table-column",{attrs:{prop:"title",label:"标题"}}),t._v(" "),a("el-table-column",{attrs:{prop:"keywords",label:"关键字"}}),t._v(" "),a("el-table-column",{attrs:{label:"创建时间",prop:"created_at"}}),t._v(" "),t.$store.state.readonly?t._e():a("el-table-column",{attrs:{width:"250",label:"操作"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("el-button",{attrs:{size:"mini",plain:"",type:"warning"},on:{click:function(a){t.showContent(e.row)}}},[t._v("查看内容")])]}}])})],1),t._v(" "),a("page",{attrs:{total:t.contentTotal,limit:t.contentLimit},on:{pageChange:t.onPageChangeC,sizeChange:t.onSizeChangeC}})],2)})),t._v(" "),a("page",{attrs:{total:t.modularTotal,limit:t.modularLimit},on:{pageChange:t.onPageChangeModular,sizeChange:t.onSizeChangeModular}}),t._v(" "),a("el-dialog",{ref:"ruleForm",attrs:{title:"",center:"","append-to-body":"",visible:t.postModularContentDialog,width:"800px"},on:{"update:visible":function(e){t.postModularContentDialog=e}}},[a("div",{staticClass:"quesion"},[a("p",{staticStyle:{"font-weight":"bold"}},[t._v("标题: ")]),a("span",[t._v(t._s(t.postModularParams.title))])]),t._v(" "),a("div",{staticClass:"quesion"},[a("p",{staticStyle:{"font-weight":"bold"}},[t._v("关键字:   ")]),a("span",[t._v(t._s(t.postModularParams.keywords))])]),t._v(" "),a("div",{staticClass:"ans"},[a("p",{staticStyle:{"font-weight":"bold"}},[t._v("内容:")]),t._v(" "),a("div",{domProps:{innerHTML:t._s(t.postModularParams.content)}})])])],1)])],1),t._v(" "),a("source-dialog",{attrs:{dialogObj:t.sourceDialog}}),t._v(" "),a("refund-detail",{attrs:{dialogObj:t.refundDetail}}),t._v(" "),a("coupon-dialog",{attrs:{dialogObj:t.couponDetail}}),t._v(" "),a("user-list",{attrs:{userObj:t.userObj},on:{reflash:t.getTeacherDetail}}),t._v(" "),a("choose-good-dialog",{attrs:{dialogObj:t.chooseGoodDialogObj},on:{changeShow:t.changeShow}}),t._v(" "),a("el-dialog",{attrs:{"append-to-body":"",visible:t.addShow,top:"5vh"},on:{"update:visible":function(e){t.addShow=e}}},[a("el-form",{attrs:{"label-width":"90px",inline:""}},[a("el-form-item",[a("el-input",{staticStyle:{width:"160px"},attrs:{placeholder:"ID"},on:{change:t.getUser},model:{value:t.searchFrom.userId,callback:function(e){t.$set(t.searchFrom,"userId",e)},expression:"searchFrom.userId"}})],1),t._v(" "),a("el-form-item",[a("el-input",{staticStyle:{width:"160px"},attrs:{placeholder:"昵称"},on:{change:t.getUser},model:{value:t.searchFrom.nickName,callback:function(e){t.$set(t.searchFrom,"nickName",e)},expression:"searchFrom.nickName"}})],1),t._v(" "),a("el-form-item",[a("el-input",{staticStyle:{width:"160px"},attrs:{placeholder:"电话"},on:{change:t.getUser},model:{value:t.searchFrom.mobile,callback:function(e){t.$set(t.searchFrom,"mobile",e)},expression:"searchFrom.mobile"}})],1),t._v(" "),a("el-form-item",[a("el-button",{attrs:{type:"primary",plain:""},on:{click:t.getUser}},[t._v("搜索")])],1)],1),t._v(" "),a("el-table",{ref:"multipleTable",attrs:{border:"",size:"small",data:t.userList},on:{"selection-change":t.handleSelectionChange}},[a("el-table-column",{attrs:{type:"selection",width:"55"}}),t._v(" "),a("el-table-column",{attrs:{className:"f-c",label:"用户"},scopedSlots:t._u([{key:"default",fn:function(e){return[a("img",{staticStyle:{"margin-right":"8px",width:"50px",height:"50px","border-radius":"50px"},attrs:{src:e.row.avatar}}),t._v(t._s(e.row.nickname)+"(ID:"+t._s(e.row.user_id)+")\n        ")]}}])}),t._v(" "),a("el-table-column",{attrs:{prop:"mobile",label:"手机号"}})],1),t._v(" "),a("page",{attrs:{total:t.userObj.total,limit:t.userObj.limit,small:!0},on:{pageChange:t.onPageChange3,sizeChange:t.onSizeChange3}}),t._v(" "),a("span",{staticClass:"dialog-footer",attrs:{slot:"footer"},slot:"footer"},[a("el-button",{on:{click:function(e){t.addShow=!1}}},[t._v("取 消")]),t._v(" "),a("el-button",{attrs:{type:"primary"},on:{click:t.onAdd}},[t._v("确 定")])],1)],1)],1)},staticRenderFns:[]};var R=a("VU/8")(U,q,!1,function(t){a("EsPn"),a("6r+I")},"data-v-72814c54",null);e.default=R.exports},iAw4:function(t,e){},khlY:function(t,e){},mWMt:function(module,__webpack_exports__,__webpack_require__){"use strict";var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Za={toString:function(t){return Object.prototype.toString.apply(t)},isDefined:function(t){return void 0!==t},isEmpty:function(t,e){return null===t||void 0===t||"NULL"===String(t).toUpperCase()||Za.isArray(t)&&!t.length||!e&&""===t||Za.isObject(t)&&"{}"===JSON.stringify(t)},isArray:function(t){return"[object Array]"===Za.toString(t)},isDate:function(t){return"[object Date]"===Za.toString(t)},isObject:function(t){return!!t&&"[object Object]"===Za.toString(t)},isJSON:function(t){if("string"==typeof t)try{var e=JSON.parse(t);return!("object"!=(void 0===e?"undefined":_typeof(e))||!e)}catch(t){return!1}},isFunction:function(t){return"[object Function]"===Za.toString(t)},isNumber:function(t){return"number"==typeof t&&isFinite(t)},isString:function(t){return"string"==typeof t},isBoolean:function(t){return"boolean"==typeof t},isPrimitive:function(t){return Za.isString(t)||Za.isNumber(t)||Za.isBoolean(t)},isUrl:function(t){return/(((^https?)|(^ftp)):\/\/((([\-\w]+\.)+\w{2,3}(\/[%\-\w]+(\.\w{2,})?)*(([\w\-\.\?\\\/+@&#;`~=%!]*)(\.\w{2,})?)*)|(localhost|LOCALHOST|127.0.0.1))\/?)/i.test(t)},getParameters:function(){var t=sessionStorage.getItem("_parameters");return sessionStorage.removeItem("_parameters"),Za.JsonEval(t)},clearParameters:function(){sessionStorage.removeItem("_parameters")},getDate:function(t){var e=new Date;return e.setDate(e.getDate()+t+1),e.getYear()+1900+"-"+(e.getMonth()+1<10?"0"+(e.getMonth()+1):e.getMonth()+1)+"-"+(e.getDate()<10?"0"+e.getDate():e.getDate())},JsonToStr:function(t){return JSON.stringify(t)},JsonEval:function JsonEval(str){return eval("("+str+")")}};__webpack_exports__.a=Za},mktT:function(t,e){}});