import Vue from 'vue'
import store from "@/store"
import Router from 'vue-router'
import Cookie from '../util/cookie'

Vue.use(Router);

const router =new Router({
  routes: [
    {
      path:'/login',
      name:'login',
      component: e=>require(['@/components/login'],e),
      meta:{
        skip_auth:true,
      }
    },
    {
      path: '/',
      name: 'index',
      component: e=>require(['@/components/framework'],e),
      redirect:{name:'first'},
      children:[
        {
          path: '',
          name:'first',
          component: e=>require(['@/components/main'],e),
        },{
          path: '/help',
          name:'help',
          component: e=>require(['@/components/help'],e),
        },{
          path: '/putForward',
          name:'putForward',
          component: e=>require(['@/components/putForward'],e),
        },{
          path: '/refund',
          name:'refund',
          component: e=>require(['@/components/refund'],e),
        },{
          path: '/noLesson',
          name:'noLesson',
          component: e=>require(['@/components/noLesson'],e),
        },{
          path: '/banner',
          name:'banner',
          component: e=>require(['@/components/system/banner'],e),
        },{
          path: '/weChatResource',
          name:'weChatResource',
          component: e=>require(['@/components/weChat/weChatResource'],e),
        },{
          path: '/menu',
          name:'menu',
          component: e=>require(['@/components/system/menu'],e),
        },{
          path: '/focusReply',
          name:'focusReply',
          component: e=>require(['@/components/weChat/focusReply'],e),
        },{
          path: '/weChat',
          name:'weChat',
          component: e=>require(['@/components/weChat'],e),
        },{
          path: '/autoReply',
          name:'autoReply',
          component: e=>require(['@/components/weChat/autoReply'],e),
        },{
          path: '/resources',
          name:'resources',
          component: e=>require(['@/components/resources'],e),
        },{
          path: '/periods',
          name:'periods',
          component: e=>require(['@/components/periods'],e),
        },{
          path: '/shop',
          name:'shop',
          component: e=>require(['@/components/shop'],e),
        },{
          path: '/consignment',
          name:'consignment',
          component: e=>require(['@/components/consignment'],e),
        },{
          path: '/single',
          name:'single',
          component: e=>require(['@/components/single'],e),
        },{
          path: '/box',
          name:'box',
          component: e=>require(['@/components/box'],e),
        },{
          path: '/lesson',
          name:'lesson',
          component: e=>require(['@/components/lesson'],e),
        },{
          path: '/user',
          name:'user',
          component: e=>require(['@/components/user'],e),
        },{
          path: '/teacher',
          name:'teacher',
          component: e=>require(['@/components/teacher'],e),
        },{
          path: '/admin',
          name:'admin',
          component: e=>require(['@/components/system/admin'],e),
        },{
          path: '/role',
          name:'role',
          component: e=>require(['@/components/system/role'],e),
        },
        {
          path: '/class',
          name:'class',
          component: e=>require(['@/components/class'],e),
        },{
          path: '/order',
          name:'order',
          component: e=>require(['@/components/order'],e),
        },{
          path: '/sysConfig',
          name:'sysConfig',
          component: e=>require(['@/components/system/sysConfig'],e),
        },
        {
          path: '/userOrder/:id',
          name:'userOrder',
          component: e=>require(['@/components/userOrder'],e),
        },
        {
          path: '/teacher/:id',
          name:'teacherDetail',
          component: e=>require(['@/components/teacherDetail'],e),
        },
      ]
    }
  ]
});
router.beforeEach((to,from,next)=> {
  store.commit('mainCanShow');
  if(Cookie.get('cc_token')){
    store.dispatch('setToken',Cookie.get('cc_token'));
    if(Cookie.get('cc_user_name') !== null){
      store.dispatch('setUserName',Cookie.get('cc_user_name'))
    }else{
    }
  }
  store.state.nowTab = to.name;
  if(to.matched.length > 1 && to.name !== 'first'){
    let thisMenu;
    for (let i = 0 ; i < store.state.menuList.length ; i ++ ){
      let _this = store.state.menuList[i];
      for (let j = 0 ; j < _this.list.length ; j++){
        let _that = _this.list[j];
        if (_that.path === to.path){
          thisMenu = _that
        }
      }
    }
    if(store.state.openedTab.indexOf(thisMenu) < 0){
      store.state.openedTab.push(thisMenu);
    }
  }
  // 登录拦截
  if (to.matched.some(record => record.meta.skip_auth !== true) && !store.state.token) {
    next({
      path: '/login'
    })
  } else {
    next()
  }
});

export default router;
