import Vue from 'vue';
import {post,fetch,patch,put,del} from './index'
const _baseUrl=process.env.API_URL;
Vue.prototype.$post=post;
Vue.prototype.$fetch=fetch;
Vue.prototype.$patch=patch;
Vue.prototype.$put=put;
Vue.prototype.$del=del;

const loginURL = `${_baseUrl}api/admin/login`;
const getAdminListUrl = `${_baseUrl}api/admin/user/list`;
const editAdminUrl = `${_baseUrl}api/admin/user/info`;
const addAdminUrl = `${_baseUrl}api/admin/user/add`;
const delAdminUrl = `${_baseUrl}api/admin/user`;
const editPasswordUrl = `${_baseUrl}api/admin/user/passwd`;
const logOutUrl = `${_baseUrl}api/admin/logout`;
//登录
export const loginApi = function(json) {
  return Vue.prototype.$post(loginURL,{"username":json.username,"passwd":json.password})
};
//退出登录
export const logoutApi = function() {
  return Vue.prototype.$post(logOutUrl)
};
//查询账号列表
export const getAdminListApi = function () {
  return Vue.prototype.$fetch(getAdminListUrl)
};
//修改账号信息
export const editAdminListApi = function (id,json) {
  return Vue.prototype.$put(`${editAdminUrl}/${id}`,json)
};
//添加账号
export const addAdminListApi = function (json) {
  return Vue.prototype.$post(addAdminUrl,json)
};
//删除账号
export const delAdminListApi = function (id) {
  return Vue.prototype.$del(`${delAdminUrl}/${id}`)
};
//修改密码
export const editPasswordApi = function (id,json) {
  return Vue.prototype.$patch(`${editPasswordUrl}/${id}`,json)
};


