import axios from 'axios';
import md5 from 'js-md5';
import { MessageBox ,Message  } from 'element-ui';
import Cookie from '../util/cookie'
// 默认超时设置
axios.defaults.timeout = 5000;
// 相对路径设置
axios.defaults.baseURL ='';
//http request 拦截器
axios.interceptors.request.use(
  config => {
    // 获取token
    const token = Cookie.get('cc_token');
    // 设置参数格式
    config.headers = {
      'Content-Type':'application/json',
    };
    // 添加token到headers
    if(token){
      config.headers.token = token
    }
    // 鉴权参数设置
    if(config.method === 'get' && config.url !== '/api/admin/login'){
      config.params = config.params || {}
      let json = JSON.parse(JSON.stringify(config.params));
      json.sing = "singsingenglish21000";
      config.params.param_token = md5(JSON.stringify(json));
    }else if(config.url !== '/api/admin/login'){
      config.data = config.data || {};
      let json = JSON.parse(JSON.stringify(config.data));
      json.sing = "singsingenglish21000";
      config.data.param_token = md5(JSON.stringify(json));
    }
    return config;
  },
  err => {
    return Promise.reject(err);
  }
);


//http response 拦截器
axios.interceptors.response.use(
  response => {
    if(response.data.code === 501){
      // 登录验证
      router.push({
        name:'login'//从哪个页面跳转
      })
    }
    return response;
  },
  error => {
    return Promise.reject(error)
  }
);


/**
 * 封装get方法
 * @param url
 * @param params
 * @returns {Promise}
 */

export function fetch(url,params={}){
  return new Promise((resolve,reject) => {
    axios.get(url,{
      params:params
    })
      .then(response => {
        if(response.data.code === 200){
          resolve(response.data.data);
        }else{
          Message.error(response.data.msg)
        }
      })
      .catch(err => {
        reject(err);
        let message = '请求失败！请检查网络';
        if(err.response)message=err.response.data.message;
        MessageBox({
          title:'错误！',
          message:message,
          type:'error',
        })
      })
  })
}


/**
 * 封装post请求
 * @param url
 * @param data
 * @returns {Promise}
 */

export function post(url,data = {}){
  return new Promise((resolve,reject) => {
    axios.post(url,data)
      .then(response => {
        if(response.data.code === 200){
          resolve(response.data.data);
        }else{
          Message.error(response.data.msg)
        }
      },err => {
        reject(err);
        let message = '请求失败！请检查网络';
        if(err.response)message=err.response.data.message;
        MessageBox({
          title:'错误！',
          message:message,
          type:'error',
        })
      })
  })
}

/**
 * 封装patch请求
 * @param url
 * @param data
 * @returns {Promise}
 */

export function patch(url,data = {}){
  return new Promise((resolve,reject) => {
    axios.patch(url,data)
      .then(response => {
        if(response.data.code === 200){
          resolve(response.data.data);
        }else{
          Message.error(response.data.msg)
        }
      },err => {
        reject(err);
        let message = '请求失败！请检查网络';
        if(err.response)message=err.response.data.message;
        MessageBox({
          title:'错误！',
          message:message,
          type:'error',
        })
      })
  })
}

/**
 * 封装put请求
 * @param url
 * @param data
 * @returns {Promise}
 */

export function put(url,data = {}){
  return new Promise((resolve,reject) => {
    axios.put(url,data)
      .then(response => {
        if(response.data.code === 200){
          resolve(response.data.data);
        }else{
          Message.error(response.data.msg)
        }
      },err => {
        reject(err);
        let message = '请求失败！请检查网络';
        if(err.response)message=err.response.data.message;
        MessageBox({
          title:'错误！',
          message:message,
          type:'error',
        })
      })
  })
}

export function del(url,data = {}){
  return new Promise((resolve,reject) => {
    axios.delete(url,data)
      .then(response => {
        if(response.data.code === 200){
          resolve(response.data.data);
        }else{
          Message.error(response.data.msg)
        }
      },err => {
        reject(err);
        let message = '请求失败！请检查网络';
        if(err.response)message=err.response.data.message;
        MessageBox({
          title:'错误！',
          message:message,
          type:'error',
        })
      })
  })
}
