export default function addEmoji(string) {

  function replaceAll(find, replace, str) {
    return str.replace(new RegExp(escapeRegExp(find), 'g'), replace);
  }

  function escapeRegExp(str) {
    return str.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
  }

  var map = {
    "[微笑]": "1.png",
    "[撇嘴]": "2.png",
    "[色]": "3.png",
    "[发呆]": "4.png",
    "[得意]": "5.png",
    "[流泪]": "6.png",
    "[害羞]": "7.png",
    "[闭嘴]": "8.png",
    "[睡]": "9.png",
    "[大哭]": "10.png",
    "[尴尬]": "11.png",
    "[发怒]": "12.png",
    "[调皮]": "13.png",
    "[呲牙]": "14.png",
    "[惊讶]": "15.png",
    "[难过]": "16.png",
    "[酷]": "17.png",
    "[囧]": "18.png",
    "[抓狂]": "19.png",
    "[吐]": "20.png",
    "[偷笑]": "21.png",
    "[愉快]": "22.png",
    "[白眼]": "23.png",
    "[傲慢]": "24.png",
    "[饥饿]": "25.png",
    "[困]": "26.png",
    "[惊恐]": "27.png",
    "[流汗]": "28.png",
    "[憨笑]": "29.png",
    "[悠闲]": "30.png",
    "[奋斗]": "31.png",
    "[咒骂]": "32.png",
    "[疑问]": "33.png",
    "[嘘]": "34.png",
    "[晕]": "35.png",
    "[衰]": "37.png",
    "[骷髅]": "38.png",
    "[敲打]": "39.png",
    "[再见]": "40.png",
    "[擦汗]": "41.png",
    "[抠鼻]": "42.png",
    "[鼓掌]": "43.png",
    "[糗大了]": "44.png",
    "[坏笑]": "45.png",
    "[左哼哼]": "46.png",
    "[右哼哼]": "47.png",
    "[哈欠]": "48.png",
    "[鄙视]": "49.png",
    "[委屈]": "50.png",
    "[快哭了]": "51.png",
    "[阴险]": "52.png",
    "[亲亲]": "53.png",
    "[吓]": "54.png",
    "[可怜]": "55.png",
    "[菜刀]": "56.png",
    "[西瓜]": "57.png",
    "[啤酒]": "58.png",
    "[篮球]": "59.png",
    "[乒乓]": "60.png",
    "[咖啡]": "61.png",
    "[饭]": "62.png",
    "[猪头]": "63.png",
    "[玫瑰]": "64.png",
    "[凋谢]": "65.png",
    "[嘴唇]": "66.png",
    "[爱心]": "67.png",
    "[心碎]": "68.png",
    "[蛋糕]": "69.png",
    "[闪电]": "70.png",
    "[炸弹]": "71.png",
    "[刀]": "72.png",
    "[足球]": "73.png",
    "[瓢虫]": "74.png",
    "[便便]": "75.png",
    "[月亮]": "76.png",
    "[太阳]": "77.png",
    "[礼物]": "78.png",
    "[拥抱]": "79.png",
    "[强]": "80.png",
    "[弱]": "81.png",
    "[握手]": "82.png",
    "[胜利]": "83.png",
    "[抱拳]": "84.png",
    "[勾引]": "85.png",
    "[拳头]": "86.png",
    "[差劲]": "87.png",
    "[爱你]": "88.png",
    "[NO]": "89.png",
    "[OK]": "90.png",
    "[爱情]": "91.png",
    "[飞吻]": "92.png",
    "[跳跳]": "93.png",
    "[发抖]": "94.png",
    "[怄火]": "95.png",
    "[转圈]": "96.png",
    "[磕头]": "97.png",
    "[回头]": "98.png",
    "[跳绳]": "99.png",
    "[投降]": "100.png",
    "[激动]": "101.png",
    "[乱舞]": "102.png",
    "[献吻]": "103.png",
    "[左太极]": "104.png",
    "[右太极]": "105.png",
    "[奸笑]": "106.png",
    "[嘿哈]": "107.png",
    "[捂脸]": "108.png",
    "[机智]": "109.png",
    "[茶]": "110.png",
    "[红包]": "111.png",
    "[蜡烛]": "113.png",
    "[耶]": "114.png"
  };

  string = string.replace(/\n/g, "<br/>");

  for (let key in map) {
    if (string.indexOf(key) != -1) {
      string = replaceAll(key, `<img src="/static/images/wechat/${map[key]}">`, string);
    }
  }

  return string

}
