import Vue from 'vue'
import store from "@/store"
import Router from 'vue-router'
import Cookie from '../util/cookie'

Vue.use(Router);

const router =new Router({
  routes: [
    {
      path: '/',
      name: 'index',
      component: e=>require(['@/components/framework'],e),
      redirect:{name:'first'},
      children:[
        {
          path: '',
          name:'first',
          component: e=>require(['@/components/main'],e),
        },
        {
          path: '/userOrder/:id',
          name:'userOrder',
          component: e=>require(['@/components/userOrder'],e),
        },
        {
          path: '/teacher/:id',
          name:'teacherDetail',
          component: e=>require(['@/components/teacherDetail'],e),
        }
      ]
    },
    {
      path:'/login',
      name:'login',
      component: e=>require(['@/components/login'],e),
      meta:{
        skip_auth:true,
      }
    }
  ]
});
router.beforeEach((to,from,next)=> {
  store.commit('mainCanShow');
  if(Cookie.get('cc_token')){
    store.dispatch('setToken',Cookie.get('cc_token'));
    store.dispatch('setPermission',JSON.parse(localStorage.getItem('permission')));
    if(Cookie.get('cc_user_name') !== null){
      store.dispatch('setUserName',Cookie.get('cc_user_name'))
    }else{
    }
  }
  store.state.nowTab = to.name;
  if(to.matched.length > 1 && to.name !== 'first'){
    let thisMenu;
    for (let i = 0 ; i < store.state.menuList.length ; i ++ ){
      let _this = store.state.menuList[i];
      for (let j = 0 ; j < _this.list.length ; j++){
        let _that = _this.list[j];
        if (_that.path === to.path){
          thisMenu = _that
        }
      }
    }
    if(store.state.openedTab.indexOf(thisMenu) < 0){
      store.state.openedTab.push(thisMenu);
    }
  }

  if(to.meta.readonly){
    store.dispatch('readonly',true)
  }else{
    store.dispatch('readonly',false)
  }

  // 登录拦截
  if (to.matched.some(record => record.meta.skip_auth !== true) && !store.state.token) {
    window.location.href = '/#/login'
  } else {
    next()
  }
});

export default router;
