import Vue from 'vue'
import store from "@/store"
import Router from 'vue-router'
import Cookie from '../util/cookie'

import index from '@/components/framework'
import main from '@/components/main'
import login from '@/components/login'
import resources from '@/components/resources'
import admin from '@/components/system/admin'
import role from '@/components/system/role'
import user from '@/components/user'
import teacher from '@/components/teacher'
import lesson from '@/components/lesson'
import box from '@/components/box'
import single from '@/components/single'
import periods from '@/components/periods';
import classList from '@/components/class'
import order from '@/components/order'
import shop from '@/components/shop'
import consignment from '@/components/consignment'
import notice from '@/components/notice'
import weChat from '@/components/weChat'
import help from '@/components/help'
Vue.use(Router);

const router =new Router({
  routes: [
    {
      path:'/login',
      name:'login',
      component:login,
      meta:{
        skip_auth:true,
      }
    },
    {
      path: '/',
      name: 'index',
      component: index,
      redirect:{name:'first'},
      children:[
        {
          path: '',
          name:'first',
          component: main
        },{
          path: '/help',
          name:'help',
          component: help
        },{
          path: '/notice',
          name:'notice',
          component: notice
        },{
          path: '/weChat',
          name:'weChat',
          component: weChat
        },{
          path: '/resources',
          name:'resources',
          component: resources
        },{
          path: '/periods',
          name:'periods',
          component: periods
        },{
          path: '/shop',
          name:'shop',
          component: shop
        },{
          path: '/consignment',
          name:'consignment',
          component: consignment
        },{
          path: '/single',
          name:'single',
          component: single
        },{
          path: '/box',
          name:'box',
          component: box
        },{
          path: '/lesson',
          name:'lesson',
          component: lesson
        },{
          path: '/user',
          name:'user',
          component: user
        },{
          path: '/teacher',
          name:'teacher',
          component: teacher
        },{
          path: '/admin',
          name:'admin',
          component: admin
        },{
          path: '/role',
          name:'role',
          component: role
        },
        {
          path: '/class',
          name:'class',
          component: classList
        },{
          path: '/order',
          name:'order',
          component: order
        },
      ]
    }
  ]
});
router.beforeEach((to,from,next)=> {
  //在已登录状态下不允许退回登录页面去
  // if (to.name === 'login' && store.state.token) {
  //   next(false);
  //   return;
  // }
  //获取cookie里的token
  store.commit('mainCanShow');
  if(Cookie.get('cc_token')){
    store.dispatch('setToken',Cookie.get('cc_token'));
    if(Cookie.get('cc_user_name') !== null){
      store.dispatch('setUserName',Cookie.get('cc_user_name'))
    }else{

    }
  }
  store.state.nowTab = to.name;
  if(to.matched.length > 1 && to.name !== 'first'){
    let thisMenu;
    for (let i = 0 ; i < store.state.menuList.length ; i ++ ){
      let _this = store.state.menuList[i];
      for (let j = 0 ; j < _this.list.length ; j++){
        let _that = _this.list[j];
        if (_that.path === to.path){
          thisMenu = _that
        }
      }
    }
  if(store.state.openedTab.indexOf(thisMenu) < 0){
    store.state.openedTab.push(thisMenu);
    console.log(store.state.openedTab)
  }
  }
  // 登录拦截
  if (to.matched.some(record => record.meta.skip_auth !== true) && !store.state.token) {
    next({
      path: '/login'
    })
  } else {
    next()
  }
});

  export default router;
