import Cookie from "@/util/cookie";

const mutations={
  //设置token
  setToken(state,token){
    state.token=token;
    Cookie.set('cc_token',token);
  },
  //设置用户名
  setUserName(state,userName){
    state.userName=userName;
    Cookie.set('cc_user_name',userName);
  },
  setPermission(state,data){
    state.progressList=data;
    localStorage.setItem('permission',JSON.stringify(data))
  },
  setMenu(state,data){
    state.menuList=data;
  },
  readonly(state,data){
    state.readonly=data;
  },
  deletePermission(state,data){
    state.deletePermission=data;
  },
  distribution(state,data){
    state.distribution=data;
  },
  classManage(state,data){
    state.classManage=data;
  },
  classManageUnlimited(state,data){
    state.classManageUnlimited=data;
  },
  classTakeUnlimited(state,data){
    state.classTakeUnlimited=data;
  },
  promoter(state,data){
    state.promoter=data;
  },
  mainCanShow(state){
    state.mainLoad = false
  },
  mainUnShow(state){
    state.mainLoad = true
  },
  changeParentRouter(state,data){
    state.menuList.find((a)=>{return a.name === data.name}).routerName = data.to.name
  },
  progress(state,data){
    switch (data.type) {
      case 'new':
        state.progressList.push({num:0,id:data.id});
        break;
      case 'change':
        state.progressList.find((x)=>{return x.id === data.id}).num = data.num;
        break;
      case 'delete':
        delete state.progressList.find((x)=>{return x.id === data.id});
        break
    }
  }
};
export default mutations;
