import Vue from 'vue';

import { post, fetch, patch, put, del, upload } from './index'
import md5 from "js-md5";
const _baseUrl = process.env.API_URL;
Vue.prototype.$post = post;
Vue.prototype.$fetch = fetch;
Vue.prototype.$patch = patch;
Vue.prototype.$put = put;
Vue.prototype.$del = del;
Vue.prototype.$upload = upload;

//登录
const loginURL = `${_baseUrl}api/admin/login`;
export const loginApi = function(json) {
    return Vue.prototype.$post(loginURL, { "username": json.username, "passwd": json.password })
};
//退出登录
const logOutUrl = `${_baseUrl}api/admin/logout`;
export const logoutApi = function() {
    return Vue.prototype.$post(logOutUrl)
};
//查询账号列表
const getAdminListUrl = `${_baseUrl}api/admin/user/list`;
export const getAdminListApi = function(json) {
    return Vue.prototype.$fetch(getAdminListUrl, json)
};
//修改账号信息
const editAdminUrl = `${_baseUrl}api/admin/user/info`;
export const editAdminListApi = function(id, json) {
    return Vue.prototype.$put(`${editAdminUrl}/${id}`, json)
};
//添加账号
const addAdminUrl = `${_baseUrl}api/admin/user/add`;
export const addAdminListApi = function(json) {
    return Vue.prototype.$post(addAdminUrl, json)
};
//删除账号
const delAdminUrl = `${_baseUrl}api/admin/user`;
export const delAdminListApi = function(id) {
    return Vue.prototype.$del(`${delAdminUrl}/${id}`)
};
//修改密码
const editPasswordUrl = `${_baseUrl}api/admin/user/passwd`;
export const editPasswordApi = function(id, json) {
    return Vue.prototype.$patch(`${editPasswordUrl}/${id}`, json)
};
//获取用户列表
const getUserListUrl = `${_baseUrl}api/admin/student/list`;
export const getUserListApi = function(json) {
    return Vue.prototype.$fetch(getUserListUrl, json)
};
//获取用户详情
const getUserDetailUrl = `${_baseUrl}api/admin/student/info`;
export const getUserDetailApi = function(id) {
    return Vue.prototype.$fetch(`${getUserDetailUrl}/${id}`)
};
//获取教师列表
const getTeacherListUrl = `${_baseUrl}api/admin/teacher/list`;
export const getTeacherListApi = function(json) {
    return Vue.prototype.$fetch(`${getTeacherListUrl}`, json)
};
//获取教师详情
const getTeacherDetailUrl = `${_baseUrl}api/admin/teacher/info`;
export const getTeacherDetailApi = function(id, json) {
    return Vue.prototype.$fetch(`${getTeacherDetailUrl}/${id}`, json)
};
//添加教师
const addTeacherUrl = `${_baseUrl}api/admin/teacher/add`;
export const addTeacherApi = function(json) {
    return Vue.prototype.$post(addTeacherUrl, json)
};
//更新教师信息
const editTeacherUrl = `${_baseUrl}api/admin/teacher/info`;
export const editTeacherApi = function(id, json) {
    return Vue.prototype.$put(`${editTeacherUrl}/${id}`, json)
};
//删除教师
const delTeacherUrl = `${_baseUrl}api/admin/teacher`;
export const delTeacherApi = function(id) {
    return Vue.prototype.$del(`${delTeacherUrl}/${id}`)
};
//获取课程列表
const getLessonUrl = `${_baseUrl}api/admin/course/list`;
export const getLessonApi = function(json) {
    return Vue.prototype.$fetch(getLessonUrl, json)
};
//获取课程详情
const getLessonDetailUrl = `${_baseUrl}api/admin/course/info`;
export const getLessonDetailApi = function(id, json) {
    return Vue.prototype.$fetch(`${getLessonDetailUrl}/${id}`, json)
};
//编辑课程详情
const editLessonDetailUrl = `${_baseUrl}api/admin/course/info`;
export const editLessonApi = function(id, json) {
    return Vue.prototype.$put(`${editLessonDetailUrl}/${id}`, json)
};
//删除课程
const deleteLessonUrl = `${_baseUrl}api/admin/course`;
export const deleteLessonAPI = function(id) {
    return Vue.prototype.$del(`${deleteLessonUrl}/${id}`)
};
//新增课程
const addLessonUrl = `${_baseUrl}api/admin/course/add`;
export const addLessonApi = function(json) {
    return Vue.prototype.$post(addLessonUrl, json)
};
//获取商品列表
const getGoodsListUrl = `${_baseUrl}api/admin/goods/list`;
export const getGoodsListApi = function(json) {
    return Vue.prototype.$fetch(getGoodsListUrl, json)
};
//获取商品详情
const getGoodsDetailUrl = `${_baseUrl}api/admin/goods/info`;
export const getGoodsDetailApi = function(id, json) {
    return Vue.prototype.$fetch(`${getGoodsDetailUrl}/${id}`, json)
};
//添加商品
const addGoodsUrl = `${_baseUrl}api/admin/goods/add`;
export const addGoodsApi = function(json) {
    return Vue.prototype.$post(addGoodsUrl, json)
};
//编辑商品
const editGoodsUrl = `${_baseUrl}api/admin/goods/info`;
export const editGoodsApi = function(id, json) {
    return Vue.prototype.$put(`${editGoodsUrl}/${id}`, json)
};
//删除商品
const deleteGoodsUrl = `${_baseUrl}api/admin/goods`;
export const deleteGoodsApi = function(id) {
    return Vue.prototype.$del(`${deleteGoodsUrl}/${id}`)
};
// 商品上架
const upGoodsUrl = `${_baseUrl}api/admin/goods/putaway/`;
export const upGoodsApi = function(id) {
    return Vue.prototype.$patch(`${upGoodsUrl}${id}`)
};
// 商品下架
const downGoodsUrl = `${_baseUrl}api/admin/goods/soldout/`;
export const downGoodsApi = function(id) {
    return Vue.prototype.$patch(`${downGoodsUrl}${id}`)
};
//查询元素、菜单分类
const getCategoryUrl = `${_baseUrl}api/admin/category/list/0`;
export const getCategoryApi = function(pid) {
    return Vue.prototype.$fetch(getCategoryUrl, { 'pid': pid })
};

// 添加教材菜单
const addCategoryUrl = `${_baseUrl}api/admin/category/add/0`;
export const addCategoryApi = function(json) {
    return Vue.prototype.$post(addCategoryUrl, json)
};
//删除分类
const delCategoryUrl = `${_baseUrl}api/admin/category`;
export const delCategoryApi = function(id) {
    return Vue.prototype.$del(`${delCategoryUrl}/${id}`)
};
//分类排序修改
const sortCategoryUrl = `${_baseUrl}api/admin/category/sort`;
export const sortCategoryApi = function(json) {
    return Vue.prototype.$patch(sortCategoryUrl, json)
};
//获取分类下的元素列表
const getCateDetailListUrl = `${_baseUrl}api/admin/element/list/0`;
export const getCateListApi = function(id) {
    return Vue.prototype.$fetch(getCateDetailListUrl, id)
};
// 添加元素
const addElementUrl = `${_baseUrl}api/admin/element/add/`;
export const addElementApi = function(json, type) {
    return Vue.prototype.$post(`${addElementUrl}${type}`, json)
};
// 查询元素详情
const getElemenetDetailUrl = `${_baseUrl}api/admin/element/`;
export const getElemenetDetailApi = function(id) {
    return Vue.prototype.$fetch(`${getElemenetDetailUrl}${id}`)
};
// 编辑元素
const editElementUrl = `${_baseUrl}api/admin/element/`;
export const editElementApi = function(json, id) {
    return Vue.prototype.$put(`${editElementUrl}${id}`, json)
};
// 删除元素
const delElementUrl = `${_baseUrl}api/admin/element/`;
export const delElementApi = function(id) {
    return Vue.prototype.$del(`${delElementUrl}${id}`)
};
// 获取单品列表
const getSingleListUrl = `${_baseUrl}api/admin/item/stock/list`;
export const getSingleListApi = function(json) {
    return Vue.prototype.$fetch(`${getSingleListUrl}`, json)
};
// 获取单品详情
const getSingleDetailUrl = `${_baseUrl}api/admin/item/stock/info/`;
export const getSingleDetailApi = function(id) {
    return Vue.prototype.$fetch(`${getSingleDetailUrl}${id}`)
};
// 删除单品
const delSingleUrl = `${_baseUrl}api/admin/item/stock/`;
export const delSingleApi = function(id) {
    return Vue.prototype.$del(`${delSingleUrl}${id}`)
};
// 新增单品
const addSingleUrl = `${_baseUrl}api/admin/item/stock/add`;
export const addSingleApi = function(json) {
    return Vue.prototype.$post(addSingleUrl, json)
};
// 修改单品
const editSingleUrl = `${_baseUrl}api/admin/item/stock/info/`;
export const editSingleApi = function(id, json) {
    return Vue.prototype.$put(`${editSingleUrl}${id}`, json)
};
// 获取盒子分类
const getBoxTypeListUrl = `${_baseUrl}api/admin/category/list/1`;
export const getBoxTypeListApi = function() {
    return Vue.prototype.$fetch(getBoxTypeListUrl)
};
// 获取盒子列表
const getBoxListUrl = `${_baseUrl}api/admin/item/box/list/`;
export const getBoxListApi = function(id) {
    return Vue.prototype.$fetch(`${getBoxListUrl}${id}`)
};
// 添加盒子
const addBoxUrl = `${_baseUrl}api/admin/item/box/add/`;
export const addBoxApi = function(id, json) {
    return Vue.prototype.$post(`${addBoxUrl}${id}`, json)
};
// 删除盒子
const delBoxUrl = `${_baseUrl}api/admin/item/box/`;
export const delBoxApi = function(id) {
    return Vue.prototype.$del(`${delBoxUrl}${id}`)
};
// 获取盒子详情
const getBoxDetailUrl = `${_baseUrl}api/admin/item/box/info/`;
export const getBoxDetailApi = function(id) {
    return Vue.prototype.$fetch(`${getBoxDetailUrl}${id}`)
};
// 更新盒子
const editBoxUrl = `${_baseUrl}api/admin/item/box/info/`;
export const editBoxApi = function(id, json) {
    return Vue.prototype.$put(`${editBoxUrl}${id}`, json)
};
// 获取公众号菜单
const getPublicMenuUrl = `${_baseUrl}api/admin/open/menu`;
export const getPublicMenuApi = function() {
    return Vue.prototype.$fetch(getPublicMenuUrl)
};
// 添加公众号菜单
export const savePublicMenuApi = function(json) {
    return Vue.prototype.$post(getPublicMenuUrl, json)
};
// 获取配置列表
const getConfigListUrl = `${_baseUrl}api/admin/sys/config/list`;
export const getConfigListApi = function(json) {
    return Vue.prototype.$fetch(getConfigListUrl, json)
};
// 新增系统配置
const saveConfigUrl = `${_baseUrl}api/admin/sys/config`;
export const saveConfigApi = function(json) {
    return Vue.prototype.$post(saveConfigUrl, json)
};

// 更新关键词
const updateConfigUrl = `${_baseUrl}api/admin/sys/config`;
export const updateConfigApi = function(config_id, json) {
    return Vue.prototype.$put(`${updateConfigUrl}/${config_id}`, json)
};

// 删除配置
const delConfigUrl = `${_baseUrl}api/admin/sys/config/`;
export const deleteConfigApi = function(config_id) {
    return Vue.prototype.$del(`${delConfigUrl}${config_id}`)
};
// 获取配置详情
const getConfigDetailUrl = `${_baseUrl}api/admin/sys/config/`;
export const getConfigDetailApi = function(id) {
    return Vue.prototype.$fetch(`${getConfigDetailUrl}${id}`)
};
// 获取素材列表
const getMediaListUrl = `${_baseUrl}api/admin/open/media/list`;
export const getMediaListApi = function(json) {
    return Vue.prototype.$fetch(getMediaListUrl, json)
};
// 文件上传
const uploadFileUrl = `${_baseUrl}api/public/upload/zone`;
export const uploadFileApi = function(json) {
    return Vue.prototype.$upload(uploadFileUrl, json)
};
// 获取菜单列表
const getMenuListUrl = `${_baseUrl}api/admin/category/list/2`;
export const getMenuListApi = function(json) {
    return Vue.prototype.$fetch(`${getMenuListUrl}`,json)
};
// 新增菜单
const addMenuListUrl = `${_baseUrl}api/admin/category/add/2`;
export const saveMenuApi = function(json) {
    return Vue.prototype.$post(addMenuListUrl, json)
};
// 更改菜单
const updateMenuUrl = `${_baseUrl}api/admin/category/`;
export const updateMenuApi = function(id, json) {
    return Vue.prototype.$put(`${updateMenuUrl}${id}`, json)
};
// 删除菜单
export const delMenuApi = function(id) {
    return Vue.prototype.$del(`${updateMenuUrl}${id}`)
};
// 获取权限列表
const getRoleListUrl = `${_baseUrl}api/admin/role/list`;
export const getRoleListApi = function(json) {
    return Vue.prototype.$fetch(`${getRoleListUrl}`, json)
};
// 新增角色
const addRoleUrl = `${_baseUrl}api/admin/role/add`;
export const saveRoleApi = function(json) {
    return Vue.prototype.$post(addRoleUrl, json)
};
// 更新权限
const updateRoleUrl = `${_baseUrl}api/admin/role/info/`;
export const updateRoleApi = function(id, json) {
    return Vue.prototype.$put(`${updateRoleUrl}${id}`, json)
};
// 获取权限详情
export const getRoleDetailApi = function(id) {
    return Vue.prototype.$fetch(`${updateRoleUrl}${id}`)
};
// 删除权限
const delRoleUrl = `${_baseUrl}api/admin/role/`;
export const delRoleApi = function(id) {
    return Vue.prototype.$del(`${delRoleUrl}${id}`)
};
// 获取banner列表
const getBannerListUrl = `${_baseUrl}api/admin/banner/list/`;
export const getBannerListApi = function(type,json) {
    return Vue.prototype.$fetch(getBannerListUrl+type, json)
};
// 添加banner
const addBannerUrl = `${_baseUrl}api/admin/banner/add/`;
export const addBannerApi = function(type,json) {
    return Vue.prototype.$post(addBannerUrl+type, json)
};
// 编辑banner
const editBannerUrl = `${_baseUrl}api/admin/banner/info/`;
export const editBannerApi = function(id, json) {
    return Vue.prototype.$put(`${editBannerUrl}${id}`, json)
};
// 获取banner详情
export const getBannerDetailApi = function(id) {
    return Vue.prototype.$fetch(`${editBannerUrl}${id}`)
};
// 删除banner
const delBannerUrl = `${_baseUrl}api/admin/banner/`;
export const delBannerApi = function(id) {
    return Vue.prototype.$del(`${delBannerUrl}${id}`)
};
// 移动顺序
const moveUrl = `${_baseUrl}api/admin/banner/sort`;
export const moveApi = function(upId, downId) {
    return Vue.prototype.$patch(`${moveUrl}`, { banner_up_id: upId, banner_down_id: downId })
};

// 获取期数列表
const getPeriodsUrl = `${_baseUrl}api/admin/periods/list`;
export const getPeriodsApi = function(json) {
    return Vue.prototype.$fetch(getPeriodsUrl, json)
};
// 添加期数
const getAddPeriodsUrl = `${_baseUrl}api/admin/periods/add/`;
export const getAddPeriodsApi = function(id, json) {
    return Vue.prototype.$post(`${getAddPeriodsUrl}${id}`, json)
};
// 编辑期数
const getEditPeriodsUrl = `${_baseUrl}api/admin/periods/info/`;
export const getEditPeriodsApi = function(id, json) {
    return Vue.prototype.$put(`${getEditPeriodsUrl}${id}`, json)
};
// 删除期数
const getDelPeriodUrl = `${_baseUrl}api/admin/periods/`;
export const delPeriodApi = function(id) {
    return Vue.prototype.$del(`${getDelPeriodUrl}${id}`)
};
// 获取班级列表
const getClassListUrl = `${_baseUrl}api/admin/periods/class/list/`;
export const getClassListApi = function(id,json,type) {
    // let typeParams = type?type:0
    return Vue.prototype.$fetch(`${getClassListUrl}${id}`, json)
};
// 获取当前期数下的老师列表
const getPeriodsTeacherUrl = `${_baseUrl}api/admin/periods/teacher/list/`;
export const getPeriodsTeacherApi = function(id) {
    return Vue.prototype.$fetch(`${getPeriodsTeacherUrl}${id}`)
};
// 删除班级
const delClassUrl = `${_baseUrl}api/admin/periods/class/`;
export const delClassApi = function(id) {
    return Vue.prototype.$del(`${delClassUrl}${id}`)
};
// 添加班级
const addClassUrl = `${_baseUrl}api/admin/periods/class/add/`;
export const addClassApi = function(id, json) {
    return Vue.prototype.$post(`${addClassUrl}${id}`, json)
};
// 修改班级
const editClassUrl = `${_baseUrl}api/admin/periods/class/info/`;
export const editClassApi = function(id, json) {
    return Vue.prototype.$put(`${editClassUrl}${id}`, json)
};
// 获取班级详情
const getClassDetailUrl = `${_baseUrl}api/admin/periods/class/info/`;
export const getClassDetailApi = function(id, json) {
    return Vue.prototype.$fetch(`${getClassDetailUrl}${id}`, json)
};
// 获取班级用户列表
const getClassUserUrl = `${_baseUrl}api/admin/class/user/list/`;
export const getClassUserApi = function(id, json) {
    return Vue.prototype.$fetch(`${getClassUserUrl}${id}`, json)
};
// 添加班级用户
const addClassUserUrl = `${_baseUrl}api/admin/class/user/add/`;
export const addClassUesrApi = function(classId, userId, json) {
    return Vue.prototype.$post(`${addClassUserUrl}${classId}/${userId}`, json)
};
// 更改看课权限
const changeUserUrl = `${_baseUrl}api/admin/class/user/`;
export const changeUserApi = function(id, json) {
    return Vue.prototype.$put(`${changeUserUrl}${id}`, json)
};
// 添加是否添加老师权限
const addUserTeacherUrl = `${_baseUrl}api/admin/class/user/teacher/`;
export const addUserTeacherApi = function(id, json) {
    return Vue.prototype.$put(`${addUserTeacherUrl}${id}`, json)
};
// 移除班级用户
const delClassUserUrl = `${_baseUrl}api/admin/class/user/`;
export const delClassUserApi = function(id) {
    return Vue.prototype.$del(`${delClassUserUrl}${id}`)
};
// 获取订单列表
const getOrderListUrl = `${_baseUrl}api/admin/order/list`;
export const getOrderListApi = function(json) {
    return Vue.prototype.$fetch(getOrderListUrl, json)
};
//手动添加订单
const setOrderUrl = `/api/admin/order`;
export const setOrderApi = function(json) {
    return Vue.prototype.$post(setOrderUrl,json)
}

// 修改订单备注
const editOrderDescUrl = `${_baseUrl}api/admin/order/desc/`;
export const editOrderDescApi = function(orderId, type, json) {
    return Vue.prototype.$put(`${editOrderDescUrl}${orderId}/${type}`, json)
};

// 给用户退款
const refundUrl = `${_baseUrl}api/admin/bill/refund/`;
export const refundApi = function(id, json) {
    return Vue.prototype.$post(`${refundUrl}${id}`, json)
};

// 修改订单收货地址
const editAddressUrl = `${_baseUrl}api/admin/order/address/`;
export const editAddressApi = function(id, json) {
    return Vue.prototype.$put(`${editAddressUrl}${id}`, json)
};

// 提现审核
const withdrawUrl = `${_baseUrl}/api/admin/order/withdraw/`;
export const withdrawApi = function(id, json) {
    return Vue.prototype.$post(`${withdrawUrl}${id}`, json)
};

// 退款列表
const getRefundListUrl = `${_baseUrl}api/admin/order/refund/list`;
export const getRefundListApi = function(json) {
    return Vue.prototype.$fetch(`${getRefundListUrl}`, json)
};

// 提现列表
const getWithdrawListUrl = `${_baseUrl}api/admin/order/withdraw/list`;
export const getWithdrawListApi = function(json) {
    return Vue.prototype.$fetch(`${getWithdrawListUrl}`, json)
};
// 新增盒子类型
const addBoxTypeUrl = `${_baseUrl}api/admin/category/add/1`;
export const addBoxTypeApi = function(json) {
    return Vue.prototype.$post(addBoxTypeUrl, json)
};

// 用户关联老师
const addRelatedTeacherUrl = `${_baseUrl}api/admin/student/bind/`;
export const addRelatedTeacherApi = function(id, json) {
    return Vue.prototype.$put(`${addRelatedTeacherUrl}${id}`, json)
};

// 操作日志
const getAdminLogListUrl = `${_baseUrl}api/admin/user/log`;
export const getAdminLogLisApi = function(json) {
    return Vue.prototype.$fetch(`${getAdminLogListUrl}`, json)
};
// 清除缓存
const clearCacheListUrl = `/api/admin/redis/key`;
export const clearCacheListApi = function(json) {
    return Vue.prototype.$del(`${clearCacheListUrl}/${json}`)
};

// 绑定其他商品
const bindOtherUrl = `${_baseUrl}api/admin/goods/bind/`;
export const bindOtherApi = function(goodsId, newGoodsId) {
    return Vue.prototype.$patch(`${bindOtherUrl}${goodsId}/${newGoodsId}`)
};

// 冲突商品
const conflictUrl = `${_baseUrl}api/admin/goods/conflict/`;
export const conflictApi = function(id, json) {
    return Vue.prototype.$patch(`${conflictUrl}${id}`, json)
};

// 班级用户添加备注
const addPeriodsClassUserDescUrl = `/api/admin/class/user/desc`;
export const addPeriodsClassUserDescApi = function(id, json) {
    return Vue.prototype.$post(`${addPeriodsClassUserDescUrl}/${id}`, json)
};
// 复制商品
const copyShopUrl = `/api/admin/goods/copy/`;
export const copyShopApi = function(id) {
    return Vue.prototype.$post(`${copyShopUrl}${id}`)
};
// 获取media详情
const getMediaUrl = `/api/admin/open/media/info`;
export const getMediaApi = function(id) {
    return Vue.prototype.$fetch(`${getMediaUrl}?media_id=${id}`)
};
// 期数数据统计
const getPeriodsStatisticsUrl = '/api/admin/periods/statistics/';
export const getPeriodsStatisticsApi = function(id) {
    return Vue.prototype.$fetch(`${getPeriodsStatisticsUrl}${id}`)
};
// 班级数据统计
const getClassStatisticsUrl = `/api/admin/periods/class/statistics/`;
export const getClassStatisticsApi = function(periods_id, class_id, json) {
    return Vue.prototype.$fetch(`${getClassStatisticsUrl}${periods_id}/${class_id}`, json)
};
// 用户看课情况
const userLookUrl = `/api/admin/user/static/list/`;
export const userLookApi = function(periods_id, user_id, json) {
    return Vue.prototype.$fetch(`${userLookUrl}${periods_id}/${user_id}`, json)
};
//订单统计
const orderCountUrl = `/api/admin/order/statistics`;
export const orderCountApi = function(json) {
    return Vue.prototype.$fetch(orderCountUrl, json)
};
// 切换期数与班级
const changeClassUrl = `/api/admin/change/class`;
export const changeClassApi = function(json) {
    return Vue.prototype.$put(changeClassUrl, json)
};
// 创建微信推广二维码
const createQrCodeUrl = '/api/admin/create/wechat/qrcode';
export const createQrCodeApi = function(json) {
    return Vue.prototype.$post(createQrCodeUrl, json)
};
// 获取公众号二维码
const getQrCodeListUrl = '/api/admin/wechat/qrcode/list';
export const getQrCodeListApi = function(json) {
    return Vue.prototype.$fetch(getQrCodeListUrl, json)
};
// 每日关注取关统计
const getWatchListUrl = '/api/admin/open/subscribe/statistics';
export const getWatchListApi = function(json) {
    return Vue.prototype.$fetch(getWatchListUrl, json)
};
// 获取群发结果
// const getMsgListUrl = '/api/admin/open/muti/msg';
// export const getMsgListApi = function(json) {
//     return Vue.prototype.$fetch(getMsgListUrl, json)
// };
// 群发客服消息
// const sendMsgUrl = `/api/admin/open/muti/msg`;
// export const sendMsgApi = function(json) {
//     return Vue.prototype.$post(`${sendMsgUrl}`, json)
// };
// 获取微信授权
const getwechatParamUrl = `${_baseUrl}api/client/jssdk`;
export const getwechatParam = function(json) {
    return Vue.prototype.$fetch(getwechatParamUrl, json)
};
// 默认当前体验营期数
const getDefaultPeriodsUrl = '/api/admin/periods/default';
export const getDefaultPeriodsApi = function() {
    return Vue.prototype.$fetch(getDefaultPeriodsUrl)
};
// 修改二维码管理
const updateQrCodeUrl = '/api/admin/wechat/qrcode';
export const updateQrCodeApi = function(id, json) {
    return Vue.prototype.$put(`${updateQrCodeUrl}/${id}`, json)
};
// 获取二维码列表详情
const getQrCodeDetailUrl = '/api/admin/wechat/qrcode';
export const getQrCodeDetailUrlApi = function(id) {
    return Vue.prototype.$fetch(`${getQrCodeDetailUrl}/${id}`)
};

const getAdsListlUrl = '/api/public/ads/list';
export const getAdsListApi = function(json) {
    return Vue.prototype.$fetch(getAdsListlUrl, json)
};

const getAdsInnerListUrl = '/api/admin/ads/list';
export const getAdsInnerListApi = function(json) {
    return Vue.prototype.$fetch(getAdsInnerListUrl, json)
};

// 外部投放修改备注
const updateAdsInnerUrl = '/api/admin/ads';
export const updateAdsInnerApi = function(id, json) {
    return Vue.prototype.$put(`${updateAdsInnerUrl}/${id}`, json)
};
// 外部投放批量修改备注
const updateAdsInnerPlUrl = '/api/admin/ads/multi/desc';
export const updateAdsInnerPlApi = function(json) {
    return Vue.prototype.$put(`${updateAdsInnerPlUrl}`, json)
};
// 订单使用红包列表
const getCouponListUrl = '/api/admin/order/coupon';
export const getCouponListApi = function(json) {
    return Vue.prototype.$fetch(getCouponListUrl, json)
};
// 更新二维码备注
const updateQrcodeDescUrl = '/api/admin/wechat/qrcode/desc';
export const updateQrcodeDescApi = function(id, json) {
    return Vue.prototype.$put(`${updateQrcodeDescUrl}/${id}`, json)
};
// banner上下架
const bannerChangeStatusUrl = `/api/admin/banner/status/`;
export const bannerChangeStatusApi = function(id, json) {
    return Vue.prototype.$put(`${bannerChangeStatusUrl}${id}`, json)
};
// 微信用户数据分析
const getWechatStatisticListUrl = '/api/admin/wechat/statistics';
export const getWechatStatisticListApi = function(json) {
    return Vue.prototype.$fetch(getWechatStatisticListUrl, json)
};
// 同步用户手机号
const getSyncUserUrl = '/api/admin/student/mobile';
export const getSyncUserApi = function(json) {
    return Vue.prototype.$fetch(getSyncUserUrl, json)
};
// 获取关注统计详情
const getStatisticsDetailUrl = '/api/admin/open/subscribe/statistics/detail';
export const getStatisticsDetailApi = function(json) {
    return Vue.prototype.$fetch(getStatisticsDetailUrl, json)
};
// 修改商品备注
const editGoodsDescUrl = `/api/admin/goods/info/desc/`;
export const editGoodsDescApi = function(goodsId, json) {
    return Vue.prototype.$put(`${editGoodsDescUrl}${goodsId}`, json)
};
// 管理员密码修改
const editAdminPasswordUrl = `/api/admin/user/passwd`;
export const editAdminPasswordApi = function(json) {
    return Vue.prototype.$patch(editAdminPasswordUrl, json)
};
// 导出
export const exportExcelApi = function(url, params) {
    url = `${url}?`;
    let json = JSON.parse(JSON.stringify(params))
    for (let k in json) {
        let reg = /^[0-9]+$/u;
        if (reg.test(json[k])) {
            json[k] = Number(json[k])
        }
        if (json[k] === null) {
            json[k] = ''
        }
        if (typeof json[k] === "string") {
            params[k] = params[k].replace(/(^\s*)|(\s*$)/g, "");
            json[k] = json[k].replace(/(^\s*)|(\s*$)/g, "");
        }
        json[k] = md5(json[k].toString())
    }
    json.sing = "singsingenglish21000";
    params.param_token = md5(JSON.stringify(json));
    let urlEncode = function(param, key, encode) {
        if (param == null) return '';
        let paramStr = [];
        let t = typeof(param);
        if (t === 'string' || t === 'number' || t === 'boolean') {
            paramStr.push( key + '=' + ((encode == null || encode) ? encodeURIComponent(param) : param))
        } else {
            for (let i in param) {
                let k = key == null ? i : key + (param instanceof Array ? '[' + i + ']' : '.' + i);
                paramStr.push(urlEncode(param[i], k, encode)) ;
            }
        }
        return paramStr.join('&');
    };
    url += urlEncode(params);
    console.log(url)
    window.open(url)
};
// 来源码列表
const getSourceListUrl = '/api/admin/code/rule';
export const getSourceListApi = function(json) {
    return Vue.prototype.$fetch(getSourceListUrl, json)
};
// 添加来源码
const addSourceUrl = '/api/admin/code/rule';
export const addSourceApi = function(json) {
    return Vue.prototype.$post(addSourceUrl, json)
};
// 修改来源码
const updateSourceUrl = '/api/admin/code/rule';
export const updateSourceApi = function(id, json) {
    return Vue.prototype.$put(`${updateSourceUrl}/${id}`, json)
};
// 删除来源码
const delSourceUrl = `/api/admin/code/rule/`;
export const delSourceApi = function(id) {
    return Vue.prototype.$del(`${delSourceUrl}${id}`)
};
// 修改商品购买数量
const updateGoodsNumberUrl = '/api/admin/goods/buy/nums';
export const updateGoodsNumbeApi = function(id, json) {
    return Vue.prototype.$put(`${updateGoodsNumberUrl}/${id}`, json)
};
// 获取班级用户备注列表
const getUserDescListUrl = '/api/admin/class/user/desc/';
export const getUserDescListApi = function(id, json) {
    return Vue.prototype.$fetch(`${getUserDescListUrl}${id}`, json)
};
// 更改用户看课权限，添加老师，意向等级
const updateUserPrivilegeUrl = '/api/admin/class/user';
export const updateUserPrivilegeApi = function(id, json) {
    return Vue.prototype.$put(`${updateUserPrivilegeUrl}/${id}`, json)
};
// 修改订单推广人信息
const updateOrderTeacherUrl = '/api/admin/order/invite';
export const updateOrderTeacherApi = function(id, teacherId) {
    return Vue.prototype.$put(`${updateOrderTeacherUrl}/${id}/${teacherId}`)
};
// 用户提现 api/admin/bill/pay/to/user
const payToUserUrl = '/api/admin/bill/pay/to/user';
export const payToUserApi = function(json) {
    return Vue.prototype.$post(payToUserUrl, json)
};
// 获取班主任业绩总排行
const getTeacherRankListUrl = '/api/admin/teacher/performance';
export const getTeacherRankListApi = function(json) {
    return Vue.prototype.$fetch(`${getTeacherRankListUrl}`, json)
};
// 班主任业绩排行按天
const getTeacherDayRankListUrl = '/api/admin/teacher/performance/day';
export const getTeacherDayRankListApi = function(json) {
    return Vue.prototype.$fetch(`${getTeacherDayRankListUrl}`, json)
};
// 老师绑定用户
const teacherBindUserUrl = '/api/admin/teacher/bind';
export const teacherBindUserApi = function(id, json) {
    return Vue.prototype.$put(`${teacherBindUserUrl}/${id}`, json)
};
// 获取老师加用户数，用户老师数
const getJoinNumUrl = '/api/admin/class/teacher/group/num/';
export const getJoinNumApi = function(id) {
    return Vue.prototype.$fetch(`${getJoinNumUrl}${id}`)
};
//获取短网址
const getLinkUrl = `/api/public/short/url`;
export const getLinkApi = function(json) {
    return Vue.prototype.$fetch(`${getLinkUrl}`, json)
};
//获取二维码
const getqrCodeUrl = `${_baseUrl}api/public/qrcode`;
export const getqrCodeApi = function(json) {
    return Vue.prototype.$fetch(`${getqrCodeUrl}`, json)
};
//设置系统指定配置
const putConfigUrl = `/api/admin/tools/config`;
export const putConfigApi = function(json) {
    return Vue.prototype.$put(`${putConfigUrl}`, json)
};
//用户领取课程日志
const getClassConfigUrl = `/api/admin/user/receive/course/log`;
export const getClassConfigApi = function(json) {
    return Vue.prototype.$fetch(`${getClassConfigUrl}`, json)
};
//扫码入课编辑备注
const updateDescUrl = `/api/admin/user/receive/course/log/desc/`;
export const updateDescApi = function(json,id) {
    return Vue.prototype.$put(`${updateDescUrl}${id}`, json)
};

//短信发送记录
const getsmsRecordUrl = `/api/admin/sms/log/list`;
export const getsmsRecordApi = function(json) {
    return Vue.prototype.$fetch(`${getsmsRecordUrl}`, json)
};
//云集订单列表
const getyunjiUrl = `/api/admin/yunji/order`;
export const getyunjiApi = function(json) {
    return Vue.prototype.$fetch(`${getyunjiUrl}`, json)
};

//云集绑定老师
const bindTeacherUrl = `/api/admin/yunji/order/bind/teacher/`;
export const bindTeacherApi = function(json,id) {
    return Vue.prototype.$put(`${bindTeacherUrl}${json}/${id}`)
};

//云集订单备注
const orderDescUrl = `/api/admin/yunji/order/desc/`;
export const orderDescApi = function(json,id) {
    return Vue.prototype.$put(`${orderDescUrl}${id}`,json)
};
//老师销卖课程列表
const getTeacherClassUrl = `/api/admin/teacher/performance/course/`;
export const getTeacherClassApi = function(json,id) {
    return Vue.prototype.$fetch(`${getTeacherClassUrl}${id}`,json)
};

//老系统用户列表
const getOldListUrl = `/api/admin/student/course/old/sys/`;
export const getOldListApi = function(json) {
    return Vue.prototype.$fetch(getOldListUrl,json)
};
//删除老系统用户
const delOldUseUrl = `/api/admin/student/course/old/sys/`;
export const delOldUseApi = function(id) {
    return Vue.prototype.$del(`${delOldUseUrl}${id}`)
};
// 存储预览课程数据
const saveViewDataUrl = '/api/admin/element/view/';
export const saveViewDataApi = function (id,json) {
  return Vue.prototype.$post(`${saveViewDataUrl}${id}`,json)
};
// 获取课程预览内容
const getViewDataUrl = '/api/admin/element/view/';
export const getViewDataApi = function (id) {
  return Vue.prototype.$fetch(`${getViewDataUrl}${id}`)
};

// 获取用户积分列表
const getIntegralListUrl = '/api/admin/student/integral';
export const getIntegralListApi = function (json) {
  return Vue.prototype.$fetch(getIntegralListUrl,json)
};
// 积分变更
const changeIntegralUrl = '/api/admin/student/integral';
export const changeIntegralApi = function (json) {
  return Vue.prototype.$post(changeIntegralUrl,json)
};

// 修改添加老师
const changeAddTeacherUrl ='/api/admin/class/user/add/teacher/';
export const changeAddTeacherApi = function (id, type) {
  return Vue.prototype.$put(`${changeAddTeacherUrl}${id}/${type}`,)
};

// 兑换码列表
const getExchangeListUrl = `/api/admin/exchange/list`;
export const getExchangeListApi = function (json) {
  return Vue.prototype.$fetch(getExchangeListUrl,json)
};

// 生成兑换码
const addExchangeUrl = `/api/admin/exchange/add`;
export const addExchangeApi = function (json) {
  return Vue.prototype.$post(addExchangeUrl,json)
};

// 兑换码详情
const exchangeDetailUrl = '/api/admin/exchange/detail/';
export const exchangeDetailApi = function (id, json) {
  return Vue.prototype.$fetch(`${exchangeDetailUrl}${id}`,json)
};

// 修改兑换码
const editExchangeUrl = `/api/admin/exchange/edit/`;
export const editExchangeApi = function (id, json) {
  return Vue.prototype.$put(`${editExchangeUrl}${id}`,json)
};

// 修改用户意向等级
const editUserWeightUrl = `/api/admin/class/user/weight/`;
export const editUserWeightApi = function (id, weight,json) {
  return Vue.prototype.$put(editUserWeightUrl + id + '/' + weight,json)
};

// 修改用户看课权限
const editUserViewCourseUrl = `/api/admin/class/user/view/course/`;
export const editUserViewCourseApi = function (id, is_view_course) {
  return Vue.prototype.$put(editUserViewCourseUrl + id + '/' + is_view_course)
};

// 班主任任务1 添加好友
const task1Url = `/api/admin/teacher/task1/`;
export const task1Api = function (id) {
  return Vue.prototype.$fetch(task1Url + id)
};

// 班主任任务2 意向等级
const task2Url = `/api/admin/teacher/task2/`;
export const task2Api = function (id) {
  return Vue.prototype.$fetch(task2Url + id)
};

// 班主任任务3 用户召回
const task3Url = `/api/admin/teacher/task3/`;
export const task3Api = function (id) {
  return Vue.prototype.$fetch(task3Url + id)
};

// 班主任任务5 活跃用户跟踪
const task5Url = `/api/admin/teacher/task5/`;
export const task5Api = function (id) {
  return Vue.prototype.$fetch(task5Url + id)
};

// 取出当前老师当前期数全勤的用户
const getOverWatchListUrl = `/api/admin/class/user/over/watch/list/`;
export const getOverWatchListApi = function (periods_id, teacher_id, json) {
  return Vue.prototype.$fetch(`${getOverWatchListUrl}${periods_id}/${teacher_id}`,json)
};

// 需要召回的用户（今日没看且去除前两天都没看的用户）
const getRecallUrl = `/api/admin/class/user/recall/list/`;
export const getRecallListApi = function (periods_id, teacher_id, json) {
  return Vue.prototype.$fetch(`${getRecallUrl}${periods_id}/${teacher_id}`,json)
};

//通过用户是否看课取出用户
const getWatchUserUrl = `/api/admin/class/user/watch/list/`;
export const getWatchUserApi = function (periods_id, teacher_id, json) {
  return Vue.prototype.$fetch(`${getWatchUserUrl}${periods_id}/${teacher_id}`,json)
};

// 班主任任务4
const task4Url = '/api/admin/teacher/task4/';
export const task4Api = function (teacher_id) {
  return Vue.prototype.$fetch(task4Url + teacher_id)
};

// 班主任任务6
const task6Url = '/api/admin/teacher/task6/';
export const task6Api = function (teacher_id,json) {
  return Vue.prototype.$fetch(task6Url + teacher_id,json)
};
// 班主任任务7
const task7Url = '/api/admin/teacher/task7/';
export const task7Api = function (teacher_id,json) {
  return Vue.prototype.$fetch(task7Url + teacher_id,json)
};
// 批量添加备注
const allDescUrl = `/api/admin/class/user/desc/multiple`;
export const allDescApi = function (json) {
  return Vue.prototype.$post(allDescUrl,json)
};

// 修改用户回复
const editUserReplyUrl = `/api/admin/class/user/desc/`;
export const  editUserReplyApi = function (id, json) {
  return Vue.prototype.$put(editUserReplyUrl + id, json)
};

// 用户积分排行
const integralUrl = '/api/admin/student/integral/hot/blog';
export const integralApi = function (json) {
  return Vue.prototype.$fetch(integralUrl,json)
};

// 外部订单批量指定老师邀请激活
const yunjiOrderTeacherUrl = '/api/admin/yunji/order/teacher/';
export const yunjiOrderTeacherApi = function (id, json) {
  return Vue.prototype.$put(yunjiOrderTeacherUrl+id,json)
};

// 获取当前市场招生数据
const getPeriodsClassCurDataUrl = '/api/admin/periods/class/cur/data';
export const getPeriodsClassCurDataApi = function (json) {
  return Vue.prototype.$fetch(getPeriodsClassCurDataUrl,json)
};

// 批量更新外部订单备注
const multiUrl = `/api/admin/yunji/order/multi/desc`;
export const multiApi = function (json) {
  return Vue.prototype.$put(multiUrl,json)
};

// 获取当前市场招生数据
const getSourceByDateUrl = '/api/admin/user/static/list';
export const getSourceByDateApi = function (periods_id,user_id,json) {
    console.log(periods_id,user_id)
  return Vue.prototype.$fetch(`${getSourceByDateUrl}/${periods_id}/${user_id}/v2`,json)
};
// 批量添加备注
const sendMsgUrl = `/api/admin/multi/msg/user`;
export const sendMsgApi = function (json) {
  return Vue.prototype.$post(sendMsgUrl,json)
};
const getMsgListUrl = `/api/admin/muti/msg/list`;
export const getMsgListApi = function (json) {
  return Vue.prototype.$fetch(getMsgListUrl,json)
};
const getMsgCountUrl = `/api/admin/multi/msg/user`;
export const getMsgCountApi = function (json) {
  return Vue.prototype.$fetch(`${getMsgCountUrl}`,json)
};
const updateFansUrl = `/api/admin/init/fans/info`;
export const updateFansApi = function (json) {
  return Vue.prototype.$put(`${updateFansUrl}`,json)
};
// 更新外部订单沟通情况
const updateContactUrl = `/api/admin/other/order/user/status`;
export const updateContactApi = function (json) {
  return Vue.prototype.$put(`${updateContactUrl}`,json)
};
// 外部渠道批量指派订单老师
const adsTeacherUrl = `/api/admin/ads/teacher/`;
export const adsTeacherApi = function (id,json) {
  return Vue.prototype.$put(`${adsTeacherUrl}${id}`,json)
};
// 更新外部渠道沟通状态
const updateAdsStatusUrl = `/api/admin/ads/user/status`;
export const updateAdsStatusApi = function (json) {
  return Vue.prototype.$put(`${updateAdsStatusUrl}`,json)
};
// 更新外部订单地址
const editOrderAdressUrl = '/api/admin/order/address/other/';
export const editOrderAdressApi = function (id, json) {
  return Vue.prototype.$put(editOrderAdressUrl+id,json)
};
// 看课排行
const getLookRankUrl = `/api/admin/class/user/watch/ranking/`;
export const getLookRankApi = function (classId,json) {
  return Vue.prototype.$fetch(`${getLookRankUrl}${classId}`,json)
};
//发生期数消息
const postActiveNoticeUrl = `/api/admin/active/notice/`;
export const postActiveNoticeApi = function (classId) {
  return Vue.prototype.$post(`${postActiveNoticeUrl}${classId}`)
};
//手动创建外部订单列表
const postOtherOrderUrl = `/api/admin/other/order`;
export const postOtherOrderApi = function (json) {
  return Vue.prototype.$post(`${postOtherOrderUrl}`,json)
};
//清除外部订单激活信息
export const postClearOtherOrderApi = function (id) {
  return Vue.prototype.$post(`/api/admin/other/order/clear/${id}`)
};
//新建话术/模块
export const postQuestionModularApi = function (json) {
  return Vue.prototype.$post(`/api/admin/question/`,json)
};
//话术/模块列表
export const getQuestionModularListApi = function (type,json) {
  return Vue.prototype.$fetch(`/api/admin/question/list/${type}`,json)
};
//话术/模块详情
export const getQuestionModularDetailApi = function (question_id) {
  return Vue.prototype.$fetch(`/api/admin/question/${question_id}`)
};
//更新话术/模块内容
export const updateQuestionModularDetailApi = function (question_id,json) {
  return Vue.prototype.$put(`/api/admin/question/${question_id}`,json)
};
//删除话术/模块
export const deleteQuestionModularDetailApi = function (question_id) {
    return Vue.prototype.$del(`/api/admin/question/${question_id}`)
};
//话术/模块排序
export const sortQuestionModularDetailApi = function (json) {
    return Vue.prototype.$put(`/api/admin/question/sort/`,json)
};
//用户收货地址
export const fetchAddressListApi = function (uid) {
    return Vue.prototype.$fetch(`/api/admin/student/address/${uid}`)
};
//用户收货地址编辑
export const editAddressListApi = function (uid,json) {
    return Vue.prototype.$put(`/api/admin/student/address/${uid}`,json)
};
//模板消息
export const getTemplatetApi = function (uid,json) {
    return Vue.prototype.$fetch(`/api/admin/open/template`,json)
};
//发送模板消息
export const sendTemplatetApi = function (json) {
    return Vue.prototype.$post(`/api/admin/open/template/send`,json)
};
//用户收货地址编辑
export const addAddressListApi = function (uid,json) {
    return Vue.prototype.$post(`/api/admin/student/address/${uid}`,json)
};
//用户当前亲情号
export const getSubAccountInfoApi = function (uid) {
    return Vue.prototype.$fetch(`/api/admin/student/bind/info/${uid}`)
};
//用户绑定记录
export const getUserSubAccountListApi = function (uid) {
    return Vue.prototype.$fetch(`/api/admin/student/bind/all/${uid}`)
};
//绑定子账号列表
export const getSubAccountListApi = function (json) {
    return Vue.prototype.$fetch(`/api/admin/student/bind/list`,json)
};
//自化体验课列表
export const getAutomationListApi = function (json) {
    return Vue.prototype.$fetch(`/api/admin/automation/list`,json)
};
//添加期数（云集）
export const addyunjiPeriodApi = function (period_id) {
    return Vue.prototype.$fetch(`/api/admin/config/common/yunji/add/${period_id}`)
};
//订单支付类型
export const getOrderTypeApi = function () {
    return Vue.prototype.$fetch(`/api/admin/order/type`)
};
//用户看课记录
export const getWatchRecordApi = function (json) {
    return Vue.prototype.$fetch(`/api/admin/student/teacher/watch`,json)
};
//修改优惠券过期时间
export const editCouponDeadlineApi = function (json,coupon_id) {
    return Vue.prototype.$put(`/api/admin/order/coupon/deadline/${coupon_id}`,json)
};
//添加星星活动期数
export const addStarActivityPeriodApi = function (periods_id) {
    return Vue.prototype.$post(`/api/admin/star/activity/periods/${periods_id}`)
};
//删除星星活动期数
export const delStarActivityPeriodApi = function (periods_id) {
    return Vue.prototype.$del(`/api/admin/sys/star/periods/${periods_id}`)
};
//删除星星活动期数
export const delYunjiActivityPeriodApi = function (periods_id) {
    return Vue.prototype.$del(`/api/admin/sys/yunji/periods/${periods_id}`)
};
//星星活动期数列表
export const getStarActivityPeriodApi = function () {
    return Vue.prototype.$fetch(`/api/admin/sys/star/activity`)
};
//云集活动期数列表
export const getYunjiActivityPeriodApi = function () {
    return Vue.prototype.$fetch(`api/admin/sys/yunji/periods`)
};
//待发货列表
export const getDeliverListApi = function (json) {
    return Vue.prototype.$fetch(`api/admin/order/deliver/list`,json)
};
//主题列表
export const getThemeListApi = function (json) {
    return Vue.prototype.$fetch(`api/admin/course/theme/list`,json)
};
//待发货列表
export const editDeliverAddressApi = function (deliver_id,json) {
    return Vue.prototype.$put(`/api/admin/order/deliver/edit/${deliver_id}`,json)
};
// /api/admin/order/deliver/edit/