/**
 *
 *  @classDesc 核心js基类,提供全局可用api
 *  @namespace ZA
 */

const Za = {
  /**
   * 转换为字符
   * @param v {object}
   * @returns {string}
   */
  toString: function (v) {
    return Object.prototype.toString.apply(v);
  },
  /**
   * 判断值是否已定义
   * @param v {*}
   * @returns {boolean}
   */
  isDefined: function (v) {
    return typeof v !== 'undefined';
  },
  /**
   * 是否为空
   * @param v  {*} 值
   * @param allowBlank {boolean} 是否允许空
   * @returns {boolean|*}
   */
  isEmpty: function (v, allowBlank) {
    return v === null || v === undefined
      || String(v).toUpperCase() === 'NULL'
      || ((Za.isArray(v) && !v.length))
      || (!allowBlank ? v === '' : false)
      || (Za.isObject(v) && JSON.stringify(v) === '{}')
  },

  /**
   * 是否是数组
   * @param v
   * @returns {boolean}
   */
  isArray: function (v) {
    return Za.toString(v) === '[object Array]';
  },
  /**
   * 是否是日期
   * @param v
   * @returns {boolean}
   */
  isDate: function (v) {
    return Za.toString(v) === '[object Date]';
  },
  /**
   * 是否是对象
   * @param v
   * @returns {boolean}
   */
  isObject: function (v) {
    return !!v && Za.toString(v) === '[object Object]';
  },
  /**
   * 字符串是否是对象
   * @param str
   * @returns {boolean}
   */
  isJSON(str) {
    if (typeof str == 'string') {
      try {
        var obj = JSON.parse(str);
        if (typeof obj == 'object' && obj) {
          return true;
        } else {
          return false;
        }

      } catch (e) {
        return false;
      }
    }
  },
  /**
   * 是否是函数
   * @param v
   * @returns {boolean}
   */
  isFunction: function (v) {
    return Za.toString(v) === '[object Function]';
  },
  /**
   * 是否是数值型
   * @param v
   * @returns {boolean}
   */
  isNumber: function (v) {
    return typeof v === 'number' && isFinite(v);
  },
  /**
   * 是否是字符型
   * @param v
   * @returns {boolean}
   */
  isString: function (v) {
    return typeof v === 'string';
  },
  /**
   * 是否是布尔型
   * @param v
   * @returns {boolean}
   */
  isBoolean: function (v) {
    return typeof v === 'boolean';
  },
  /**
   * 是否是原始类型
   * @param v
   * @returns {*|boolean}
   */
  isPrimitive: function (v) {
    return Za.isString(v) || Za.isNumber(v) || Za.isBoolean(v);
  },
  /**
   * 是否是URL
   * @param v
   * @returns {boolean}
   */
  isUrl: function (v) {
    return /(((^https?)|(^ftp)):\/\/((([\-\w]+\.)+\w{2,3}(\/[%\-\w]+(\.\w{2,})?)*(([\w\-\.\?\\\/+@&#;`~=%!]*)(\.\w{2,})?)*)|(localhost|LOCALHOST|127.0.0.1))\/?)/i
      .test(v);
  },

  /**
   * 返回parameters参数 特指页面跳转间传递的参数
   * @returns {*}
   */
  getParameters: function () {
    var params = sessionStorage.getItem("_parameters");
    sessionStorage.removeItem("_parameters");
    //params = Za.isEmpty(params) ? {} : params;
    return Za.JsonEval(params);
  },

  /**
   * 清空 页面间跳转的参数
   */
  clearParameters: function () {
    sessionStorage.removeItem("_parameters");
  },

  /**
   * 查询当前日前几天的日期
   * @param AddDayCount {int} 负数为前X天 正数为后X天
   * @returns {string}
   * @exaple
   *    Za.getDate(-6)
   */
  getDate: function (AddDayCount) { //日期查询
    var dd = new Date();
    dd.setDate(dd.getDate() + AddDayCount + 1);
    var y = dd.getYear() + 1900;
    var m = (dd.getMonth() + 1) < 10 ? "0" + (dd.getMonth() + 1) : (dd.getMonth() + 1);
    var d = dd.getDate() < 10 ? "0" + dd.getDate() : dd.getDate();
    return y + "-" + m + "-" + d;
  },


  /**
   * JSON对象转换为String
   * @param json
   * @constructor
   */
  JsonToStr: function (json) {
    return JSON.stringify(json);
  },
  /**
   * String转换为JSON
   * @param str
   * @returns {Object}
   * @constructor
   */
  JsonEval: function (str) {
    return eval("(" + str + ")");
    //return JSON.parse(str);
  },

};

export default Za
