import Vue from 'vue';
import { post, fetch, patch, put, del, upload, ret2 } from './index'
const _baseUrl = process.env.API_URL;
Vue.prototype.$post = post;
Vue.prototype.$fetch = fetch;
Vue.prototype.$patch = patch;
Vue.prototype.$put = put;
Vue.prototype.$del = del;
Vue.prototype.$upload = upload;
Vue.prototype.$ret2 = ret2;

// 获取banner列表
const getBannerListUrl = `${_baseUrl}api/client/banner/list`;
export const getBannerListApi = function () {
  return Vue.prototype.$fetch(getBannerListUrl)
};
const bannerListUrl = `/api/client/banner/list/`;
export const bannerListApi = function (type, json) {
  return Vue.prototype.$fetch(bannerListUrl + type, json)
};
// 获取微信授权
const getwechatParamUrl = `${_baseUrl}api/client/jssdk`;
export const getwechatParam = function (json) {
  return Vue.prototype.$fetch(getwechatParamUrl, json)
};

// 文件上传
const uploadFileUrl = `${_baseUrl}api/public/upload/zone`;
export const uploadFileApi = function (json) {
  return Vue.prototype.$upload(uploadFileUrl, json)
};

// 获取商品详情
const getGoodsDetailUrl = `${_baseUrl}api/client/goods/info/`;
export const getGoodsDetailApi = function (id) {
  return Vue.prototype.$fetch(`${getGoodsDetailUrl}${id}`)
};

//待发货收货地址修改
// 编辑用户活动地址
export const modifyAddressApi = function (json) {
  return Vue.prototype.$put(`${_baseUrl}api/client/deliver/edit`, json)
};

//用户最新物流信息
const getNewestAddressListUrl = `${_baseUrl}api/client/deliver/newest/list`;
export const getNewestAddressListAPi = function () {
  return Vue.prototype.$fetch(getNewestAddressListUrl)
};

// 获取用户地址
const getUserAdressUrl = `${_baseUrl}api/client/address/info`;
export const getUserAdressApi = function () {
  return Vue.prototype.$fetch(getUserAdressUrl)
};
// 微信支付
const payUrl = `${_baseUrl}api/client/bill/wechat/pay`
export const payApi = function (json) {
  return Vue.prototype.$fetch(payUrl, json)
};
// 保存用户地址
const saveAddressUrl = `${_baseUrl}api/client/address/save`
export const saveAddressApi = function (json) {
  return Vue.prototype.$post(saveAddressUrl, json)
};
// 保存用户活动地址
export const saveActivityAddressApi = function (json) {
  return Vue.prototype.$post(`${_baseUrl}api/client/user/starActivity/address`, json)
};

// 编辑用户活动地址
export const editActivityAddressApi = function (json, address_id) {
  return Vue.prototype.$put(`${_baseUrl}api/client/user/starActivity/address/edit/${address_id}`, json)
};

// 获取用户活动地址
export const getActivityAddressApi = function (json) {
  return Vue.prototype.$fetch(`${_baseUrl}api/client/user/starActivity/address/list`, json)
};

// 用户已购课程
const getUserLessonUrl = `${_baseUrl}api/client/user/course/list`
export const getUserLessonApi = function () {
  return Vue.prototype.$fetch(getUserLessonUrl)
};
// 课包列表
const getLessonListUrl = `${_baseUrl}api/client/course/category/list/`
export const getLessonListApi = function (id, json) {
  return Vue.prototype.$fetch(`${getLessonListUrl}${id}`, json)
};
// 获取主题列表
const getCourseListUrl = `${_baseUrl}api/client/course/relation/list/`
export const getCourseListApi = function (id) {
  return Vue.prototype.$fetch(`${getCourseListUrl}${id}`)
};
//获取课包详情
const getLessonDetailUrl = `${_baseUrl}api/client/element/info/`
export const getLessonDetailApi = function (periods_id, category_id, element_id) {
  return Vue.prototype.$fetch(`${getLessonDetailUrl}${periods_id}/${category_id}/${element_id}`)
};
// 获取客户详情
const getUserDetailUrl = `${_baseUrl}api/client/me`;
export const getUserDetailApi = function () {
  return Vue.prototype.$fetch(getUserDetailUrl)
};
// 提交看课数据
const subUserLessonUrl = `${_baseUrl}api/client/user/watch/log/`;
export const subUserLessonApi = function (element_id, category_id, periods_id, json) {
  return Vue.prototype.$post(`${subUserLessonUrl}${element_id}/${category_id}/${periods_id}`, json)
};
// 获取团购详情
const getGroupDetailUrl = `${_baseUrl}api/client/group/info/`;
export const getGroupDetailApi = function (group_id) {
  return Vue.prototype.$fetch(`${getGroupDetailUrl}${group_id}`)
};
// 获取订单详情
const getOrderDetailUrl = `${_baseUrl}api/client/order/info/`;
export const getOrderDetailApi = function (id) {
  return Vue.prototype.$fetch(`${getOrderDetailUrl}${id}`)
};
// 获取用户订单列表
const getOrderListUrl = `${_baseUrl}api/client/order/list`;
export const getOrderListApi = function (json) {
  return Vue.prototype.$fetch(getOrderListUrl, json)
};
// 用户看课统计
const getUserWatchUrl = `${_baseUrl}api/client/user/watch/report`;
export const getUserWatchApi = function (json) {
  return Vue.prototype.$fetch(getUserWatchUrl,json)
};
// 获取老师
const getTeacherDetailUrl = `${_baseUrl}api/client/me/teacher`;
export const getTeacherApi = function () {
  return Vue.prototype.$fetch(getTeacherDetailUrl)
};
// 获取新用户自动跳转
const getNewUrl = `${_baseUrl}api/client/new/user/direct`;
export const getNewApi = function () {
  return Vue.prototype.$fetch(getNewUrl)
};
// 查看是否可购买该商品
const getStatusWechatUrl = `${_baseUrl}api/client/bill/wechat/status`;
export const getStatusWechatApi = function (json) {
  return Vue.prototype.$fetch(getStatusWechatUrl, json)
};
// 用户可用优惠券
const getCouponListUrl = `${_baseUrl}api/client/user/coupon/list`;
export const getCouponListApi = function (id) {
  return Vue.prototype.$fetch(getCouponListUrl, { goods_id: id })
};
// 获取商品列表
const getGoodsListUrl = `${_baseUrl}api/client/goods/list`;
export const getGoodsListApi = function (json) {
  return Vue.prototype.$fetch(getGoodsListUrl, json)
};
//获取邀请战绩收益
const getInviteResultUrl = `${_baseUrl}api/client/user/invite/earnings`;
export const getInviteResultApi = function (json, id) {
  return Vue.prototype.$fetch(`${getInviteResultUrl}/${id}`, json)
};
//获取邀请战绩用户列表
const getInviteListUrl = `${_baseUrl}api/client/user/invite/list`;
export const getInviteListApi = function (json, id) {
  return Vue.prototype.$fetch(`${getInviteListUrl}/${id}`, json)
};
// 发送验证码
const sendMobileCodeUrl = `${_baseUrl}api/client/mobile/code`;
export const sendMobileCodeApi = function (json) {
  return Vue.prototype.$post(sendMobileCodeUrl, json)
};
// 绑定手机号
const bindMobileUrl = `${_baseUrl}api/client/user/mobile/bind`;
export const bindMobileApi = function (json) {
  console.log(json)
  return Vue.prototype.$put(bindMobileUrl, json)
};
// 用户通过订单号换课
const orderTransUrl = `${_baseUrl}api/client/user/mobile/bind/order_id`;
export const orderTransApi = function (json, order_id) {
  return Vue.prototype.$put(orderTransUrl, json)
};
// 获取引导参数
const getGuideUrl = `${_baseUrl}api/client/user/bootPage`;
export const getGuideApi = function (json) {
  return Vue.prototype.$fetch(getGuideUrl, json)
};
// 设置引导参数
const setGuideUrl = `${_baseUrl}api/client/user/bootPage`;
export const setGuideApi = function (json) {
  return Vue.prototype.$post(setGuideUrl, json)
};
// 查找跳转
const getRedirectUrl = `${_baseUrl}api/client/redirect`;
export const getRedirectApi = function (json) {
  return Vue.prototype.$fetch(getRedirectUrl, json)
};

// 获取用户收藏
const getUserCollectUrl = `${_baseUrl}api/client/user/collect`;
export const getUserCollectApi = function (json) {
  return Vue.prototype.$fetch(getUserCollectUrl, json)
};

// 用户添加收藏
const addUserCollectUrl = `${_baseUrl}api/client/user/collect`;
export const addUserCollectApi = function (json) {
  return Vue.prototype.$post(addUserCollectUrl, json)
};

// 用户取消收藏
const delUserCollectUrl = `${_baseUrl}api/client/user/collect/`;
export const delUserCollectApi = function (id) {
  return Vue.prototype.$put(delUserCollectUrl + id)
};

// 获取他人看课统计
const getOtherUserWatchUrl = `/api/client/user/watch/report/`;
export const getOtherUserWatchApi = function (id,json) {
  return Vue.prototype.$fetch(getOtherUserWatchUrl + id,json)
};

// 获取分享商品
const getShareGoodsUrl = '/api/client/share/goods';
export const getShareGoodsApi = function () {
  return Vue.prototype.$fetch(getShareGoodsUrl)
};

// 获取短网址
const getShortUrl = `/api/public/short/url`;
export const getShortApi = function (json) {
  return Vue.prototype.$fetch(getShortUrl, json)
};

// 获取用户总积分
const getUserIntegralUrl = '/api/client/user/last/integral';
export const getUserIntegralApi = function () {
  return Vue.prototype.$fetch(getUserIntegralUrl)
};

// 获取用户积分列表
const getUserIntegralListUrl = '/api/client/user/integral';
export const getUserIntegralListApi = function (json) {
  return Vue.prototype.$fetch(getUserIntegralListUrl, json)
};

// 兑换码兑换
const ExChangeUrl = `/api/client/user/mobile/bind/exchange`;
export const ExChangeApi = function (json) {
  return Vue.prototype.$put(ExChangeUrl, json)
};

// 获取可选择的期数
const getYujiListUrl = `/api/client/yunji/config`;
export const getYujiListUrlApi = function (json) {
  return Vue.prototype.$fetch(getYujiListUrl, json)
};
// 提交选择的期数
const postYujiListUrl = `/api/client/user/add/class/`;
export const postYujiListApi = function (id) {
  return Vue.prototype.$post(postYujiListUrl + id)
};
// 判断用户是否需要选择期数
const getCourseStatusUrl = `/api/client/user/course/status`;
export const getCourseStatusApi = function () {
  return Vue.prototype.$fetch(getCourseStatusUrl)
};
// 首页获取用户课程信息
const getCourseInfoUrl = `/api/client/user/course/info`;
export const getCourseInfoApi = function (periods_id) {
  // periods_id=12
  // debugger
  return periods_id ? Vue.prototype.$fetch(getCourseInfoUrl, { 'periods_id': periods_id }) : Vue.prototype.$fetch(getCourseInfoUrl)
};
// 宝宝昵称设置
const putBabyInfoUrl = `/api/client/me/set`;
export const putBabyInfoApi = function (json) {
  return Vue.prototype.$put(putBabyInfoUrl, json)
};
// 获取自动化商品数据
export const getAutomationApi = function (type, id) {
  return Vue.prototype.$fetch(`/api/client/course/automation/list/${type}/${id}`)
};
// 自动化看课推荐转化商品及其优惠券
export const getAutomationCouponApi = function () {
  return Vue.prototype.$fetch(`/api/client/recommend/conversion/goods`)
};
//用户总积分
export const getStarSumberApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/last/integral`)
};
//用户抽奖
export const getLuckDrawApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/luckDraw`)
};
//用户抽奖次数
export const getLuckDrawStatusApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/luckDraw/judge`)
};
//随机用户，抽奖人数
export const getLuckDrawRamdomsApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/luckDraw/rand`)
};
//解除绑定
export const unbindAccountApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/unbind/sub`)
};
//绑定子账号
export const bindAccountApi = function (authorization) {
  return Vue.prototype.$fetch(`/api/client/user/bind/sub/${authorization}`)
};
//生成授权码
export const creatAuthorizationApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/generate/authorization`)
};
//剩余绑定次数
export const countAuthorizationApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/bind/chance`)
};
//主账户查子账户
export const subAccountinfoApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/sub/info`)
};
//子账户查主账户
export const mainAccountinfoApi = function (authorization) {
  return Vue.prototype.$fetch(`/api/client/user/main/info/${authorization}`)
};
//查询子账户信息
export const searchAccountinfoApi = function (authorization) {
  return Vue.prototype.$fetch(`/api/client/user/click/link/${authorization}`)
};
//查询活动星星信息
export const getStarInfoApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/starActivity`)
};
//查询活动星星信息V2
export const getStarInfoV2Api = function () {
  return Vue.prototype.$fetch(`/api/client/user/startBonusActivity`)
};

//获取商品可用优惠券
export const getInvitedCouponApi = function (goods_id) {
  return Vue.prototype.$fetch(`/api/client/user/invited/coupon/${goods_id}`)
};
//领取商品可用优惠券
export const getReceiveCouponApi = function (goods_id) {
  return Vue.prototype.$fetch(`/api/client/user/receive/coupon/${goods_id}`)
};
//领取商品可用优惠券
export const getCountTimeApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/watch/time`)
};
//领取商品可用优惠券
export const getPassGoodInfoApi = function (goods_id) {
  return Vue.prototype.$fetch(`/api/client/goods/info/no/auth/${goods_id}`)
};
//友邦免费领取
export const getYoubangApi = function (json) {
  return Vue.prototype.$fetch(`/api/client/youbang/put`, json)
};
//友邦免费领取
export const postYoubangApi = function (json) {
  return Vue.prototype.$post(`/api/client/youbang/address/add`, json)
};
// 我的快递
export const getLogisticsApi = function (json) {
  return Vue.prototype.$fetch(`/api/client/deliver/list`, json)
};
// 报错日志
export const postErrorLogApi = function (json) {
  return Vue.prototype.$post(`api/client/report/errors/log`, json)
};

// 设置课程提醒时间
export const postNotifySettingApi = function (json) {
  return Vue.prototype.$post(`/api/client/user/notify/setting`, json)
};

// 用户成长记录添加
export const postUserGrowthAddApi = function (periods_id, category_id, element_id, json) {
  return Vue.prototype.$post(`api/client/user/growth/record/${ periods_id }/${ category_id }/${ element_id }`, json)
};

// 用户成长记录列表
export const getUserGrowthListApi = function (json) {
  return Vue.prototype.$fetch(`${_baseUrl}api/client/user/growth/record/list`)
};

//
const getUserGrowthRecordUrl = `${_baseUrl}api/client/growth/record/`
export const getUserGrowthRecordApi = function (periods_id, category_id, element_id) {
  return Vue.prototype.$fetch(`${getUserGrowthRecordUrl}${periods_id}/${category_id}/${element_id}`)
};

// 支付
export const postPayBillApi = function (json) {
  return Vue.prototype.$post(`/api/client/bill/create`, json)
};

// 获取课程推送设置
const getNotifyUrl = `${_baseUrl}api/client/user/notify/`
export const getNotifyApi = function (periods_id) {
  return Vue.prototype.$fetch(`${getNotifyUrl}${periods_id}`)
};

// 判断活动
const getJudgeActivityUrl = `${_baseUrl}api/client/judge/activity`
export const getJudgeActivityApi = function () {
  return Vue.prototype.$fetch(getJudgeActivityUrl)
};

// 打卡数据
const getReturnCashUrl = `${_baseUrl}api/client/new/return/cash/`
export const getReturnCashApi = function (periods_id, json) {
  return Vue.prototype.$fetch(`${getReturnCashUrl}${periods_id}`, json)
};

// 完成用户
const getFinishUserUrl = `${_baseUrl}api/client/card/finish/user/`
export const getFinishUserApi = function (periods_id) {
  return Vue.prototype.$fetch(`${getFinishUserUrl}${periods_id}`)
};

// 卡片跳转判断
const getCardGoUrl = `${_baseUrl}api/client/card/go/where/`
export const getCardGoApi = function (element_id, category_id, periods_id, getCardGoData) {
  return Vue.prototype.$fetch(`${getCardGoUrl}${element_id}/${category_id}/${periods_id}`, getCardGoData)
};

// 补卡
const getNewCashUrl = `${_baseUrl}api/client/new/return/cash/`
export const getNewCashApi = function (element_id, category_id, periods_id, json) {
  return Vue.prototype.$fetch(`${getNewCashUrl}${element_id}/${category_id}/${periods_id}`, json)
};

// 订单状态查询
/*export const postBillRefreshApi = function (json) {
  return Vue.prototype.$fetch(`/api/client/bill/refresh`, json)
};*/

const getBillRefreshUrl = `${_baseUrl}api/client/bill/refresh`
export const getBillRefreshApi = function (json) {
  return Vue.prototype.$fetch(getBillRefreshUrl, json)
};
