import Vue from 'vue'
import store from "@/store"
import common from '../util/common'
import Router from 'vue-router'
import sa from 'sa-sdk-javascript';
import { getUserDetailApi } from "../service/api";

Vue.use(Router);

let browser = {
  versions: function () {
    let u = navigator.userAgent, app = navigator.appVersion;

    return {         //移动终端浏览器版本信息
      trident: u.indexOf('Trident') > -1, //IE内核
      presto: u.indexOf('Presto') > -1, //opera内核
      webKit: u.indexOf('AppleWebKit') > -1, //苹果、谷歌内核
      gecko: u.indexOf('Gecko') > -1 && u.indexOf('KHTML') === -1, //火狐内核
      mobile: !!u.match(/AppleWebKit.*Mobile.*/), //是否为移动终端
      ios: !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/), //ios终端
      android: u.indexOf('Android') > -1 || u.indexOf('Linux') > -1, //android终端或uc浏览器
      iPhone: u.indexOf('iPhone') > -1, //是否为iPhone或者QQHD浏览器
      iPad: u.indexOf('iPad') > -1, //是否iPad
      webApp: u.indexOf('Safari') == -1 //是否web应该程序，没有头部与底部
    };
  }(),

  language: (navigator.browserLanguage || navigator.language).toLowerCase()
};
let ua = window.navigator.userAgent.toLowerCase();
const router = new Router({
  // mode: 'history',
  routes: [
    {
      path: '/',
      name: 'index',
      component: () => import('@/components/index'),//
      meta: {
        deep: 0,
      }
    },

    {
      path: '/extensionV1Shop',
      name: 'extensionV1Shop',
      component: () => import('@/components/activity/extensionV1Shop'),//
      meta: {
        deep: 0,
        noNew: true,
        title: '注册领取课程'
      }
    },
    {
      path: '/extensionV1',
      name: 'extensionV1',
      component: () => import('@/components/activity/extensionV1'),//
      meta: {
        deep: 0,
        noNew: true,
        title: '注册领取课程'
      }
    },
    {
      path: '/guideActivity',
      name: 'guideActivity',
      component: () => import('@/components/buy/guideActivity'),//
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/guide',
      name: 'guide',
      component: () => import('@/components/buy/guide'),//
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/spcShop',
      name: 'spcShop',
      component: () => import('@/components/buy/spcShop'),//
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/orderTrans',
      name: 'orderTrans',
      component: () => import('@/components/orderTrans/index'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/addressEdit',
      name: 'addressEdit',
      component: () => import('@/components/mine/addressEdit'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/addressModify',
      name: 'addressModify',
      component: () => import('@/components/mine/addressModify'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/subAccept',
      name: 'subAccept',
      component: () => import('@/components/subAccount/accept'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/subAccount',
      name: 'subAccount',
      component: () => import('@/components/subAccount/index'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/address',
      name: 'Address',
      component: () => import('@/components/mine/address'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/activityAddr',
      name: 'activityAddr',
      component: () => import('@/components/mine/activityAddr'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/liuyi',
      name: 'liuyi',
      component: () => import('@/components/activity/liuyi'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/starRank',
      name: 'starRank',
      component: () => import('@/components/star/starRank'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/starRankV2',
      name: 'starRankV2',
      component: () => import('@/components/star/starRankV2'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/starDetail',
      name: 'starDetail',
      component: () => import('@/components/star/detail'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/starResult',
      name: 'starResult',
      component: () => import('@/components/star/result'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/starResultV2',
      name: 'starResultV2',
      component: () => import('@/components/star/resultV2'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/zhibo',
      name: 'zhibo',
      component: () => import('@/components/indexPage/zb'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/med',
      name: 'med',
      component: () => import('@/components/indexPage/med'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/preview',
      name: 'preview',
      component: () => import('@/components/indexPage/preview'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/bbda',
      name: 'bbda',
      component: () => import('@/components/indexPage/bbda'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/exChange',
      name: 'exChange',
      component: () => import('@/components/exChange'),
      meta: {
        deep: 0,
        noNew: true,
      }
    }, {
      path: '/newLesson',
      name: 'newLesson',
      component: () => import('@/components/newLesson'),
      meta: {
        deep: 0
      }
    }, {
      path: '/star',
      name: 'star',
      component: () => import('@/components/star'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/shareGoods',
      name: 'shareGoods',
      component: () => import('@/components/newLesson/shareGoods'),
      meta: {
        deep: 0,
        noNew: true
      }
    }, {
      path: '/myGoodsList',
      name: 'myGoodsList',
      component: () => import('@/components/myGoodsList'),
      meta: {
        deep: 1
      }
    }, {
      path: '/mine',
      name: 'mine',
      component: () => import('@/components/mine/index'),
      meta: {
        deep: 1
      }
    }, {
      path: '/order',
      name: 'order',
      component: () => import('@/components/order'),
      meta: {
        deep: 2
      }
    }, {
      path: '/share',
      name: 'share',
      component: () => import('@/components/share'),
      meta: {
        deep: 2
      }
    },
    {
      path: '/author',
      name: 'author',
      component: () => import('@/components/author'),
      meta: {
        deep: 100,
        noNew: true
      }
    }, {
      path: '/buyDetail',
      name: 'buyDetail',
      component: () => import('@/components/buy/index'),
      meta: {
        skip_login: false,
        noNew: true,
        deep: 10
      }
    }, {
      path: '/buy',
      name: 'buy',
      component: () => import('@/components/buy/buy'),
      meta: {
        noNew: true,
        deep: 11
      }
    }, {
      path: '/success',
      name: 'success',
      component: () => import('@/components/buy/success'),
      meta: {
        noNew: true,
        deep: 12
      }
    }, {
      path: '/buySuccess',
      name: 'buySuccess',
      component: () => import('@/components/buy/buySuccess'),
      meta: {
        noNew: true,
        deep: 12
      }
    }, {
      path: '/map',
      name: 'map',
      component: () => import('@/components/map/index'),
      meta: {
        deep: 3
      }
    },
    {
      path: '/saleSuccess',
      name: 'saleSuccess',
      component: () => import('@/components/buy/saleSuccess'),
      meta: {
        deep: 4
      }
    }, {
      path: '/bindMobile',
      name: 'bindMobile',
      component: () => import('@/components/bindMobile'),
      meta: {
        deep: 0
      }
    },
    {
      path: '/activity',
      name: 'activity',
      component: () => import('@/components/buy/activity'),
      meta: {
        skip_login: true,
        noNew: true,
      }
    },
    {
      path: '/inviteFriends',
      name: 'inviteFriends',
      component: () => import('@/components/buy/inviteFriends'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/inviteRecordList',
      name: 'inviteRecordList',
      component: () => import('@/components/buy/inviteRecordList'),
      meta: {
        deep: 0,
        noNew: true,
      }
    },
    {
      path: '/activityInvite',
      name: 'activityInvite',
      component: () => import('@/components/buy/activityInvite'),
      meta: {
        skip_login: true,
        noNew: true,
      }
    },
    {
      path: '/inviteList',
      name: 'inviteList',
      component: () => import('@/components/buy/inviteList'),
      meta: {
        skip_login: true,
        noNew: true,
      }
    },
    {
      path: '/collection',
      name: 'collection',
      component: () => import('@/components/collection'),
      meta: {
        skip_login: true
      }
    },
    {
      path: '/noWechat',
      name: 'noWechat',
      component: () => import('@/components/noWechat'),
      meta: {
        skip_login: false
      }
    },
    {
      path: '/mpShop',
      name: 'mpShop',
      component: () => import('@/components/buy/mpShop'),
      meta: {
        skip_login: false,
        noNew: true,
      }
    },
    {
      path: '/shareConfig',
      name: 'shareConfig',
      component: () => import('@/components/shareConfig'),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/inspectorActivit',
      name: 'inspectorActivit',
      component: () => import('@/components/inspector/inspectorActivit'),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/inspectorList',
      name: 'inspectorList',
      component: () => import('@/components/inspector/inspectorList'),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/secMap',
      name: 'secMap',
      component: () => import('@/components/map/secMap'),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/hasaccount',
      name: 'hasaccount',
      component: () => import('@/components/map/hasaccount'),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/oldShareGoods',
      name: 'oldShareGoods',
      component: e => require(['@/components/newLesson/oldShareGoods'], e),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/passShop',
      name: 'passShop',
      component: e => require(['@/components/buy/passShop'], e),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/ybIndex',
      name: 'ybIndex',
      component: e => require(['@/components/youbang/index'], e),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/ybOrderRender',
      name: 'ybOrderRender',
      component: e => require(['@/components/youbang/ybOrderRender'], e),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/ybPaySuccess',
      name: 'ybPaySuccess',
      component: e => require(['@/components/youbang/ybPaySuccess'], e),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/ybNav',
      name: 'ybNav',
      component: e => require(['@/components/youbang/nav'], e),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/navShare',
      name: 'navShare',
      component: e => require(['@/components/newLesson/navShare'], e),
      meta: {
        noNew: true,
      }
    },
    {
      path: '/logistics',
      name: 'logistics',
      component: e => require(['@/components/logistics'], e),
      meta: {
        noNew: true,
      }
    },
    // 评价页面
    {
      path: '/evaluate',
      name: 'evaluate',
      component: e => require(['@/components/newLesson/evaluate'], e),
      meta: {
        noNew: true,
      }
    },
    // 成长记录
    {
      path: '/growthRecord',
      name: 'growthRecord',
      component: e => require(['@/components/growthRecord'], e),
      meta: {
        deep: 0,
        noNew: true,
        title: '成长记录'
      }
    },
    // 时间提示
    {
      path: '/promptTime',
      name: 'promptTime',
      component: e => require(['@/components/map/promptTime'], e)
    },
    {
      path: '*',
      component: () => import('@/components/error'),
    },
  ]
});

router.beforeEach((to, from, next) => {
  // console.log(process.env)
  // 神策路由埋点
  Vue.nextTick(() => {
    sa.quick("autoTrackSinglePage");
  });
  // 判断是否是微信环境 排除本地
  if (ua.match(/MicroMessenger/i) == 'micromessenger' || ua.match(/_SQ_/i) == '_sq_') {
    if (to.name == 'noWechat') {
      // 在微信里打开非微信提示页
      if (to.query.url) {
        next(decodeURIComponent(to.query.url))
      } else {
        next({ name: 'index' });
      }
    }
  } else {
    if (to.name !== 'noWechat' && process.env.NODE_ENV === 'production') {
      next({ name: 'noWechat', query: { url: encodeURIComponent(to.fullPath) } });
    }
  }
  // 移动端判断
  store.dispatch('isMobile', browser.versions.mobile);
  // 默认title
  if (process.env.NODE_ENV === 'production') {
    document.title = '唱唱启蒙英语';
  } else {
    document.title = '唱唱测试';
  }
  if (to.meta.title) {
    document.title = to.meta.title;
  }
  let goOn = function () {
    if (localStorage.getItem('retUrl') && localStorage.getItem('retUrl') !== null && localStorage.getItem('retUrl') !== '') {
      console.log(localStorage.getItem('retUrl'))
      let retUrl = localStorage.getItem('retUrl').toString();
      localStorage.removeItem('retUrl');
      next(retUrl);
    } else {
      next()
    }
  };
  if (window.location.href.indexOf('gdt_vid') > -1) {
    localStorage.setItem('gdt_vid', common.getParamhref().gdt_vid);
  }
  // extensionV1Shop
  // extensionV1
  // mpShop
  if (to.name === 'spcShop' || to.name === 'mpShop' || to.name === 'extensionV1Shop' || to.name === 'extensionV1' || to.name === 'author' || to.name === 'bindMobile' || to.name === 'noWechat' || to.name === 'inspectorActivit'  || to.name === 'buyDetail'|| to.name === 'passShop'|| to.name === 'ybIndex' ) {
    // 无需登录的页面
    console.log(488)
    next()
  } else if (window.location.href.indexOf('token') > -1 && to.name === 'index') {
    let token = common.getUrlParam().token || to.query.token;
    console.log(common.getUrlParam())
    console.log(to.name)
    // debugger
    store.dispatch('setToken', token);
    getUserDetailApi().then(res => {
      // debugger
      localStorage.setItem('userDesc', JSON.stringify(res));
      sa.login(res.user_id);
      goOn()
    }).catch((res) => {
      console.log(res)
      // debugger
      if (localStorage.getItem('userDesc')) {
        goOn()
      }
    });
  } else if (localStorage.getItem('cc_token')) {
    // 已登陆
    store.dispatch('setToken', localStorage.getItem('cc_token'));
    if (localStorage.getItem('userDesc')) {
      sa.login(JSON.parse(localStorage.getItem('userDesc')).user_id);
      goOn()
    } else {
      getUserDetailApi().then(res => {
        localStorage.setItem('userDesc', JSON.stringify(res));
        sa.login(res.user_id);
        goOn()
      }).catch(() => {
        if (localStorage.getItem('userDesc')) {
          goOn()
        }
      });
    }
    // debugger
  } else {
    // 未登陆，保存下路径
    let query = { retUrl: to.fullPath };
    localStorage.setItem('retUrl', to.fullPath);
    // console.log(process.env.AUTHOR_UEL)
    // console.log(window.location.href)

    if (to.meta.noNew) {
      query.is_new_user_url = 1;
      window.location.href = `${process.env.AUTHOR_UEL}`
      // debugger
    } else {
      window.location.href = `${process.env.AUTHOR_UEL}&is_new_user_url=1`
    }
    // debugger
  }

  // if(to.meta.skip_login){

  //   next();
  // }
});

export default router;
