import Vue from 'vue'
import store from "@/store"
import common from '../util/common'
import Router from 'vue-router'
Vue.use(Router);

const router =new Router({
  routes: [
    {
      path: '/',
      name: 'index',
      component: e=>require(['@/components/index'],e),// 按需加载路由对应页面
      meta:{
        deep:0
      }
    }, {
      path: '/myGoodsList',
      name: 'myGoodsList',
      component: e=>require(['@/components/myGoodsList'],e),
      meta:{
        deep:1
      }
    },{
      path: '/mine',
      name: 'mine',
      component: e=>require(['@/components/mine'],e),
      meta:{
        deep:1
      }
    },{
      path: '/order',
      name: 'order',
      component: e=>require(['@/components/order'],e),
      meta:{
        deep:2
      }
    },
    {
      path: '/author',
      name: 'author',
      component: e=>require(['@/components/author'],e),
      meta:{
        deep:100
      }
    },{
      path: '/buyDetail',
      name: 'buyDetail',
      component: e=>require(['@/components/buy/index'],e),
      meta:{
        skip_login:true,
        deep:10
      }
    }, {
      path: '/buy',
      name: 'buy',
      component: e=>require(['@/components/buy/buy'],e),
      meta:{
        deep:11
      }
    }, {
      path: '/success',
      name: 'success',
      component: e=>require(['@/components/buy/success'],e),
      meta:{
        deep:12
      }
    }, {
      path: '/map',
      name: 'map',
      component: e=>require(['@/components/map'],e),
      meta:{
        deep:3
      }
    }, {
      path: '/lesson',
      name: 'lesson',
      component: e=>require(['@/components/lesson'],e),
      meta:{
        deep:4
      }
    }
  ]
});


router.beforeEach((to,from,next)=> {

  if(to.meta.deep < from.meta.deep){
    store.commit('transitionBack')
  }else{
    store.commit('transitionGo')
  }
  let goOn=function(){
    if(localStorage.getItem('retUrl') && localStorage.getItem('retUrl') !== null && localStorage.getItem('retUrl') !== ''){
      let retUrl = localStorage.getItem('retUrl').toString();
      localStorage.removeItem('retUrl');
      next(retUrl);
    }else{
      next()
    }
  };
  if(to.name === 'author'){
    next()
  }else if(window.location.href.indexOf('token')>-1){
    let token = common.getUrlParam().token;
    store.dispatch('setToken',token);
    goOn()
    // 通过cookie获取token
  }else if(localStorage.getItem('cc_token')) {
    store.dispatch('setToken', localStorage.getItem('cc_token'));
    goOn()
    // 无需token登录页面
  }else if(to.meta.skip_login){
    goOn()
  }else{
    next({name:'author',query:{retUrl:to.fullPath}})
  }

  // if(to.meta.skip_login){
  //   next();
  // }
});

export default router;
