import Vue from 'vue'
import store from "@/store"
import common from '../util/common'
import Router from 'vue-router'
import sa from'sa-sdk-javascript';
Vue.use(Router);

const router =new Router({
  routes: [
    {
      path: '/',
      name: 'index',
      component: e=>require(['@/components/index'],e),//
      meta:{
        deep:0
      }
    }, {
      path: '/newLesson',
      name: 'newLesson',
      component: e=>require(['@/components/newLesson'],e),//
      meta:{
        deep:0
      }
    }, {
      path: '/myGoodsList',
      name: 'myGoodsList',
      component: e=>require(['@/components/myGoodsList'],e),
      meta:{
        deep:1
      }
    },{
      path: '/mine',
      name: 'mine',
      component: e=>require(['@/components/mine'],e),
      meta:{
        deep:1
      }
    },{
      path: '/order',
      name: 'order',
      component: e=>require(['@/components/order'],e),
      meta:{
        deep:2
      }
    },{
      path: '/share',
      name: 'share',
      component: e=>require(['@/components/share'],e),
      meta:{
        deep:2
      }
    },
    {
      path: '/author',
      name: 'author',
      component: e=>require(['@/components/author'],e),
      meta:{
        deep:100,
        noNew:true
      }
    },{
      path: '/buyDetail',
      name: 'buyDetail',
      component: e=>require(['@/components/buy/index'],e),
      meta:{
        skip_login:true,
        noNew:true,
        deep:10
      }
    }, {
      path: '/buy',
      name: 'buy',
      component: e=>require(['@/components/buy/buy'],e),
      meta:{
        noNew:true,
        deep:11
      }
    }, {
      path: '/success',
      name: 'success',
      component: e=>require(['@/components/buy/success'],e),
      meta:{
        noNew:true,
        deep:12
      }
    },{
      path: '/buySuccess',
      name: 'buySuccess',
      component: e=>require(['@/components/buy/buySuccess'],e),
      meta:{
        noNew:true,
        deep:12
      }
    }, {
      path: '/map',
      name: 'map',
      component: e=>require(['@/components/map/index'],e),
      meta:{
        deep:3
      }
    },
    {
      path: '/saleSuccess',
      name: 'saleSuccess',
      component: e=>require(['@/components/buy/saleSuccess'],e),
      meta:{
        deep:4
      }
    }, {
      path: '/bindMobile',
      name: 'bindMobile',
      component: e=>require(['@/components/bindMobile'],e),
      meta:{
        deep:0
      }
    },
    {
      path: '/activity',
      name: 'activity',
      component: e=>require(['@/components/buy/activity'],e),
      meta:{
        skip_login:true
      }
    },
    {
      path: '/activityInvite',
      name: 'activityInvite',
      component: e=>require(['@/components/buy/activityInvite'],e),
      meta:{
        skip_login:true
      }
    },
    {
      path: '/inviteList',
      name: 'inviteList',
      component: e=>require(['@/components/buy/inviteList'],e),
      meta:{
        skip_login:true
      }
    },
    {
      path: '/collection',
      name: 'collection',
      component: e=>require(['@/components/collection'],e),
      meta:{
        skip_login:true
      }
    },
    {
      path: '/noWechat',
      name: 'noWechat',
      component: e=>require(['@/components/noWechat'],e),
      meta:{
        skip_login:false
      }
    },
    {
      path:'*',
      component: e=>require(['@/components/error'],e),
    },
  ]
});

router.beforeEach((to,from,next)=> {
  // Vue.nextTick(() => {
  //   sa.quick("autoTrackSinglePage");
  // });
  let ua = window.navigator.userAgent.toLowerCase();
  if(ua.match(/MicroMessenger/i) == 'micromessenger' || ua.match(/_SQ_/i) == '_sq_'){
    if(to.name == 'noWechat'){
      next({name:'index'});
      return false
    }
  }else{
    if(to.name !== 'noWechat') {
      next({name:'noWechat'});
      return false
    }
  }
  let browser = {
    versions: function () {
      let u = navigator.userAgent, app = navigator.appVersion;

      return {         //移动终端浏览器版本信息
        trident: u.indexOf('Trident') > -1, //IE内核
        presto: u.indexOf('Presto') > -1, //opera内核
        webKit: u.indexOf('AppleWebKit') > -1, //苹果、谷歌内核
        gecko: u.indexOf('Gecko') > -1 && u.indexOf('KHTML') === -1, //火狐内核
        mobile: !!u.match(/AppleWebKit.*Mobile.*/), //是否为移动终端
        ios: !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/), //ios终端
        android: u.indexOf('Android') > -1 || u.indexOf('Linux') > -1, //android终端或uc浏览器
        iPhone: u.indexOf('iPhone') > -1, //是否为iPhone或者QQHD浏览器
        iPad: u.indexOf('iPad') > -1, //是否iPad
        webApp: u.indexOf('Safari') == -1 //是否web应该程序，没有头部与底部
      };
    }(),

    language: (navigator.browserLanguage || navigator.language).toLowerCase()
  };
  if (browser.versions.mobile) {//判断是否是移动设备打开。browser代码在下面
    let ua = navigator.userAgent.toLowerCase();//获取判断用的对象
    if (ua.match(/MicroMessenger/i) == "micromessenger") {

    }else{
    }
  }
  store.dispatch('isMobile',browser.versions.mobile);
  window._hmt.push(['_trackPageview', '/#' + to.fullPath]);
  document.title = '唱唱启蒙英语';
  let goOn=function(){
    if(localStorage.getItem('retUrl') && localStorage.getItem('retUrl') !== null && localStorage.getItem('retUrl') !== ''){
      let retUrl = localStorage.getItem('retUrl').toString();
      localStorage.removeItem('retUrl');
      next(retUrl);
    }else{
      next()
    }
  };
  if(to.name === 'author' || to.name === 'bindMobile'){
    next()
  }else if(window.location.href.indexOf('token')>-1){
    let token = common.getUrlParam().token || to.query.token;
    store.dispatch('setToken',token);
    goOn()
    // 通过cookie获取token
  }else if(localStorage.getItem('cc_token')) {
    store.dispatch('setToken', localStorage.getItem('cc_token'));
    goOn()
    // 无需token登录页面
  }else if(to.meta.skip_login){
    goOn()
  }else{
    let query = {retUrl:to.fullPath};
    if(to.meta.noNew){
      query.is_new_user_url = 1
    }
    next({name:'author',query:query})
  }

  // if(to.meta.skip_login){

  //   next();
  // }
});

export default router;
