import Vue from 'vue'
import store from "@/store"
import common from '../util/common'
import Router from 'vue-router'
import sa from'sa-sdk-javascript';
import {getUserDetailApi} from "../service/api";

Vue.use(Router);

let browser = {
  versions: function () {
    let u = navigator.userAgent, app = navigator.appVersion;

    return {         //移动终端浏览器版本信息
      trident: u.indexOf('Trident') > -1, //IE内核
      presto: u.indexOf('Presto') > -1, //opera内核
      webKit: u.indexOf('AppleWebKit') > -1, //苹果、谷歌内核
      gecko: u.indexOf('Gecko') > -1 && u.indexOf('KHTML') === -1, //火狐内核
      mobile: !!u.match(/AppleWebKit.*Mobile.*/), //是否为移动终端
      ios: !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/), //ios终端
      android: u.indexOf('Android') > -1 || u.indexOf('Linux') > -1, //android终端或uc浏览器
      iPhone: u.indexOf('iPhone') > -1, //是否为iPhone或者QQHD浏览器
      iPad: u.indexOf('iPad') > -1, //是否iPad
      webApp: u.indexOf('Safari') == -1 //是否web应该程序，没有头部与底部
    };
  }(),

  language: (navigator.browserLanguage || navigator.language).toLowerCase()
};
let ua = window.navigator.userAgent.toLowerCase();
const router =new Router({
  routes: [
    {
      path: '/',
      name: 'index',
      component: e=>require(['@/components/index'],e),//
      meta:{
        deep:0,
        title:'唱唱启蒙'
      }
    },
    {
      path: '/addressEdit',
      name: 'addressEdit',
      component: e=>require(['@/components/mine/addressEdit'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/subAccept',
      name: 'subAccept',
      component: e=>require(['@/components/subAccount/accept'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/subAccount',
      name: 'subAccount',
      component: e=>require(['@/components/subAccount/index'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/address',
      name: 'address',
      component: e=>require(['@/components/mine/address'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/liuyi',
      name: 'liuyi',
      component: e=>require(['@/components/activity/liuyi'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/starRank',
      name: 'starRank',
      component: e=>require(['@/components/star/starRank'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/zhibo',
      name: 'zhibo',
      component: e=>require(['@/components/indexPage/zb'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/med',
      name: 'med',
      component: e=>require(['@/components/indexPage/med'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/preview',
      name: 'preview',
      component: e=>require(['@/components/indexPage/preview'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/bbda',
      name: 'bbda',
      component: e=>require(['@/components/indexPage/bbda'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
     {
      path: '/exChange',
      name: 'exChange',
      component: e=>require(['@/components/exChange'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    }, {
      path: '/newLesson',
      name: 'newLesson',
      component: e=>require(['@/components/newLesson'],e),//
      meta:{
        deep:0
      }
    }, {
      path: '/star',
      name: 'star',
      component: e=>require(['@/components/star'],e),//
      meta:{
        deep:0,
        noNew:true,
      }
    },
    {
      path: '/shareGoods',
      name: 'shareGoods',
      component: e=>require(['@/components/newLesson/shareGoods'],e),//
      meta:{
        deep:0,
        noNew:true
      }
    },{
      path: '/myGoodsList',
      name: 'myGoodsList',
      component: e=>require(['@/components/myGoodsList'],e),
      meta:{
        deep:1
      }
    },{
      path: '/mine',
      name: 'mine',
      component: e=>require(['@/components/mine/index'],e),
      meta:{
        deep:1
      }
    },{
      path: '/order',
      name: 'order',
      component: e=>require(['@/components/order'],e),
      meta:{
        deep:2
      }
    },{
      path: '/share',
      name: 'share',
      component: e=>require(['@/components/share'],e),
      meta:{
        deep:2
      }
    },
    {
      path: '/author',
      name: 'author',
      component: e=>require(['@/components/author'],e),
      meta:{
        deep:100,
        noNew:true
      }
    },{
      path: '/buyDetail',
      name: 'buyDetail',
      component: e=>require(['@/components/buy/index'],e),
      meta:{
        skip_login:false,
        noNew:true,
        deep:10
      }
    }, {
      path: '/buy',
      name: 'buy',
      component: e=>require(['@/components/buy/buy'],e),
      meta:{
        noNew:true,
        deep:11
      }
    }, {
      path: '/success',
      name: 'success',
      component: e=>require(['@/components/buy/success'],e),
      meta:{
        noNew:true,
        deep:12
      }
    },{
      path: '/buySuccess',
      name: 'buySuccess',
      component: e=>require(['@/components/buy/buySuccess'],e),
      meta:{
        noNew:true,
        deep:12
      }
    }, {
      path: '/map',
      name: 'map',
      component: e=>require(['@/components/map/index'],e),
      meta:{
        deep:3
      }
    },
    {
      path: '/saleSuccess',
      name: 'saleSuccess',
      component: e=>require(['@/components/buy/saleSuccess'],e),
      meta:{
        deep:4
      }
    }, {
      path: '/bindMobile',
      name: 'bindMobile',
      component: e=>require(['@/components/bindMobile'],e),
      meta:{
        deep:0
      }
    },
    {
      path: '/activity',
      name: 'activity',
      component: e=>require(['@/components/buy/activity'],e),
      meta:{
        skip_login:true,
        noNew:true,
      }
    },
    {
      path: '/activityInvite',
      name: 'activityInvite',
      component: e=>require(['@/components/buy/activityInvite'],e),
      meta:{
        skip_login:true,
        noNew:true,
      }
    },
    {
      path: '/inviteList',
      name: 'inviteList',
      component: e=>require(['@/components/buy/inviteList'],e),
      meta:{
        skip_login:true,
        noNew:true,
      }
    },
    {
      path: '/collection',
      name: 'collection',
      component: e=>require(['@/components/collection'],e),
      meta:{
        skip_login:true
      }
    },
    {
      path: '/noWechat',
      name: 'noWechat',
      component: e=>require(['@/components/noWechat'],e),
      meta:{
        skip_login:false
      }
    },
    {
      path: '/mpShop',
      name: 'mpShop',
      component: e=>require(['@/components/buy/mpShop'],e),
      meta:{
        skip_login:false,
        noNew:true,
      }
    },
    {
      path: '/shareConfig',
      name: 'shareConfig',
      component: e=>require(['@/components/shareConfig'],e),
      meta:{
        noNew:true,
      }
    },
    {
      path: '/inspectorActivit',
      name: 'inspectorActivit',
      component: e=>require(['@/components/inspector/inspectorActivit'],e),
      meta:{
        noNew:true,
      }
    },
    {
      path: '/inspectorList',
      name: 'inspectorList',
      component: e=>require(['@/components/inspector/inspectorList'],e),
      meta:{
        noNew:true,
      }
    },
    {
      path: '/secMap',
      name: 'secMap',
      component: e=>require(['@/components/map/secMap'],e),
      meta:{
        noNew:true,
      }
    },
    {
      path: '/hasaccount',
      name: 'hasaccount',
      component: e=>require(['@/components/map/hasaccount'],e),
      meta:{
        noNew:true,
      }
    },
    {
      path:'*',
      component: e=>require(['@/components/error'],e),
    },
  ]
});

router.beforeEach((to,from,next)=> {
  // 神策路由埋点
  Vue.nextTick(() => {
    sa.quick("autoTrackSinglePage");
  });
  // 判断是否是微信环境 排除本地
  if(ua.match(/MicroMessenger/i) == 'micromessenger' || ua.match(/_SQ_/i) == '_sq_'){
    if(to.name == 'noWechat'){
      // 在微信里打开非微信提示页
      if(to.query.url){
        next(decodeURIComponent(to.query.url))
      }else{
        next({name:'index'});
      }
    }
  }else{
    if(to.name !== 'noWechat' && process.env.NODE_ENV === 'production') {
      next({name:'noWechat',query:{url:encodeURIComponent(to.fullPath)}});
    }
  }
  // 移动端判断
  store.dispatch('isMobile',browser.versions.mobile);
  // 默认title
  if(process.env.NODE_ENV === 'production'){
    document.title = '唱唱启蒙英语';
  }else{
    document.title = '唱唱测试';
  }
  if(to.name === 'secMap' ){
    // (function(d, w, c) {
    //   var s = d.createElement('script');
    //   w[c] = w[c] || function() {
    //       (w[c].z = w[c].z || []).push(arguments);
    //   };
    //   s.async = true;
    //   s.src = 'https://pubres.aihecong.com/hecong.js';
    //   if (d.head) d.head.appendChild(s);
    // })(document, window, '_AIHECONG');
    // _AIHECONG('ini',{ entId : 11875,button:true });
    // debugger
  }
 
  let goOn=function(){
    if(localStorage.getItem('retUrl') && localStorage.getItem('retUrl') !== null && localStorage.getItem('retUrl') !== ''){
      console.log(localStorage.getItem('retUrl'))
      let retUrl = localStorage.getItem('retUrl').toString();
      localStorage.removeItem('retUrl');
      next(retUrl);
    }else{
      next()
    }
  };
  if(to.name === 'author' || to.name === 'bindMobile' || to.name === 'noWechat' || to.name === 'inspectorActivit'){
    // 无需登录的页面
    next()
  }else if(window.location.href.indexOf('token')>-1 && to.name === 'index'){
    let token = common.getUrlParam().token || to.query.token;
    console.log(common.getUrlParam())
    console.log(to.name)
    // debugger
    store.dispatch('setToken',token);
    getUserDetailApi().then(res=>{
      // debugger
      localStorage.setItem('userDesc',JSON.stringify(res));
      sa.login(res.user_id);
      goOn()
    }).catch((res)=>{
      console.log(res)
      // debugger
      if(localStorage.getItem('userDesc')){
        goOn()
      }
    });
  }else if(localStorage.getItem('cc_token')) {
    // 已登陆
    store.dispatch('setToken', localStorage.getItem('cc_token'));
    if(localStorage.getItem('userDesc')){
      sa.login(JSON.parse(localStorage.getItem('userDesc')).user_id);
      goOn()
    }else{
      getUserDetailApi().then(res=>{
        localStorage.setItem('userDesc',JSON.stringify(res));
        sa.login(res.user_id);
        goOn()
      }).catch(()=>{
        if(localStorage.getItem('userDesc')){
          goOn()
        }
      });
    }
    // debugger
  }else{
    // 未登陆，保存下路径
    let query = {retUrl:to.fullPath};
    localStorage.setItem('retUrl',to.fullPath);
    if(window.location.href.indexOf('gdt_vid')>-1){
      localStorage.setItem('gdt_vid',common.getUrlParam().gdt_vid);
      console.log(query.gdt_vid)
    }
    console.log(process.env.AUTHOR_UEL)
    console.log(window.location.href)
    if(to.meta.noNew){
      query.is_new_user_url = 1;
      window.location.href = `${process.env.AUTHOR_UEL}`
    }else{
      // debugger
      window.location.href = `${process.env.AUTHOR_UEL}&is_new_user_url=1`
    }
    // debugger
  }

  // if(to.meta.skip_login){

  //   next();
  // }
});

export default router;
