import Vue from 'vue';
import {post,fetch,patch,put,del,upload,ret2} from './index'
const _baseUrl=process.env.API_URL;
Vue.prototype.$post=post;
Vue.prototype.$fetch=fetch;
Vue.prototype.$patch=patch;
Vue.prototype.$put=put;
Vue.prototype.$del=del;
Vue.prototype.$upload = upload;
Vue.prototype.$ret2 = ret2;

// 获取banner列表
const getBannerListUrl = `${_baseUrl}api/client/banner/list`;
export const getBannerListApi = function () {
  return Vue.prototype.$fetch(getBannerListUrl)
};
const bannerListUrl =`/api/client/banner/list/`;
export const bannerListApi = function (type,json) {
  return Vue.prototype.$fetch(bannerListUrl+type,json)
};
// 获取微信授权
const getwechatParamUrl = `${_baseUrl}api/client/jssdk`;
export const getwechatParam = function (json) {
  return Vue.prototype.$fetch(getwechatParamUrl,json)
};

// 文件上传
const uploadFileUrl = `${_baseUrl}api/public/upload/zone`;
export const uploadFileApi = function (json) {
  return Vue.prototype.$upload(uploadFileUrl,json)
};

// 获取商品详情
const getGoodsDetailUrl = `${_baseUrl}api/client/goods/info/`;
export const getGoodsDetailApi = function (id) {
  return Vue.prototype.$fetch(`${getGoodsDetailUrl}${id}`)
};
// 获取用户地址
const getUserAdressUrl = `${_baseUrl}api/client/address/info`;
export const getUserAdressApi = function () {
  return Vue.prototype.$fetch(getUserAdressUrl)
};
// 微信支付
const payUrl = `${_baseUrl}api/client/bill/wechat/pay`
export const payApi = function (json) {
  return Vue.prototype.$fetch(payUrl,json)
};
// 保存用户地址
const saveAddressUrl = `${_baseUrl}api/client/address/save`
export const saveAddressApi = function (json) {
  return Vue.prototype.$post(saveAddressUrl,json)
};
// 用户已购课程
const getUserLessonUrl = `${_baseUrl}api/client/user/course/list`
export const getUserLessonApi = function () {
  return Vue.prototype.$fetch(getUserLessonUrl)
};
// 课包列表
const getLessonListUrl = `${_baseUrl}api/client/course/category/list/`
export const getLessonListApi = function (id,json) {
  return Vue.prototype.$fetch(`${getLessonListUrl}${id}`,json)
};
// 获取主题列表
const getCourseListUrl = `${_baseUrl}api/client/course/relation/list/`
export const getCourseListApi = function (id) {
  return Vue.prototype.$fetch(`${getCourseListUrl}${id}`)
};
//获取课包详情
const getLessonDetailUrl = `${_baseUrl}api/client/element/info/`
export const getLessonDetailApi = function (periods_id,category_id,element_id) {
  return Vue.prototype.$fetch(`${getLessonDetailUrl}${periods_id}/${category_id}/${element_id}`)
};
// 获取客户详情
const getUserDetailUrl = `${_baseUrl}api/client/me`;
export const getUserDetailApi = function () {
  return Vue.prototype.$fetch(getUserDetailUrl)
};
// 提交看课数据
const subUserLessonUrl = `${_baseUrl}api/client/user/watch/log/`;
export const subUserLessonApi = function (element_id,category_id,periods_id,json) {
  return Vue.prototype.$post(`${subUserLessonUrl}${element_id}/${category_id}/${periods_id}`,json)
};
// 获取团购详情
const getGroupDetailUrl = `${_baseUrl}api/client/group/info/`;
export const getGroupDetailApi = function (group_id) {
  return Vue.prototype.$fetch(`${getGroupDetailUrl}${group_id}`)
};
// 获取订单详情
const getOrderDetailUrl = `${_baseUrl}api/client/order/info/`;
export const getOrderDetailApi = function (id) {
  return Vue.prototype.$fetch(`${getOrderDetailUrl}${id}`)
};
// 获取用户订单列表
const getOrderListUrl = `${_baseUrl}api/client/order/list`;
export const getOrderListApi = function (json) {
  return Vue.prototype.$fetch(getOrderListUrl,json)
};
// 用户看课统计
const getUserWatchUrl = `${_baseUrl}api/client/user/watch/report`;
export const getUserWatchApi = function () {
  return Vue.prototype.$fetch(getUserWatchUrl)
};
// 获取老师
const getTeacherDetailUrl = `${_baseUrl}api/client/me/teacher`;
export const getTeacherApi = function () {
  return Vue.prototype.$fetch(getTeacherDetailUrl)
};
// 获取新用户自动跳转
const getNewUrl = `${_baseUrl}api/client/new/user/direct`;
export const getNewApi = function () {
  return Vue.prototype.$fetch(getNewUrl)
};
// 查看是否可购买该商品
const getStatusWechatUrl = `${_baseUrl}api/client/bill/wechat/status`;
export const getStatusWechatApi = function (json) {
  return Vue.prototype.$fetch(getStatusWechatUrl,json)
};

// 用户可用优惠券
const getCouponListUrl = `${_baseUrl}api/client/user/coupon/list`;
export const getCouponListApi = function (id) {
  return Vue.prototype.$fetch(getCouponListUrl,{goods_id:id})
};
// 获取商品列表
const getGoodsListUrl = `${_baseUrl}api/client/goods/list`;
export const getGoodsListApi = function (json) {
  return Vue.prototype.$fetch(getGoodsListUrl,json)
};
//获取邀请战绩收益
const getInviteResultUrl = `${_baseUrl}api/client/user/invite/earnings`;
export const getInviteResultApi = function (json,id) {
  return Vue.prototype.$fetch(`${getInviteResultUrl}/${id}`,json)
};
//获取邀请战绩用户列表
const getInviteListUrl = `${_baseUrl}api/client/user/invite/list`;
export const getInviteListApi = function (json,id) {
  return Vue.prototype.$fetch(`${getInviteListUrl}/${id}`,json)
};
// 发送验证码
const sendMobileCodeUrl = `${_baseUrl}api/client/mobile/code`;
export const sendMobileCodeApi = function (json) {
  return Vue.prototype.$post(sendMobileCodeUrl,json)
};
// 绑定手机号
const bindMobileUrl = `${_baseUrl}api/client/user/mobile/bind`;
export const bindMobileApi = function (json) {
  return Vue.prototype.$put(bindMobileUrl,json)
};
// 获取引导参数
const getGuideUrl =`${_baseUrl}api/client/user/bootPage`;
export const getGuideApi = function (json) {
  return Vue.prototype.$fetch(getGuideUrl,json)
};
// 设置引导参数
const setGuideUrl =`${_baseUrl}api/client/user/bootPage`;
export const setGuideApi = function (json) {
  return Vue.prototype.$post(setGuideUrl,json)
};
// 查找跳转
const getRedirectUrl =`${_baseUrl}api/client/redirect`;
export const getRedirectApi = function (json) {
  return Vue.prototype.$fetch(getRedirectUrl,json)
};

// 获取用户收藏
const getUserCollectUrl =`${_baseUrl}api/client/user/collect`;
export const getUserCollectApi = function (json) {
  return Vue.prototype.$fetch(getUserCollectUrl,json)
};

// 用户添加收藏
const addUserCollectUrl =`${_baseUrl}api/client/user/collect`;
export const addUserCollectApi = function (json) {
  return Vue.prototype.$post(addUserCollectUrl,json)
};

// 用户取消收藏
const delUserCollectUrl =`${_baseUrl}api/client/user/collect/`;
export const delUserCollectApi = function (id) {
  return Vue.prototype.$put(delUserCollectUrl+id)
};

// 获取他人看课统计
const getOtherUserWatchUrl = `/api/client/user/watch/report/`;
export const getOtherUserWatchApi = function (id) {
  return Vue.prototype.$fetch(getOtherUserWatchUrl+id)
};

// 获取分享商品
const getShareGoodsUrl = '/api/client/share/goods';
export const getShareGoodsApi = function () {
  return Vue.prototype.$fetch(getShareGoodsUrl)
};

// 获取短网址
const getShortUrl = `/api/public/short/url`;
export const getShortApi = function (json) {
  return Vue.prototype.$fetch(getShortUrl,json)
};

// 获取用户总积分
const getUserIntegralUrl = '/api/client/user/last/integral';
export const getUserIntegralApi = function () {
  return Vue.prototype.$fetch(getUserIntegralUrl)
};

// 获取用户总积分
const getUserIntegralListUrl = '/api/client/user/integral';
export const getUserIntegralListApi = function (json) {
  return Vue.prototype.$fetch(getUserIntegralListUrl,json)
};

// 兑换码兑换
const ExChangeUrl = `/api/client/user/mobile/bind/exchange`;
export const ExChangeApi = function (json) {
  return Vue.prototype.$put(ExChangeUrl,json)
};

// 获取可选择的期数
const getYujiListUrl = `/api/client/yunji/config`;
export const getYujiListUrlApi = function (json) {
  return Vue.prototype.$fetch(getYujiListUrl,json)
};
// 提交选择的期数
const postYujiListUrl =`/api/client/user/add/class/`;
export const postYujiListApi = function (id) {
  return Vue.prototype.$post(postYujiListUrl+id)
};
// 判断用户是否需要选择期数
const getCourseStatusUrl =`/api/client/user/course/status`;
export const getCourseStatusApi = function () {
  return Vue.prototype.$fetch(getCourseStatusUrl)
};
// 首页获取用户课程信息
const getCourseInfoUrl =`/api/client/user/course/info/`;
export const getCourseInfoApi = function () {
  return Vue.prototype.$fetch(getCourseInfoUrl)
};
// 宝宝昵称设置
const putBabyInfoUrl =`/api/client/me/set`;
export const putBabyInfoApi = function (json) {
  return Vue.prototype.$put(putBabyInfoUrl,json)
};
// 获取自动化商品数据
export const getAutomationApi = function (type,id) {
  return Vue.prototype.$fetch(`/api/client/course/automation/list/${type}/${id}`)
};
// 自动化看课推荐转化商品及其优惠券
export const getAutomationCouponApi = function () {
  return Vue.prototype.$fetch(`/api/client/recommend/conversion/goods`)
};
//用户总积分
export const getStarSumberApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/last/integral`)
};
//用户抽奖
export const getLuckDrawApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/luckDraw`)
};
//用户抽奖次数
export const getLuckDrawStatusApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/luckDraw/judge`)
};
//随机用户，抽奖人数
export const getLuckDrawRamdomsApi = function () {
  return Vue.prototype.$fetch(`/api/client/user/luckDraw/rand`)
};
// /api/client/user/luckDraw/rand
