import Vue from 'vue';
import {post,fetch,patch,put,del,upload,ret2} from './index'
const _baseUrl=process.env.API_URL;
Vue.prototype.$post=post;
Vue.prototype.$fetch=fetch;
Vue.prototype.$patch=patch;
Vue.prototype.$put=put;
Vue.prototype.$del=del;
Vue.prototype.$upload = upload;
Vue.prototype.$ret2 = ret2;

// 获取banner列表
const getBannerListUrl = `${_baseUrl}api/client/banner/list`;
export const getBannerListApi = function () {
  return Vue.prototype.$fetch(getBannerListUrl)
};
// 获取微信授权
const getwechatParamUrl = `${_baseUrl}api/client/jssdk`;
export const getwechatParam = function (json) {
  return Vue.prototype.$fetch(getwechatParamUrl,json)
};

// 文件上传
const uploadFileUrl = `${_baseUrl}api/public/upload/zone`;
export const uploadFileApi = function (json) {
  return Vue.prototype.$upload(uploadFileUrl,json)
};

// 获取商品详情
const getGoodsDetailUrl = `${_baseUrl}api/client/goods/info/`;
export const getGoodsDetailApi = function (id) {
  return Vue.prototype.$fetch(`${getGoodsDetailUrl}${id}`)
};
// 获取用户地址
const getUserAdressUrl = `${_baseUrl}api/client/address/info`;
export const getUserAdressApi = function () {
  return Vue.prototype.$fetch(getUserAdressUrl)
};
// 微信支付
const payUrl = `${_baseUrl}api/client/bill/wechat/pay`
export const payApi = function (json) {
  return Vue.prototype.$fetch(payUrl,json)
};
// 保存用户地址
const saveAddressUrl = `${_baseUrl}api/client/address/save`
export const saveAddressApi = function (json) {
  return Vue.prototype.$post(saveAddressUrl,json)
};
// 用户已购课程
const getUserLessonUrl = `${_baseUrl}api/client/user/course/list`
export const getUserLessonApi = function () {
  return Vue.prototype.$fetch(getUserLessonUrl)
};
// 课包列表
const getLessonListUrl = `${_baseUrl}api/client/course/category/list/`
export const getLessonListApi = function (id,json) {
  return Vue.prototype.$fetch(`${getLessonListUrl}${id}`,json)
};
// 获取主题列表
const getCourseListUrl = `${_baseUrl}api/client/course/relation/list/`
export const getCourseListApi = function (id) {
  return Vue.prototype.$fetch(`${getCourseListUrl}${id}`)
};
//获取课包详情
const getLessonDetailUrl = `${_baseUrl}api/client/element/info/`
export const getLessonDetailApi = function (periods_id,category_id,element_id) {
  return Vue.prototype.$fetch(`${getLessonDetailUrl}${periods_id}/${category_id}/${element_id}`)
};
// 获取客户详情
const getUserDetailUrl = `${_baseUrl}api/client/me`;
export const getUserDetailApi = function () {
  return Vue.prototype.$fetch(getUserDetailUrl)
};
// 提交看课数据
const subUserLessonUrl = `${_baseUrl}api/client/user/watch/log/`;
export const subUserLessonApi = function (element_id,category_id,periods_id,json) {
  return Vue.prototype.$post(`${subUserLessonUrl}${element_id}/${category_id}/${periods_id}`,json)
};
// 获取团购详情
const getGroupDetailUrl = `${_baseUrl}api/client/group/info/`;
export const getGroupDetailApi = function (group_id) {
  return Vue.prototype.$fetch(`${getGroupDetailUrl}${group_id}`)
};
// 获取订单详情
const getOrderDetailUrl = `${_baseUrl}api/client/order/info/`;
export const getOrderDetailApi = function (id) {
  return Vue.prototype.$fetch(`${getOrderDetailUrl}${id}`)
};
// 获取用户订单列表
const getOrderListUrl = `${_baseUrl}api/client/order/list`;
export const getOrderListApi = function (json) {
  return Vue.prototype.$fetch(getOrderListUrl,json)
};
// 用户看课统计
const getUserWatchUrl = `${_baseUrl}api/client/user/watch/report`;
export const getUserWatchApi = function () {
  return Vue.prototype.$fetch(getUserWatchUrl)
};
// 获取老师
const getTeacherDetailUrl = `${_baseUrl}api/client/me/teacher`;
export const getTeacherApi = function () {
  return Vue.prototype.$fetch(getTeacherDetailUrl)
};
// 获取新用户自动跳转
const getNewUrl = `${_baseUrl}api/client/new/user/direct`;
export const getNewApi = function () {
  return Vue.prototype.$fetch(getNewUrl)
};
// 查看是否可购买该商品
const getStatusWechatUrl = `${_baseUrl}api/client/bill/wechat/status`;
export const getStatusWechatApi = function (json) {
  return Vue.prototype.$fetch(getStatusWechatUrl,json)
};

export const fetchApi = function (url) {
  return Vue.prototype.$ret2(url)
}
