import Vue from 'vue';
import {post,fetch,patch,put,del,upload} from './index'
const _baseUrl=process.env.API_URL;
Vue.prototype.$post=post;
Vue.prototype.$fetch=fetch;
Vue.prototype.$patch=patch;
Vue.prototype.$put=put;
Vue.prototype.$del=del;
Vue.prototype.$upload = upload;
// 获取banner列表
const getBannerListUrl = `${_baseUrl}api/client/banner/list`;
export const getBannerListApi = function () {
  return Vue.prototype.$fetch(getBannerListUrl)
};
// 获取微信授权
const getwechatParamUrl = `${_baseUrl}api/client/jssdk`;
export const getwechatParam = function (json) {
  return Vue.prototype.$fetch(getwechatParamUrl,json)
};
// 获取商品详情
const getGoodsDetailUrl = `${_baseUrl}api/client/goods/info/`;
export const getGoodsDetailApi = function (id) {
  return Vue.prototype.$fetch(`${getGoodsDetailUrl}${id}`)
};
// 获取用户地址
const getUserAdressUrl = `${_baseUrl}api/client/address/info`;
export const getUserAdressApi = function () {
  return Vue.prototype.$fetch(getUserAdressUrl)
};
// 微信支付
const payUrl = `${_baseUrl}api/client/bill/wechat/pay`
export const payApi = function (json) {
  return Vue.prototype.$fetch(payUrl,json)
};
// 保存用户地址
const saveAddressUrl = `${_baseUrl}api/client/address/save`
export const saveAddressApi = function (json) {
  return Vue.prototype.$post(saveAddressUrl,json)
}
