'use strict';
const merge = require('webpack-merge');
const prodEnv = require('./prod.env');
const ip = `http://${getIP()}:8085/`;

function getIP() {
  var interfaces = require('os').networkInterfaces();
  for (var devName in interfaces) {
    var iface = interfaces[devName];
    for (var i = 0; i < iface.length; i++) {
      var alias = iface[i];
      if (alias.family === 'IPv4' && alias.address !== '127.0.0.1' && !alias.internal) {
        return alias.address;
      }
    }
  }
}

module.exports = merge(prodEnv, {
  NODE_ENV: '"development"',
  API_URL: `"${ip}"`,
  MAX_FILESIZE:'1024*1024*10',
  IMAGE_URL_HEAD:'"http://cdn.singsingenglish.com/"',
  BUY_URL:'"http://wechat-test.changchangenglish.com/#/buyDetail?"',
  AUTHOR_UEL:`"https://wechat-test.changchangenglish.com/api/client/login?redirect_url=${ip}#/"`,
  REDIRECT_URL:`"${ip}"`,
});

