webpackJsonp([8],{4065:function(n,e){n.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAsCAYAAAAXb/p7AAAAAXNSR0IArs4c6QAAA2FJREFUWAnVmU9IFVEUxt9T0xIraBFquIs2LuqZkvAoEAoKRfpjrota6qJ10SL3LVu2qaCyPwSBohSkBUXYP2iRuAqyAqEyXRTa6/eNM8No82buzHszvg58b+7c851zPs/M3LmDmUyFWzauvkKhUEfsIdABdnjAMPPJg5eMx7PZ7C85EjVEVYFj4Ab4AUxNXMUotioRkSTuAm9AqaYcXWUTSbIWcL9UVT7xytlSklAStIPPPsnLNaXc7bFEEtgLFsulJCCPavRGEklAH1gOSFpul2r1+Yn8Z5mB2ArxOWjwC0hwboHcnSxH7701VglE3BacWrd2eUkpjqep1YHIeafm2jXpCo71EidNqi0NrrkdpHu7mX0N3DmXle6gQLkcXXyrst4ODnG+3uKkSRqkxTJLEN3bx5kejEoyPTAvnA6eqSRlthZLk17+6mJ3SgK1hBwEHw3qWZpqIOZAs0FAqZRHJDgBqsFPg2TNNK9NlziN7l2lzhGgqzUOWoGJdUugKdkk4VqOlozz3Oy6n+rBGGgDptaqS9xoyo7I0w76FOJucqk2Mx4F2n1HsUYJbIoSYcidg3cUcc8Qp3f6COg0jPXSmjIkmAemdhnihxCy/DtVhWM9eBLCD3LPK4npnu+dXXQrMQ+KZJ1gfpvN28T4cRGe6fSiBM6YsuGdtYtnGV8Efzyx1xnX2v6NjMc8vrjDGQl8GiFaG8uTEiFj3A2+gUsrM9ZcHecjoBw2qSLDETP9hn/YEeQ9Ml8LHkbMF0Qf1jqoTWIU2wD5Llnz3iDONX8blHPhn1YH80F/QoDvO749EsmxBtwJ4MZ15ZW8GszFzPCVuBy4FTM+KEyaqqtYTJdpghbSOLadoFegP05wSMyItOkelF1bOVTUr6XJ2lFLFu2c4LC/QiRO0r0D0uJ0UOML+qkQc7W4AlGsDmrHsd42amuxdLiXWGdcZu2sp0BSWzCVCbIvOPcicNYhuR3UhO3QE7nkEFI8qma/V1zR2nRyEKRtg0UF+TlQNwCWUlCpGgN+GkLnCOwBCwmKVO6eUCFBBBLoVTaVgEjltN7lQfWNfCTSB/5pMAtKNeVQrlUPqJGQMBJJG8A5oI8h726a00ATVzGK1UeUsa1aB42jIFJIa+ZxoE/JsH/k3DNaPkj039lfRxvtd4wrjZQAAAAASUVORK5CYII="},"6ZIX":function(n,e,t){(n.exports=t("FZ+f")(!0)).push([n.i,"\n.v-modal{\n  opacity: 0.7;\n}\n","",{version:3,sources:["D:/myproject/new-singsingH5/src/components/buy/src/components/buy/success.vue"],names:[],mappings:";AAsaA;EACA,aAAA;CACA",file:"success.vue",sourcesContent:['<template>\r\n  <div class="success">\r\n    <mt-popup\r\n      v-model="shareVisible"\r\n      class="refer-share"\r\n      position="top">\r\n      <img :src="shareUrl">\r\n    </mt-popup>\r\n    <div class="banner">\r\n      <img :src="img.weChat">\r\n    </div>\r\n    <div class="shop-block" v-if="groupDetail">\r\n      <div class="shop">\r\n        <div class="img-block">\r\n          <img :src="groupDetail.goods_desc.img[0].url">\r\n        </div>\r\n        <div>\r\n          <div class="title">\r\n            {{groupDetail.name}}\r\n          </div>\r\n          <div class="content">\r\n            {{groupDetail.goods_desc.desc}}\r\n          </div>\r\n          <div class="price">\r\n            价格 ￥{{money/100}}\r\n          </div>\r\n        </div>\r\n      </div>\r\n    </div>\r\n    <div class="success-block" v-if="groupDetail">\r\n      <div class="text-content last" v-if=" group_info && group_info.status !== 1">\r\n        剩余\r\n        <span>{{h}}</span>:<span>{{m}}</span>:<span>{{s}}</span>\r\n        结束\r\n      </div>\r\n      <div class="suc-head">\r\n        <img v-if="group_info" v-for="(data,index) in user_info" :src="data.avatar" :key="index">\r\n        \x3c!--<div v-if="status !== 1" v-for="data in (groupDetail.group_number - user_info.length)" class="otherIcon"></div>--\x3e\r\n        <img :src="defaultUserIconUrl" v-if="group_info  && group_info.status !== 1 " v-for="data in (groupDetail.desc.group_number - user_info.length)"/>\r\n        <div class="title" v-if="group_info && group_info.status !== 1">\r\n          还差<span class="red">{{(groupDetail.desc.group_number - user_info.length)}}</span>人成团，赶快邀请好友来拼单吧\r\n        </div>\r\n      </div>\r\n      <div class="text-content" v-if="group_info && group_info.status === 1">\r\n        恭喜您已成功拼团\r\n      </div>\r\n    </div>\r\n    <div class="block-white"></div>\r\n    <div class="btn-block">\r\n      <div class="btn" @click="shareVisible = true;buttonClick(\'分享\')" v-if="group_info && group_info.status !== 1">\r\n        继续分享\r\n      </div>\r\n      <div class="btn" @click="toIndex();buttonClick(\'去上课\')" v-if="group_info && group_info.status === 1">\r\n        快去上课\r\n      </div>\r\n    </div>\r\n  </div>\r\n</template>\r\n\r\n<script>\r\n  import {shopSuccess} from "../../util/imgUrl";\r\n  import defaultUserIconUrl from \'../../assets/Shape@2x.png\'\r\n  import successIconUrl from \'../../assets/successIcon.png\'\r\n  import weChatQrUrl from \'../../assets/weChatCode.png\'\r\n  import weChatIcon from \'../../assets/wechat.jpg\'\r\n  import {getwechatParam,getOrderDetailApi,getGoodsDetailApi} from "../../service/api";\r\n  import shareUrl from \'../../assets/Bitmap@2x.png\'\r\n  export default {\r\n    name: "success",\r\n    data(){\r\n      return {\r\n        img:shopSuccess,\r\n        groupDetail:\'\',\r\n        defaultUserIconUrl:defaultUserIconUrl,\r\n        shareUrl:shareUrl,\r\n        weChatIcon:weChatIcon,\r\n        orderNo:\'\',\r\n        shareVisible:true,\r\n        weChatQrUrl:weChatQrUrl,\r\n        successIconUrl:successIconUrl,\r\n        shopId:\'\',\r\n        group_info:null,\r\n        money:0,\r\n        invite_code:\'\',\r\n        groupId:\'\',\r\n        is_captain:1,\r\n        user_info:[],\r\n        deadline:\'\',\r\n        h:0,\r\n        m:0,\r\n        s:0\r\n      }\r\n    },\r\n    computed:{\r\n      other(){\r\n        return  Number(this.groupDetail.desc.group_number - this.this.user_info.length)\r\n      }\r\n    },\r\n    mounted(){\r\n      this.initPage()\r\n    },\r\n    methods:{\r\n      toIndex(){\r\n        this.$router.push({name:\'index\'});\r\n      },\r\n      buttonClick(buttonName){\r\n        this.$sa.track(\'buttonClick\',{\r\n          tabTitle:\'商品\',\r\n          moduleTitle:\'购买成功页\',\r\n          buttonType:\'功能\',\r\n          buttonName:buttonName\r\n        });\r\n      },\r\n      enableShare: function(option) {\r\n        getwechatParam({\r\n          api_list:   \'onMenuShareAppMessage,onMenuShareTimeline\',\r\n          url:window.location.href.split(\'#\')[0]\r\n        }).then(wechatRes => {\r\n          wx.config({\r\n            debug: false,\r\n            appId: wechatRes.appId,\r\n            timestamp: parseInt(wechatRes.timestamp),\r\n            nonceStr: wechatRes.nonceStr,\r\n            signature: wechatRes.signature,\r\n            jsApiList: wechatRes.jsApiList\r\n          });\r\n          let that = this;\r\n          wx.ready(function() {\r\n            wx.onMenuShareTimeline({\r\n              title: option.product_title, // 分享标题\r\n              desc: option.desc,// 分享描述\r\n              link: option.shareUrl, // 分享链接\r\n              imgUrl: option.shareIcon || \'https://cdn.singsingenglish.com/singsing/recommend/logo-refer.png\', // 分享图标\r\n              success: function() {\r\n                let link = `shopId=${that.shopId}&groupId=${that.groupId}&invite_code=${that.invite_code}&type=${that.type}&out_trade_no=${that.orderNo}`;\r\n                this.trackingPage(link,\'share\')\r\n              },\r\n              cancel: function() {\r\n                // alert("失败")\r\n              }\r\n            });\r\n            wx.onMenuShareAppMessage({\r\n              title: option.product_title, // 分享标题\r\n              desc: option.desc,// 分享描述\r\n              link: option.shareUrl, // 分享链接\r\n              imgUrl: option.shareIcon || \'https://cdn.singsingenglish.com/singsing/recommend/logo-refer.png\', // 分享图标\r\n              success: function() {\r\n                let link = `shopId=${this.shopId}&groupId=${this.groupId}&invite_code=${this.invite_code}&type=${this.type}&out_trade_no=${this.orderNo}`\r\n                this.trackingPage(link,\'share\')\r\n              },\r\n              cancel: function() {\r\n              }\r\n            });\r\n          })\r\n        })\r\n      },\r\n      onShare: function() {\r\n\r\n        let URL = `${process.env.BUY_URL}shopId=${this.shopId}&groupId=${this.groupId}&invite_code=${this.invite_code?this.invite_code : \'\'}`;\r\n        this.enableShare({\r\n          product_title: this.groupDetail.share_desc.title,\r\n          desc: this.groupDetail.share_desc.content,\r\n          shareIcon:this.groupDetail.share_desc.img[0].url || \'\',\r\n          shareUrl:URL\r\n        })\r\n      },\r\n      initPage(){\r\n        if(this.$route.query.out_trade_no&&this.$route.query.out_trade_no !== \'\' && this.$route.query.out_trade_no !== null){\r\n          this.orderNo =  this.$route.query.out_trade_no;\r\n        }else{\r\n          this.groupId =  this.$route.query.groupId;\r\n        }\r\n        getOrderDetailApi(this.orderNo).then(res=>{\r\n          this.groupId =  res.order_group_id;\r\n          this.user_info = res.user_info;\r\n          this.group_info = res.group_info;\r\n          if(!res.invite_id || res.invite_id == \'\') {\r\n            this.invite_code = \'CC-USER-\' + res.user_id;\r\n          }else if(res.invite_type === \'TEACHER\'){\r\n            this.invite_code = `CC-USER-${res.user_id}`;\r\n          }else {\r\n            this.invite_code = `CC-${res.invite_type}-${res.user_id}`;\r\n          }\r\n          console.log(this.invite_code)\r\n          if(this.group_info.status === 1){\r\n            this.shareVisible = false\r\n          }\r\n          this.shopId = res.goods_id;\r\n          this.money = res.money;\r\n          if(res.group_info.deadline){\r\n            this.deadline = res.group_info.deadline;\r\n            this.leftTimer();\r\n          }\r\n          getGoodsDetailApi(this.shopId).then(data=>{\r\n            data.desc = JSON.parse(data.desc);\r\n            data.goods_desc = JSON.parse(data.goods_desc);\r\n            data.share_desc = JSON.parse(data.share_desc);\r\n            this.groupDetail = data;\r\n            this.onShare();\r\n          })\r\n        })\r\n      },\r\n\r\n      leftTimer(){\r\n        let leftTime = (new Date(this.deadline.replace(/\\-/g, \'/\'))) - (new Date()); //计算剩余的毫秒数\r\n        let hours = parseInt(leftTime / 1000 / 60 / 60 % 24 , 10); //计算剩余的小时\r\n        let minutes = parseInt(leftTime / 1000 / 60 % 60, 10);//计算剩余的分钟\r\n        let seconds = parseInt(leftTime / 1000 % 60, 10);//计算剩余的秒数\r\n        hours = this.checkTime(hours);\r\n        minutes = this.checkTime(minutes);\r\n        seconds = this.checkTime(seconds);\r\n        this.h = hours > 0 ? hours : \'00\';\r\n        this.m = minutes > 0 ? minutes : \'00\';\r\n        this.s = seconds > 0 ? seconds : \'00\';\r\n        window.setTimeout(this.leftTimer,1000)\r\n      },\r\n      checkTime(i){ //将0-9的数字前面加上0，例1变为01\r\n        if(i<10)\r\n        {\r\n          i = "0" + i;\r\n        }\r\n        return i;\r\n      }\r\n    }\r\n  }\r\n<\/script>\r\n\r\n<style scoped lang="less">\r\n  @import "../../util/public";\r\n  .block-white{\r\n    height: 60 *@toVw;\r\n  }\r\n  .banner {\r\n    padding: 10 * @toVw;\r\n    background: white;\r\n    text-align: center;\r\n    margin-bottom: 10 * @toVw;\r\n    img {\r\n      width: 100%;\r\n      display: block;\r\n    }\r\n  }\r\n  .btn-block{\r\n    position: fixed;\r\n    bottom: 10*@toVw;\r\n    width: 100%;\r\n    text-align: center;\r\n    .btn{\r\n      margin: 0 20 * @toVw;\r\n      background: #FF7171;\r\n      height: 38 * @toVw;\r\n      line-height: 38 * @toVw;\r\n      border-radius: 1000px;\r\n      font-size:16px;\r\n      font-family:PingFangSC-Regular;\r\n      font-weight:400;\r\n      color:rgba(255,255,255,1);\r\n    }\r\n  }\r\n  .success{\r\n    background: #f0f0f0;\r\n    height: 100%;\r\n  }\r\n  .head{\r\n    background: #F83534;\r\n    padding: 10/7.5vw;\r\n    text-align: center;\r\n    color: white;\r\n    font-size: 16px;\r\n    line-height: 1.4em;\r\n    img{\r\n      width: 18px;\r\n      vertical-align: middle;\r\n      margin-right: 5px;\r\n    }\r\n    .sec{\r\n      font-size: 12px;\r\n    }\r\n  }\r\n  .shop-block{\r\n\r\n    background: white;\r\n    .shop{\r\n      padding: 20/7.5vw;\r\n      border-bottom: 1px solid #d8d8d8;\r\n      position: relative;\r\n      &:after{\r\n        content:\'\';\r\n        display: block;\r\n        clear: both;\r\n      }\r\n      .img-block{\r\n        float: left;\r\n        margin-right: 20/7.5vw;\r\n        img{\r\n          width: 250/7.5vw;\r\n        }\r\n        min-height: 120px;\r\n      }\r\n\r\n      .title{\r\n        font-size: 18px;\r\n        overflow: hidden;\r\n        text-overflow:ellipsis;\r\n        white-space: nowrap;\r\n        color: #333333;\r\n        margin-bottom: 5/7.5vw;\r\n      }\r\n      .content{\r\n        font-size: 12px;\r\n        line-height: 1.4em;\r\n        color: #CCCCCC;\r\n        height: 4.2em;\r\n        overflow: hidden;\r\n\r\n      }\r\n      .price{\r\n        font-size: 18px;\r\n        color: #FF001F;\r\n        position: absolute;\r\n        right: 20/7.5vw;\r\n        bottom: 20/7.5vw;\r\n      }\r\n    }\r\n  }\r\n  .success-block{\r\n    padding: 0 20*@toVw;\r\n    margin-bottom: 15*@toVw;\r\n    position: relative;\r\n    background: #f0f0f0;\r\n    .suc-head{\r\n      padding: 20*@toVw 0;\r\n      text-align: center;\r\n      border-bottom: 1px solid #d0d0d0;\r\n      .title{\r\n        font-size: 16px;\r\n        color: #333333;\r\n        .red{\r\n          color: #FF001F;\r\n        }\r\n      }\r\n      img{\r\n        width: 40*@toVw;\r\n        border-radius: 1000px;\r\n        margin: 5*@toVw;\r\n      }\r\n      .otherIcon{\r\n        width: 40*@toVw;\r\n        height: 40*@toVw;\r\n        display: inline-block;\r\n        border-radius: 1000px;\r\n        margin: 5*@toVw;\r\n        background: #d0d0d0;\r\n      }\r\n    }\r\n    .text-content{\r\n      position: absolute;\r\n      bottom: -8px;\r\n      height: 19*@toVw;\r\n      line-height: 19*@toVw;\r\n      background: #f0f0f0;\r\n      width: 16em;\r\n      left: 50%;\r\n      margin-left: -8em;\r\n      text-align: center;\r\n      font-size: 16px;\r\n      color: #333333;\r\n      &.last{\r\n        font-size: 12px;\r\n        span{\r\n          display: inline-block;\r\n          background: #F83534;\r\n          width:1.6em;\r\n          height: 1.6em;\r\n          line-height: 1.6em;\r\n          border-radius: 3px;\r\n          color: white;\r\n          margin: 0 5px;\r\n          font-size: 12px;\r\n        }\r\n      }\r\n\r\n    }\r\n  }\r\n  .qr-block{\r\n    padding: 15*@toVw;\r\n    text-align: center;\r\n    background: #f0f0f0;\r\n    img{\r\n      width: 150*@toVw     ;\r\n    }\r\n    .text{\r\n      font-size: 14px;\r\n      line-height: 1.6em;\r\n      color: #666666;\r\n      text-align: center;\r\n    }\r\n  }\r\n  .share{\r\n    text-align: center;\r\n    padding: 10*@toVw;\r\n    font-size: 12px;\r\n    color: #333333;\r\n    line-height: 1.6em;\r\n    img{\r\n      width: 40*@toVw;\r\n    }\r\n    div{\r\n      margin-top: 10*@toVw;\r\n    }\r\n  }\r\n  .refer-share {\r\n    width: 100%;\r\n  }\r\n  .refer-share img {\r\n    position: absolute;\r\n    width: 80%;\r\n    right: 0;\r\n  }\r\n\r\n</style>\r\n<style>\r\n  .v-modal{\r\n    opacity: 0.7;\r\n  }\r\n</style>\r\n'],sourceRoot:""}])},"74Dx":function(n,e,t){var r=t("CoPr");"string"==typeof r&&(r=[[n.i,r,""]]),r.locals&&(n.exports=r.locals);t("rjj0")("75df90e1",r,!1,{})},AD5t:function(n,e){n.exports="data:image/png;base64,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"},CoPr:function(n,e,t){(n.exports=t("FZ+f")(!0)).push([n.i,"\n.fl-r[data-v-b00962cc] {\n  float: right;\n}\n.main-block[data-v-b00962cc] {\n  margin: 5px;\n  background: white;\n  padding: 5px;\n}\n.clear-both[data-v-b00962cc]:after {\n  content: '';\n  display: block;\n  clear: both;\n}\n[data-v-b00962cc]::-webkit-scrollbar-track-piece {\n  border-radius: 10px;\n}\n[data-v-b00962cc]::-webkit-scrollbar {\n  width: 5px;\n  height: 5px;\n}\n[data-v-b00962cc]::-webkit-scrollbar-thumb {\n  background-color: #999;\n  border-radius: 10px;\n  height: 10px;\n  min-height: 10px;\n}\n.block-white[data-v-b00962cc] {\n  height: 16vw;\n}\n.banner[data-v-b00962cc] {\n  padding: 2.66666667vw;\n  background: white;\n  text-align: center;\n  margin-bottom: 2.66666667vw;\n}\n.banner img[data-v-b00962cc] {\n  width: 100%;\n  display: block;\n}\n.btn-block[data-v-b00962cc] {\n  position: fixed;\n  bottom: 2.66666667vw;\n  width: 100%;\n  text-align: center;\n}\n.btn-block .btn[data-v-b00962cc] {\n  margin: 0 5.33333333vw;\n  background: #FF7171;\n  height: 10.13333333vw;\n  line-height: 10.13333333vw;\n  border-radius: 1000px;\n  font-size: 16px;\n  font-family: PingFangSC-Regular;\n  font-weight: 400;\n  color: #ffffff;\n}\n.success[data-v-b00962cc] {\n  background: #f0f0f0;\n  height: 100%;\n}\n.head[data-v-b00962cc] {\n  background: #F83534;\n  padding: 1.33333333vw;\n  text-align: center;\n  color: white;\n  font-size: 16px;\n  line-height: 1.4em;\n}\n.head img[data-v-b00962cc] {\n  width: 18px;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n.head .sec[data-v-b00962cc] {\n  font-size: 12px;\n}\n.shop-block[data-v-b00962cc] {\n  background: white;\n}\n.shop-block .shop[data-v-b00962cc] {\n  padding: 2.66666667vw;\n  border-bottom: 1px solid #d8d8d8;\n  position: relative;\n}\n.shop-block .shop[data-v-b00962cc]:after {\n  content: '';\n  display: block;\n  clear: both;\n}\n.shop-block .shop .img-block[data-v-b00962cc] {\n  float: left;\n  margin-right: 2.66666667vw;\n  min-height: 120px;\n}\n.shop-block .shop .img-block img[data-v-b00962cc] {\n  width: 33.33333333vw;\n}\n.shop-block .shop .title[data-v-b00962cc] {\n  font-size: 18px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  color: #333333;\n  margin-bottom: 0.66666667vw;\n}\n.shop-block .shop .content[data-v-b00962cc] {\n  font-size: 12px;\n  line-height: 1.4em;\n  color: #CCCCCC;\n  height: 4.2em;\n  overflow: hidden;\n}\n.shop-block .shop .price[data-v-b00962cc] {\n  font-size: 18px;\n  color: #FF001F;\n  position: absolute;\n  right: 2.66666667vw;\n  bottom: 2.66666667vw;\n}\n.success-block[data-v-b00962cc] {\n  padding: 0 5.33333333vw;\n  margin-bottom: 4vw;\n  position: relative;\n  background: #f0f0f0;\n}\n.success-block .suc-head[data-v-b00962cc] {\n  padding: 5.33333333vw 0;\n  text-align: center;\n  border-bottom: 1px solid #d0d0d0;\n}\n.success-block .suc-head .title[data-v-b00962cc] {\n  font-size: 16px;\n  color: #333333;\n}\n.success-block .suc-head .title .red[data-v-b00962cc] {\n  color: #FF001F;\n}\n.success-block .suc-head img[data-v-b00962cc] {\n  width: 10.66666667vw;\n  border-radius: 1000px;\n  margin: 1.33333333vw;\n}\n.success-block .suc-head .otherIcon[data-v-b00962cc] {\n  width: 10.66666667vw;\n  height: 10.66666667vw;\n  display: inline-block;\n  border-radius: 1000px;\n  margin: 1.33333333vw;\n  background: #d0d0d0;\n}\n.success-block .text-content[data-v-b00962cc] {\n  position: absolute;\n  bottom: -8px;\n  height: 5.06666667vw;\n  line-height: 5.06666667vw;\n  background: #f0f0f0;\n  width: 16em;\n  left: 50%;\n  margin-left: -8em;\n  text-align: center;\n  font-size: 16px;\n  color: #333333;\n}\n.success-block .text-content.last[data-v-b00962cc] {\n  font-size: 12px;\n}\n.success-block .text-content.last span[data-v-b00962cc] {\n  display: inline-block;\n  background: #F83534;\n  width: 1.6em;\n  height: 1.6em;\n  line-height: 1.6em;\n  border-radius: 3px;\n  color: white;\n  margin: 0 5px;\n  font-size: 12px;\n}\n.qr-block[data-v-b00962cc] {\n  padding: 4vw;\n  text-align: center;\n  background: #f0f0f0;\n}\n.qr-block img[data-v-b00962cc] {\n  width: 40vw;\n}\n.qr-block .text[data-v-b00962cc] {\n  font-size: 14px;\n  line-height: 1.6em;\n  color: #666666;\n  text-align: center;\n}\n.share[data-v-b00962cc] {\n  text-align: center;\n  padding: 2.66666667vw;\n  font-size: 12px;\n  color: #333333;\n  line-height: 1.6em;\n}\n.share img[data-v-b00962cc] {\n  width: 10.66666667vw;\n}\n.share div[data-v-b00962cc] {\n  margin-top: 2.66666667vw;\n}\n.refer-share[data-v-b00962cc] {\n  width: 100%;\n}\n.refer-share img[data-v-b00962cc] {\n  position: absolute;\n  width: 80%;\n  right: 0;\n}\n","",{version:3,sources:["D:/myproject/new-singsingH5/src/components/buy/D:/myproject/new-singsingH5/src/util/public.less","D:/myproject/new-singsingH5/src/components/buy/success.vue","D:/myproject/new-singsingH5/src/components/buy/D:/myproject/new-singsingH5/src/components/buy/success.vue"],names:[],mappings:";AAcA;EACE,aAAA;CCbD;ADeD;EACE,YAAA;EACA,kBAAA;EACA,aAAA;CCbD;ADmBC;EACE,YAAA;EACA,eAAA;EACA,YAAA;CCjBH;ADqBD;EACE,oBAAA;CCnBD;ADqBD;EACE,WAAA;EACA,YAAA;CCnBD;ADqBD;EACE,uBAAA;EACA,oBAAA;EACA,aAAA;EACA,iBAAA;CCnBD;AC4MD;EACE,aAAA;CD1MD;AC4MD;EACE,sBAAA;EACA,kBAAA;EACA,mBAAA;EACA,4BAAA;CD1MD;ACsMD;EAMI,YAAA;EACA,eAAA;CDzMH;AC4MD;EACE,gBAAA;EACA,qBAAA;EACA,YAAA;EACA,mBAAA;CD1MD;ACsMD;EAMI,uBAAA;EACA,oBAAA;EACA,sBAAA;EACA,2BAAA;EACA,sBAAA;EACA,gBAAA;EACA,gCAAA;EACA,iBAAA;EACA,eAAA;CDzMH;AC4MD;EACE,oBAAA;EACA,aAAA;CD1MD;AC4MD;EACE,oBAAA;EACA,sBAAA;EACA,mBAAA;EACA,aAAA;EACA,gBAAA;EACA,mBAAA;CD1MD;ACoMD;EAQI,YAAA;EACA,uBAAA;EACA,kBAAA;CDzMH;AC+LD;EAaI,gBAAA;CDzMH;AC4MD;EAEE,kBAAA;CD3MD;ACyMD;EAII,sBAAA;EACA,iCAAA;EACA,mBAAA;CD1MH;AC2MG;EACE,YAAA;EACA,eAAA;EACA,YAAA;CDzML;AC+LD;EAaM,YAAA;EACA,2BAAA;EAIA,kBAAA;CD5ML;AC0LD;EAgBQ,qBAAA;CDvMP;ACuLD;EAsBM,gBAAA;EACA,iBAAA;EACA,wBAAA;EACA,oBAAA;EACA,eAAA;EACA,4BAAA;CD1ML;AC+KD;EA8BM,gBAAA;EACA,mBAAA;EACA,eAAA;EACA,cAAA;EACA,iBAAA;CD1ML;ACwKD;EAsCM,gBAAA;EACA,eAAA;EACA,mBAAA;EACA,oBAAA;EACA,qBAAA;CD3ML;AC+MD;EACE,wBAAA;EACA,mBAAA;EACA,mBAAA;EACA,oBAAA;CD7MD;ACyMD;EAMI,wBAAA;EACA,mBAAA;EACA,iCAAA;CD5MH;ACoMD;EAUM,gBAAA;EACA,eAAA;CD3ML;ACgMD;EAaQ,eAAA;CD1MP;AC6LD;EAiBM,qBAAA;EACA,sBAAA;EACA,qBAAA;CD3ML;ACwLD;EAsBM,qBAAA;EACA,sBAAA;EACA,sBAAA;EACA,sBAAA;EACA,qBAAA;EACA,oBAAA;CD3ML;ACgLD;EA+BI,mBAAA;EACA,aAAA;EACA,qBAAA;EACA,0BAAA;EACA,oBAAA;EACA,YAAA;EACA,UAAA;EACA,kBAAA;EACA,mBAAA;EACA,gBAAA;EACA,eAAA;CD5MH;AC6MG;EACE,gBAAA;CD3ML;AC0MG;EAGI,sBAAA;EACA,oBAAA;EACA,aAAA;EACA,cAAA;EACA,mBAAA;EACA,mBAAA;EACA,aAAA;EACA,cAAA;EACA,gBAAA;CD1MP;ACgND;EACE,aAAA;EACA,mBAAA;EACA,oBAAA;CD9MD;AC2MD;EAKI,YAAA;CD7MH;ACwMD;EAQI,gBAAA;EACA,mBAAA;EACA,eAAA;EACA,mBAAA;CD7MH;ACgND;EACE,mBAAA;EACA,sBAAA;EACA,gBAAA;EACA,eAAA;EACA,mBAAA;CD9MD;ACyMD;EAOI,qBAAA;CD7MH;ACsMD;EAUI,yBAAA;CD7MH;ACgND;EACE,YAAA;CD9MD;ACgND;EACE,mBAAA;EACA,WAAA;EACA,SAAA;CD9MD",file:"success.vue",sourcesContent:["//颜色参数\n@toVw:100/375vw;\n@toVh:100/667vh;\n@bg-b: #333;\n@bg-b-s:#444;\n@black-line:#191919;\n@gray-line:#666;\n@light-line:#ddd;\n@main-font-color:#fff;\n@secondary-font-color:#999;\n@gold-color-light:#FFD04B;\n@gold-color: #a18430;\n\n//公共类\n.fl-r{\n  float: right;\n}\n.main-block{\n  margin: 5px;\n  background: white;\n  padding: 5px;\n}\nhtml{\n\n}\n.clear-both{\n  &:after{\n    content: '';\n    display: block;\n    clear: both;\n  }\n}\n//滚动条样式\n::-webkit-scrollbar-track-piece { //滚动条凹槽的颜色，还可以设置边框属性\n  border-radius: 10px;\n}\n::-webkit-scrollbar {//滚动条的宽度\n  width:5px;\n  height:5px;\n}\n::-webkit-scrollbar-thumb {//滚动条的设置\n  background-color:@secondary-font-color;\n  border-radius: 10px;\n  height: 10px;\n  min-height:10px;\n}\n",".fl-r {\n  float: right;\n}\n.main-block {\n  margin: 5px;\n  background: white;\n  padding: 5px;\n}\n.clear-both:after {\n  content: '';\n  display: block;\n  clear: both;\n}\n::-webkit-scrollbar-track-piece {\n  border-radius: 10px;\n}\n::-webkit-scrollbar {\n  width: 5px;\n  height: 5px;\n}\n::-webkit-scrollbar-thumb {\n  background-color: #999;\n  border-radius: 10px;\n  height: 10px;\n  min-height: 10px;\n}\n.block-white {\n  height: 16vw;\n}\n.banner {\n  padding: 2.66666667vw;\n  background: white;\n  text-align: center;\n  margin-bottom: 2.66666667vw;\n}\n.banner img {\n  width: 100%;\n  display: block;\n}\n.btn-block {\n  position: fixed;\n  bottom: 2.66666667vw;\n  width: 100%;\n  text-align: center;\n}\n.btn-block .btn {\n  margin: 0 5.33333333vw;\n  background: #FF7171;\n  height: 10.13333333vw;\n  line-height: 10.13333333vw;\n  border-radius: 1000px;\n  font-size: 16px;\n  font-family: PingFangSC-Regular;\n  font-weight: 400;\n  color: #ffffff;\n}\n.success {\n  background: #f0f0f0;\n  height: 100%;\n}\n.head {\n  background: #F83534;\n  padding: 1.33333333vw;\n  text-align: center;\n  color: white;\n  font-size: 16px;\n  line-height: 1.4em;\n}\n.head img {\n  width: 18px;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n.head .sec {\n  font-size: 12px;\n}\n.shop-block {\n  background: white;\n}\n.shop-block .shop {\n  padding: 2.66666667vw;\n  border-bottom: 1px solid #d8d8d8;\n  position: relative;\n}\n.shop-block .shop:after {\n  content: '';\n  display: block;\n  clear: both;\n}\n.shop-block .shop .img-block {\n  float: left;\n  margin-right: 2.66666667vw;\n  min-height: 120px;\n}\n.shop-block .shop .img-block img {\n  width: 33.33333333vw;\n}\n.shop-block .shop .title {\n  font-size: 18px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  color: #333333;\n  margin-bottom: 0.66666667vw;\n}\n.shop-block .shop .content {\n  font-size: 12px;\n  line-height: 1.4em;\n  color: #CCCCCC;\n  height: 4.2em;\n  overflow: hidden;\n}\n.shop-block .shop .price {\n  font-size: 18px;\n  color: #FF001F;\n  position: absolute;\n  right: 2.66666667vw;\n  bottom: 2.66666667vw;\n}\n.success-block {\n  padding: 0 5.33333333vw;\n  margin-bottom: 4vw;\n  position: relative;\n  background: #f0f0f0;\n}\n.success-block .suc-head {\n  padding: 5.33333333vw 0;\n  text-align: center;\n  border-bottom: 1px solid #d0d0d0;\n}\n.success-block .suc-head .title {\n  font-size: 16px;\n  color: #333333;\n}\n.success-block .suc-head .title .red {\n  color: #FF001F;\n}\n.success-block .suc-head img {\n  width: 10.66666667vw;\n  border-radius: 1000px;\n  margin: 1.33333333vw;\n}\n.success-block .suc-head .otherIcon {\n  width: 10.66666667vw;\n  height: 10.66666667vw;\n  display: inline-block;\n  border-radius: 1000px;\n  margin: 1.33333333vw;\n  background: #d0d0d0;\n}\n.success-block .text-content {\n  position: absolute;\n  bottom: -8px;\n  height: 5.06666667vw;\n  line-height: 5.06666667vw;\n  background: #f0f0f0;\n  width: 16em;\n  left: 50%;\n  margin-left: -8em;\n  text-align: center;\n  font-size: 16px;\n  color: #333333;\n}\n.success-block .text-content.last {\n  font-size: 12px;\n}\n.success-block .text-content.last span {\n  display: inline-block;\n  background: #F83534;\n  width: 1.6em;\n  height: 1.6em;\n  line-height: 1.6em;\n  border-radius: 3px;\n  color: white;\n  margin: 0 5px;\n  font-size: 12px;\n}\n.qr-block {\n  padding: 4vw;\n  text-align: center;\n  background: #f0f0f0;\n}\n.qr-block img {\n  width: 40vw;\n}\n.qr-block .text {\n  font-size: 14px;\n  line-height: 1.6em;\n  color: #666666;\n  text-align: center;\n}\n.share {\n  text-align: center;\n  padding: 2.66666667vw;\n  font-size: 12px;\n  color: #333333;\n  line-height: 1.6em;\n}\n.share img {\n  width: 10.66666667vw;\n}\n.share div {\n  margin-top: 2.66666667vw;\n}\n.refer-share {\n  width: 100%;\n}\n.refer-share img {\n  position: absolute;\n  width: 80%;\n  right: 0;\n}\n","\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n@import \"../../util/public\";\n.block-white{\n  height: 60 *@toVw;\n}\n.banner {\n  padding: 10 * @toVw;\n  background: white;\n  text-align: center;\n  margin-bottom: 10 * @toVw;\n  img {\n    width: 100%;\n    display: block;\n  }\n}\n.btn-block{\n  position: fixed;\n  bottom: 10*@toVw;\n  width: 100%;\n  text-align: center;\n  .btn{\n    margin: 0 20 * @toVw;\n    background: #FF7171;\n    height: 38 * @toVw;\n    line-height: 38 * @toVw;\n    border-radius: 1000px;\n    font-size:16px;\n    font-family:PingFangSC-Regular;\n    font-weight:400;\n    color:rgba(255,255,255,1);\n  }\n}\n.success{\n  background: #f0f0f0;\n  height: 100%;\n}\n.head{\n  background: #F83534;\n  padding: 10/7.5vw;\n  text-align: center;\n  color: white;\n  font-size: 16px;\n  line-height: 1.4em;\n  img{\n    width: 18px;\n    vertical-align: middle;\n    margin-right: 5px;\n  }\n  .sec{\n    font-size: 12px;\n  }\n}\n.shop-block{\n\n  background: white;\n  .shop{\n    padding: 20/7.5vw;\n    border-bottom: 1px solid #d8d8d8;\n    position: relative;\n    &:after{\n      content:'';\n      display: block;\n      clear: both;\n    }\n    .img-block{\n      float: left;\n      margin-right: 20/7.5vw;\n      img{\n        width: 250/7.5vw;\n      }\n      min-height: 120px;\n    }\n\n    .title{\n      font-size: 18px;\n      overflow: hidden;\n      text-overflow:ellipsis;\n      white-space: nowrap;\n      color: #333333;\n      margin-bottom: 5/7.5vw;\n    }\n    .content{\n      font-size: 12px;\n      line-height: 1.4em;\n      color: #CCCCCC;\n      height: 4.2em;\n      overflow: hidden;\n\n    }\n    .price{\n      font-size: 18px;\n      color: #FF001F;\n      position: absolute;\n      right: 20/7.5vw;\n      bottom: 20/7.5vw;\n    }\n  }\n}\n.success-block{\n  padding: 0 20*@toVw;\n  margin-bottom: 15*@toVw;\n  position: relative;\n  background: #f0f0f0;\n  .suc-head{\n    padding: 20*@toVw 0;\n    text-align: center;\n    border-bottom: 1px solid #d0d0d0;\n    .title{\n      font-size: 16px;\n      color: #333333;\n      .red{\n        color: #FF001F;\n      }\n    }\n    img{\n      width: 40*@toVw;\n      border-radius: 1000px;\n      margin: 5*@toVw;\n    }\n    .otherIcon{\n      width: 40*@toVw;\n      height: 40*@toVw;\n      display: inline-block;\n      border-radius: 1000px;\n      margin: 5*@toVw;\n      background: #d0d0d0;\n    }\n  }\n  .text-content{\n    position: absolute;\n    bottom: -8px;\n    height: 19*@toVw;\n    line-height: 19*@toVw;\n    background: #f0f0f0;\n    width: 16em;\n    left: 50%;\n    margin-left: -8em;\n    text-align: center;\n    font-size: 16px;\n    color: #333333;\n    &.last{\n      font-size: 12px;\n      span{\n        display: inline-block;\n        background: #F83534;\n        width:1.6em;\n        height: 1.6em;\n        line-height: 1.6em;\n        border-radius: 3px;\n        color: white;\n        margin: 0 5px;\n        font-size: 12px;\n      }\n    }\n\n  }\n}\n.qr-block{\n  padding: 15*@toVw;\n  text-align: center;\n  background: #f0f0f0;\n  img{\n    width: 150*@toVw     ;\n  }\n  .text{\n    font-size: 14px;\n    line-height: 1.6em;\n    color: #666666;\n    text-align: center;\n  }\n}\n.share{\n  text-align: center;\n  padding: 10*@toVw;\n  font-size: 12px;\n  color: #333333;\n  line-height: 1.6em;\n  img{\n    width: 40*@toVw;\n  }\n  div{\n    margin-top: 10*@toVw;\n  }\n}\n.refer-share {\n  width: 100%;\n}\n.refer-share img {\n  position: absolute;\n  width: 80%;\n  right: 0;\n}\n\n"],sourceRoot:""}])},IF8E:function(n,e,t){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var r=t("Jmy5"),i=t("AD5t"),o=t.n(i),s=t("4065"),a=t.n(s),c=t("zpE/"),A=t.n(c),l=t("ebUW"),d=t.n(l),h=t("CCn6"),g=t("/Bxx"),p=t.n(g),u={name:"success",data:function(){return{img:r.d,groupDetail:"",defaultUserIconUrl:o.a,shareUrl:p.a,weChatIcon:d.a,orderNo:"",shareVisible:!0,weChatQrUrl:A.a,successIconUrl:a.a,shopId:"",group_info:null,money:0,invite_code:"",groupId:"",is_captain:1,user_info:[],deadline:"",h:0,m:0,s:0}},computed:{other:function(){return Number(this.groupDetail.desc.group_number-this.this.user_info.length)}},mounted:function(){this.initPage()},methods:{toIndex:function(){this.$router.push({name:"index"})},buttonClick:function(n){this.$sa.track("buttonClick",{tabTitle:"商品",moduleTitle:"购买成功页",buttonType:"功能",buttonName:n})},enableShare:function(n){var e=this;Object(h.F)({api_list:"onMenuShareAppMessage,onMenuShareTimeline",url:window.location.href.split("#")[0]}).then(function(t){wx.config({debug:!1,appId:t.appId,timestamp:parseInt(t.timestamp),nonceStr:t.nonceStr,signature:t.signature,jsApiList:t.jsApiList});var r=e;wx.ready(function(){wx.onMenuShareTimeline({title:n.product_title,desc:n.desc,link:n.shareUrl,imgUrl:n.shareIcon||"https://cdn.singsingenglish.com/singsing/recommend/logo-refer.png",success:function(){var n="shopId="+r.shopId+"&groupId="+r.groupId+"&invite_code="+r.invite_code+"&type="+r.type+"&out_trade_no="+r.orderNo;this.trackingPage(n,"share")},cancel:function(){}}),wx.onMenuShareAppMessage({title:n.product_title,desc:n.desc,link:n.shareUrl,imgUrl:n.shareIcon||"https://cdn.singsingenglish.com/singsing/recommend/logo-refer.png",success:function(){var n="shopId="+this.shopId+"&groupId="+this.groupId+"&invite_code="+this.invite_code+"&type="+this.type+"&out_trade_no="+this.orderNo;this.trackingPage(n,"share")},cancel:function(){}})})})},onShare:function(){var n="https://wechat-test.changchangenglish.com/#/buyDetail?shopId="+this.shopId+"&groupId="+this.groupId+"&invite_code="+(this.invite_code?this.invite_code:"");this.enableShare({product_title:this.groupDetail.share_desc.title,desc:this.groupDetail.share_desc.content,shareIcon:this.groupDetail.share_desc.img[0].url||"",shareUrl:n})},initPage:function(){var n=this;this.$route.query.out_trade_no&&""!==this.$route.query.out_trade_no&&null!==this.$route.query.out_trade_no?this.orderNo=this.$route.query.out_trade_no:this.groupId=this.$route.query.groupId,Object(h.q)(this.orderNo).then(function(e){n.groupId=e.order_group_id,n.user_info=e.user_info,n.group_info=e.group_info,e.invite_id&&""!=e.invite_id?"TEACHER"===e.invite_type?n.invite_code="CC-USER-"+e.user_id:n.invite_code="CC-"+e.invite_type+"-"+e.user_id:n.invite_code="CC-USER-"+e.user_id,console.log(n.invite_code),1===n.group_info.status&&(n.shareVisible=!1),n.shopId=e.goods_id,n.money=e.money,e.group_info.deadline&&(n.deadline=e.group_info.deadline,n.leftTimer()),Object(h.h)(n.shopId).then(function(e){e.desc=JSON.parse(e.desc),e.goods_desc=JSON.parse(e.goods_desc),e.share_desc=JSON.parse(e.share_desc),n.groupDetail=e,n.onShare()})})},leftTimer:function(){var n=new Date(this.deadline.replace(/\-/g,"/"))-new Date,e=parseInt(n/1e3/60/60%24,10),t=parseInt(n/1e3/60%60,10),r=parseInt(n/1e3%60,10);e=this.checkTime(e),t=this.checkTime(t),r=this.checkTime(r),this.h=e>0?e:"00",this.m=t>0?t:"00",this.s=r>0?r:"00",window.setTimeout(this.leftTimer,1e3)},checkTime:function(n){return n<10&&(n="0"+n),n}}},b=function(){var n=this,e=n.$createElement,t=n._self._c||e;return t("div",{staticClass:"success"},[t("mt-popup",{staticClass:"refer-share",attrs:{position:"top"},model:{value:n.shareVisible,callback:function(e){n.shareVisible=e},expression:"shareVisible"}},[t("img",{attrs:{src:n.shareUrl}})]),n._v(" "),t("div",{staticClass:"banner"},[t("img",{attrs:{src:n.img.weChat}})]),n._v(" "),n.groupDetail?t("div",{staticClass:"shop-block"},[t("div",{staticClass:"shop"},[t("div",{staticClass:"img-block"},[t("img",{attrs:{src:n.groupDetail.goods_desc.img[0].url}})]),n._v(" "),t("div",[t("div",{staticClass:"title"},[n._v("\n          "+n._s(n.groupDetail.name)+"\n        ")]),n._v(" "),t("div",{staticClass:"content"},[n._v("\n          "+n._s(n.groupDetail.goods_desc.desc)+"\n        ")]),n._v(" "),t("div",{staticClass:"price"},[n._v("\n          价格 ￥"+n._s(n.money/100)+"\n        ")])])])]):n._e(),n._v(" "),n.groupDetail?t("div",{staticClass:"success-block"},[n.group_info&&1!==n.group_info.status?t("div",{staticClass:"text-content last"},[n._v("\n      剩余\n      "),t("span",[n._v(n._s(n.h))]),n._v(":"),t("span",[n._v(n._s(n.m))]),n._v(":"),t("span",[n._v(n._s(n.s))]),n._v("\n      结束\n    ")]):n._e(),n._v(" "),t("div",{staticClass:"suc-head"},[n._l(n.user_info,function(e,r){return n.group_info?t("img",{key:r,attrs:{src:e.avatar}}):n._e()}),n._v(" "),n._l(n.groupDetail.desc.group_number-n.user_info.length,function(e){return n.group_info&&1!==n.group_info.status?t("img",{attrs:{src:n.defaultUserIconUrl}}):n._e()}),n._v(" "),n.group_info&&1!==n.group_info.status?t("div",{staticClass:"title"},[n._v("\n        还差"),t("span",{staticClass:"red"},[n._v(n._s(n.groupDetail.desc.group_number-n.user_info.length))]),n._v("人成团，赶快邀请好友来拼单吧\n      ")]):n._e()],2),n._v(" "),n.group_info&&1===n.group_info.status?t("div",{staticClass:"text-content"},[n._v("\n      恭喜您已成功拼团\n    ")]):n._e()]):n._e(),n._v(" "),t("div",{staticClass:"block-white"}),n._v(" "),t("div",{staticClass:"btn-block"},[n.group_info&&1!==n.group_info.status?t("div",{staticClass:"btn",on:{click:function(e){n.shareVisible=!0,n.buttonClick("分享")}}},[n._v("\n      继续分享\n    ")]):n._e(),n._v(" "),n.group_info&&1===n.group_info.status?t("div",{staticClass:"btn",on:{click:function(e){n.toIndex(),n.buttonClick("去上课")}}},[n._v("\n      快去上课\n    ")]):n._e()])],1)};b._withStripped=!0;var m={render:b,staticRenderFns:[]},f=m;var v=!1;var C=t("VU/8")(u,f,!1,function(n){v||(t("74Dx"),t("MTta"))},"data-v-b00962cc",null);C.options.__file="src/components/buy/success.vue";e.default=C.exports},MTta:function(n,e,t){var r=t("6ZIX");"string"==typeof r&&(r=[[n.i,r,""]]),r.locals&&(n.exports=r.locals);t("rjj0")("35a6b480",r,!1,{})},ebUW:function(n,e){n.exports="data:image/jpeg;base64,iVBORw0KGgoAAAANSUhEUgAAAGUAAABmCAYAAADS6F9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTM4IDc5LjE1OTgyNCwgMjAxNi8wOS8xNC0wMTowOTowMSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTcgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkQzQzEyODFCODEwNTExRThBN0REQTc3OEYzNDJCMDIzIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkQzQzEyODFDODEwNTExRThBN0REQTc3OEYzNDJCMDIzIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6RDNDMTI4MTk4MTA1MTFFOEE3RERBNzc4RjM0MkIwMjMiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RDNDMTI4MUE4MTA1MTFFOEE3RERBNzc4RjM0MkIwMjMiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz4rmj3VAAAN/UlEQVR42uxdCXgURRb+k0zuhNzhCiHEgAlICCBKAAU5VuQQUVFBXHWRddUVEBXx+xR3V931wAVxFY8lwhJBEDlEwFUMAQLCihgIN5KEnOSahJyTc7ZeT0VDrpnMVPf0JPPzPUiG7uqq909VvffqVbXDyEMToHI4M4lkcgOTAUzCmfRhEsjFjYkXv66WSTkTHZNCLplMUplcYHKKyTl+nWqhUWGdSMm3MRnHZAyT4UxcO0CgH/+5ZxvXVDP5iUkSk/1MEjiJqoGDSnqKD5MZTGYxGc/EQ8FnV3JivmCyg8nVrtxTHJiMZTKfyd28h1gD9AWYxoV60ZdMPuG9SG+NCjla4ZkuTB5mcpLJPiZzrEhIc7jy+lC9TvB6unRmUjS8V/zCZC2fuNWMwbyeVN8/KjmqKEXKnUzOMvmYW062BKrvR7z+MzoDKf2Y7OYTaARsG1T/7bw9/WyRFJrEFzJJYXIHOhfu4O1axNtpE6QEMNnJZCUTT3ROULtW8HYGqJ2UkUyOM5mKroGpvL0j1UoKDVcHmISiayGUt3uhmkhxYvIvPlw5o2vCmbf/fa4Pq5LiwsMTT8EOwpNMtljqcFpCijs3dWfaubgGd3G9eChNCn0TKEY02c5Bq5jM9eOiFCk0ZsZ3Qv9DDmI2mDPHmEPKuzCE2O0wjnuYLJeblMftk3qHsYjrTRZSYpmssuvYLJDeRokmhUIJm2GFtYVOAtLbJpgYkjGVFFqJC7Hr1iKEcD0KIeVRuy8iDDO5Pi0iJdgc68GOdkH67G4JKf9k4m/Xo1D4c72aRQpZC3PsOpQFs5mM7igptKK2AjKtrNnRvn7bytCgRIeblK6pj3M3hLqFIMo7En3ceiPQxZ/93kf63IHXv7SuDBm6LOTq8pCty8bZ8vPI0uWgpPaqrREzgut5RwvGWsmQpNYnM4lWombuTm4Y5jMEo/xuxviAsfDV+HS4jKt1pfix5DgOaA/hSMkxlDHibASU+xaDZkl/rZFCS5xfy10bT40nJgXehtm97pV6hygU15Zgfc4m7Mn/1lZ6zxQme4yRQtmB4+Ssxa0Bo/F02OMIce0l2zPK6yuwJnMdtl7ZiZoGVSfZJ8KQ0N4mKZS1mCLX07uxuWEBI2Nq0O2KtTil7DTeuLQCqZXpaiaGsjFPtWV9zZPrqT3deiB+yCeKEiK11nsQPov5N0b536xmUv7QlklMi/9z5Xhib/ee2BgThyCXAKu1+p3I1zGzx3S1kjIXTZJOmpJC41ig6KcFuwZhU8xauDpaP8C8JHwhbg9W5c61IK7/FqTcJ/pJzo7OWBu9Gk4Opq2INugbzH6Wqff+JeJFxPgMViMxs5o7j46QIatxQdgT8HP2NXpdXFY8DmoPSyYsDXHPXbcAAzxMywc/VHwEnzArS1tTjG4ab8zpNQtTgn/X7j3vDVyOO368G+V1FWoiZRr3EfWN1tcwGPYBCkOIe298MXSd0eveSluJbbnXukVeGi/sGL4RHk7u7d67X5uEpef+0uLzj6NXYbDXwHbv/a4wAcsu/F1tvYX2dx5vHL4mii59cT/TlvITCg+09DHqypFWZdyE3XaldR83seig0XsnBY5HX3fVbZWZ2HROGSPU2nLrhVhf00JnvVxb38Tr5+xn9N5wz9a3iYS4meaUzg15QG2kjGlKitCs8Vj/ESZf+3LEEvRhQ11T3NVjKnq6djd677yQhzDUZ8g1n0X73IDpwaalpE1jPlOAi6qWi2IbJ/re3CQThgn+Y02+tp9HX2xmc8/u/O+QyoasWN8RGO4TY9K9nk4e+GDQO/jf1Z+kgGSoRwimB7VPyKmyM8ivLYCj3gmeGg/4sx5ZVKNVCynkkoQSKcKjwVFekR2+Z0rwJLOfd5PPcEmaQ9egk+adRO1BXK7MlML+ZJ43sD8aBw0zKAx7mujnOn2dakIuRMog0aU6OThatVWny88xM3ktjhYfM9j7rD6DvKMQ6h6CUWyu6+seimp9NXycfFDPCNIzH6e0rhS/VKbiYkUqfrqajGxdDur19daofhSREia6VAcrLVjWNtRiyfllOFL8o/T7kG434KHeszHK7yaT6kRxskacKT+Pr/J3IUl7ROnhLUwWUqyBhKL9eOXCP6Rh6EbfoXjxumeZZdfD7PIGel0vSVWYDvHZm7Ald7s0/ClFSrDoUhv0ejaEKUfI22nvYmvuTil68FL/JdIQJQrujm6Y3+dhzOoxEy9ffA3HSo7L3ZxgGvzF24QKEvJu+ocSIVHe12P3iC1CCWkKX+dueG/gW9LinMwIIFKEx9NTq9IUIeTDzDh8nrMFY/xHIm7w+4o8k2JrSyMWy/m98ydSnESXmliUJLtyLpZfwrrMDYjwCsfbka8pOn/NCJ6CZf2XylW8hkjxFl3qfgVIeeLMYmlpYH30x1YxLCYHTcRdPabJUbSXLA5FWuVlpDDPWS6szdqAiroKvBH5V6PXFtQWYmX6asRlrTfJeiqq1WIVm6fWZbNn1Fe2e+0L4YvQ3U24nSQlTpTK0VvCPPpiY8waWUgZ88PtCHINxLZhn7U/t1Wm47GUp1FVXyX97q3xwvKBryPaq3V/OVOXhfkpC3C1ttQwuDv74e2oV5lp3HaEgkI8C0+/ILJ55dRTZHFb01lv+TLvK+Hlfle0T/K0nw1/2ui1W/N2/koIoayunPkbO9q8Pj5n86+EELS1xdiW97XREA/F3ASijkgpkmuYWZH6PkqaNFIESKkUvxrjazywfbPvjS0+G+s/um0F+7aMn1HmpjFMCZoksolaIkW2GAJ9o+eeeAy1AoN958svItKrv0nX3uIXi+VRr2Fwt0HSuvzr1y/DhIC2I9gU3X51wMtSnGyYbwxWDHoDt/nfYvQ5EwLGiVRbEXn0+XJaKRQ3euDnR7Fp6KdSNNYS1OhrUN1QzUgZYPI9o/1GSmIqJgaOlaQj6GFBOKcV5FNPSZfbfMzR5eLu43NxpbrAonIo/E6BxX7uYVATBDuS6YqQIpmm1YV4+OTj2K89ZHYZeTUF0LM/fs4+KiPFQTgpZ5WqfCmb9JeeewU78/eYdT+tFBp8iWJVkaIXe3zxWSIlWelGBLqYl4gZ4W5IlMiqylYVKZYkEbaCFCKFWligVAPCPftK6/DmwFvjDRdHF5wsO60qUk6UnRJVFL0wIaPRHDrCRJHs59F+sS0+26c9gB1XdjNnTSuZo2Hufdm/kQh2CZaSI1wcnKU4F6G/ZzjOlJ1HHTO3NQ5OqiBle56wPVY/0F+NpCQpRco93X87b5lSVeNzNuFk6W/ffFojbwRtvaP8Ly8nTylbkoaJTF2ONIYfLD5skg8hN2oaanBIe0RUcUlNSdmrRANu8Y9Fd9cgfFuUIHnmKaXtD0NV9Tomua3+35qM9aog5W+X3oSuoVpUcXubkpLMnchguSpPZqMr++YvOrv01ywTS3CpMhXfFO7F5MCJViMkuTQF3xfsF+Y0MvmZfmgM3ZP5sEtus3FvwT4hhDTizUsrRX5LOxxCev7cSyKL3AW+S7jpesoXsDHo2PD2yMknYI3XnNyX/IjorRSbG39wbDaeFdkaMZcrM/Dn089Dr1eGGJrY5yTPQ05VrshiyRT+vjVSaF/zetggKKPxwROP4Up1nqzPyWPl35/8qLSyKhjxaPLytubLwWtgoyBF/f7En7AhV55R+OjVY5jNesgVnSzEX6P35qSQa5poq8TQ8R/vpX2Ep04/i8MlRwWHUvSSiS4DEtFkDz3BKWReePOLaF6x6SOlctkw821BAnMwf0BZfbkUVfZ28oaDg/FoLs1NaVWXUVJbcs1+TTrAh7bk0TkwgkFb3i42/UDThmlGB7lEw8ZxofyiJHHM0aStdOEeYejvGYFuzl5SpIAO56GJO0uXLa3Nn6u4wPyfNGRV5UgE3uo/Ck+GzkcvN8MiFh3sk1GVJbKKpOcWIfO23vNI57VvQycHObTGwu7uTu7SWTJLw5+RfJNJR2eIDNXTmZLbm3/Y2vBFOA/D6Tq90cVBWfyXKlKlNSBXR1dksl5FWTECQPs1nmv1y9LOG1HpuMIk2E/HkyfAAVDgrtVl2PYyJA8z2WjXnyz4vC1CjJFCeAYypiB1UWi5XmEuKfltjXt2mA3SZ54lpBA+7QqWmELYxvUJS0kh0Dt/s+w6tQjZXI8QRQp5+fczqbHr1iyQ3u6DiVH4juxPIWtsgV2/ZmEB1x9Ek0Kgt02vtuu4Q1jF9Qa5SCHQxpAtdl2bhK1MFnf0JnNIoU1GDzL5xq7zdkH6mQ0zNmWZu+eRJq577MS0if9y/ZhlGFmyEZV2aVJm3XY7B9eA9u/dyfUDpUlp7DH3MvnAzoWE1Zb0EFGkNM4xtHpG8ZzaLkpGLW//kxCwsVfkPnp69fetTDK6GCEZvN0rRRUo+nADynSm43R3dRFCdvH2HhFZqBwnTlAogTL46fWsFZ2UjEruf0yHDAmMcp0rSCtr9OJnOr98TycjhNpDrzRZAZnyZeU+7JHOmKK1fkrE+MXGyaD6z+TtkfXsLKVO4CTbPQqGt01n2hgZmbzeA5XyyZQ8FpWOnaBzoOjNAvTynDMqJ+MMr2cEr7di5r41zqolxyqOj8vjYUjOqFYJEdW8PuN5/eJghTUkjRUVQJPkPi50WgGFbGghiHKe3BSsByUIJ8CwP4SGJ6u/8k6jkm8oKeI/XOgEg3EwvNGNcs/oaCFXwb2BXktymH8hEmFBnKozk9LcB9jNheDMjQQyr+n4IjrhIBSGc+EDOWE+fChu4AST4gu5ZHBriZKo6c18Z6HycND/BRgAR+sQLILKaTMAAAAASUVORK5CYII="}});
//# sourceMappingURL=8.be4ed60496a08edbe14e.js.map